/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class SpawnerAnimals {
    private int maxSpawns;
    private Class entityType;
    private Class[] entities;
    private Set eligibleChunksForSpawning = new HashSet();

    public SpawnerAnimals(int var1, Class var2, Class[] var3) {
        this.maxSpawns = var1;
        this.entityType = var2;
        this.entities = var3;
    }

    public void onUpdate(World var1) {
        int var2 = var1.countEntities(this.entityType);
        if (var2 < this.maxSpawns) {
            for (int var3 = 0; var3 < 3; ++var3) {
                this.performSpawning(var1, 1, null);
            }
        }
    }

    protected ChunkPosition getRandomSpawningPointInChunk(World var1, int var2, int var3) {
        int var4 = var2 + var1.rand.nextInt(16);
        int var5 = var1.rand.nextInt(128);
        int var6 = var3 + var1.rand.nextInt(16);
        return new ChunkPosition(var4, var5, var6);
    }

    private int performSpawning(World var1, int var2, IProgressUpdate var3) {
        int var10;
        int var9;
        int var7;
        int var4;
        this.eligibleChunksForSpawning.clear();
        for (var4 = 0; var4 < var1.playerEntities.size(); ++var4) {
            EntityPlayer var5 = (EntityPlayer)var1.playerEntities.get(var4);
            int var6 = MathHelper.floor_double(var5.posX / 16.0);
            var7 = MathHelper.floor_double(var5.posZ / 16.0);
            int var8 = 4;
            for (var9 = -var8; var9 <= var8; ++var9) {
                for (var10 = -var8; var10 <= var8; ++var10) {
                    this.eligibleChunksForSpawning.add(new ChunkCoordIntPair(var9 + var6, var10 + var7));
                }
            }
        }
        var4 = 0;
        for (ChunkCoordIntPair var27 : this.eligibleChunksForSpawning) {
            if (var1.rand.nextInt(10) != 0) continue;
            var7 = var1.rand.nextInt(this.entities.length);
            ChunkPosition var28 = this.getRandomSpawningPointInChunk(var1, var27.chunkXPos * 16, var27.chunkZPos * 16);
            var9 = var28.x;
            var10 = var28.y;
            int var11 = var28.z;
            if (var1.isBlockNormalCube(var9, var10, var11)) {
                return 0;
            }
            if (var1.getBlockMaterial(var9, var10, var11) != Material.air) {
                return 0;
            }
            for (int var12 = 0; var12 < 3; ++var12) {
                int var13 = var9;
                int var14 = var10;
                int var15 = var11;
                int var16 = 6;
                for (int var17 = 0; var17 < 2; ++var17) {
                    EntityLiving var29;
                    float var23;
                    float var22;
                    float var21;
                    float var24;
                    float var20;
                    float var19;
                    float var18;
                    if (!var1.isBlockNormalCube(var13 += var1.rand.nextInt(var16) - var1.rand.nextInt(var16), (var14 += var1.rand.nextInt(1) - var1.rand.nextInt(1)) - 1, var15 += var1.rand.nextInt(var16) - var1.rand.nextInt(var16)) || var1.isBlockNormalCube(var13, var14, var15) || var1.getBlockMaterial(var13, var14, var15).getIsLiquid() || var1.isBlockNormalCube(var13, var14 + 1, var15) || var1.getClosestPlayer(var18 = (float)var13 + 0.5f, var19 = (float)var14, var20 = (float)var15 + 0.5f, 24.0) != null || !((var24 = (var21 = var18 - (float)var1.spawnX) * var21 + (var22 = var19 - (float)var1.spawnY) * var22 + (var23 = var20 - (float)var1.spawnZ) * var23) >= 576.0f)) continue;
                    try {
                        var29 = (EntityLiving)this.entities[var7].getConstructor(World.class).newInstance(var1);
                    }
                    catch (Exception var25) {
                        var25.printStackTrace();
                        return var4;
                    }
                    var29.setLocationAndAngles(var18, var19, var20, var1.rand.nextFloat() * 360.0f, 0.0f);
                    if (!var29.getCanSpawnHere()) continue;
                    ++var4;
                    var1.spawnEntityInWorld(var29);
                    if (!(var29 instanceof EntitySpider) || var1.rand.nextInt(100) != 0) continue;
                    EntitySkeleton var30 = new EntitySkeleton(var1);
                    var30.setLocationAndAngles(var18, var19, var20, var29.rotationYaw, 0.0f);
                    var1.spawnEntityInWorld(var30);
                    var30.mountEntity(var29);
                }
            }
        }
        return var4;
    }
}

