/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.Render;
import org.lwjgl.opengl.GL11;

public class RenderLiving<T extends EntityLiving>
extends Render<T> {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;

    public RenderLiving(ModelBase var1, float var2) {
        this.mainModel = var1;
        this.shadowSize = var2;
    }

    public void setRenderPassModel(ModelBase var1) {
        this.renderPassModel = var1;
    }

    @Override
    public void doRender(T var1, double var2, double var4, double var6, float var8, float var9) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.swingProgress = this.renderSwingProgress(var1, var9);
        boolean bl = this.mainModel.isRiding = ((EntityLiving)var1).ridingEntity != null;
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        try {
            float var14;
            float var10 = ((EntityLiving)var1).prevRenderYawOffset + (((EntityLiving)var1).renderYawOffset - ((EntityLiving)var1).prevRenderYawOffset) * var9;
            float var11 = ((EntityLiving)var1).prevRotationYaw + (((EntityLiving)var1).rotationYaw - ((EntityLiving)var1).prevRotationYaw) * var9;
            float var12 = ((EntityLiving)var1).prevRotationPitch + (((EntityLiving)var1).rotationPitch - ((EntityLiving)var1).prevRotationPitch) * var9;
            GL11.glTranslatef((float)((float)var2), (float)((float)var4), (float)((float)var6));
            float var13 = this.handleRotationFloat(var1, var9);
            GL11.glRotatef((float)(180.0f - var10), (float)0.0f, (float)1.0f, (float)0.0f);
            if (((EntityLiving)var1).deathTime > 0) {
                var14 = ((float)((EntityLiving)var1).deathTime + var9 - 1.0f) / 20.0f * 1.6f;
                if ((var14 = MathHelper.sqrt_float(var14)) > 1.0f) {
                    var14 = 1.0f;
                }
                GL11.glRotatef((float)(var14 * this.getDeathMaxRotation(var1)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            var14 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(var1, var9);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * var14 - 0.0078125f), (float)0.0f);
            float var15 = ((EntityLiving)var1).prevLimbYaw + (((EntityLiving)var1).limbYaw - ((EntityLiving)var1).prevLimbYaw) * var9;
            float var16 = ((EntityLiving)var1).limbSwing - ((EntityLiving)var1).limbYaw * (1.0f - var9);
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            this.loadDownloadableImageTexture(((EntityLiving)var1).skinUrl, ((EntityLiving)var1).getTexture());
            GL11.glEnable((int)3008);
            this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
            for (int var17 = 0; var17 < 4; ++var17) {
                if (!this.shouldRenderPass(var1, var17)) continue;
                this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderEquippedItems(var1, var9);
            float var25 = ((Entity)var1).getBrightness(var9);
            int var18 = this.getColorMultiplier(var1, var25, var9);
            if ((var18 >> 24 & 0xFF) > 0 || ((EntityLiving)var1).hurtTime > 0 || ((EntityLiving)var1).deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (((EntityLiving)var1).hurtTime > 0 || ((EntityLiving)var1).deathTime > 0) {
                    GL11.glColor4f((float)var25, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    for (int var19 = 0; var19 < 4; ++var19) {
                        if (!this.shouldRenderPass(var1, var19)) continue;
                        GL11.glColor4f((float)var25, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    }
                }
                if ((var18 >> 24 & 0xFF) > 0) {
                    float var26 = (float)(var18 >> 16 & 0xFF) / 255.0f;
                    float var20 = (float)(var18 >> 8 & 0xFF) / 255.0f;
                    float var21 = (float)(var18 & 0xFF) / 255.0f;
                    float var22 = (float)(var18 >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)var26, (float)var20, (float)var21, (float)var22);
                    this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    for (int var23 = 0; var23 < 4; ++var23) {
                        if (!this.shouldRenderPass(var1, var23)) continue;
                        GL11.glColor4f((float)var26, (float)var20, (float)var21, (float)var22);
                        this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception var24) {
            var24.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    protected float renderSwingProgress(T var1, float var2) {
        return ((EntityLiving)var1).getSwingProgress(var2);
    }

    protected float handleRotationFloat(T var1, float var2) {
        return (float)((EntityLiving)var1).ticksExisted + var2;
    }

    protected void renderEquippedItems(T var1, float var2) {
    }

    protected boolean shouldRenderPass(T var1, int var2) {
        return false;
    }

    protected float getDeathMaxRotation(T var1) {
        return 90.0f;
    }

    protected int getColorMultiplier(T var1, float var2, float var3) {
        return 0;
    }

    protected void preRenderCallback(T var1, float var2) {
    }
}

