/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.BlockRedstoneWire;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    private IBlockAccess blockAccess;
    private int overrideBlockTexture = -1;
    private boolean flipTexture = false;
    private boolean renderAllFaces = false;

    public RenderBlocks(IBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
    }

    public RenderBlocks() {
    }

    public void renderBlockUsingTexture(Block block, int var2, int var3, int var4, int var5) {
        this.overrideBlockTexture = var5;
        this.renderBlockByRenderType(block, var2, var3, var4);
        this.overrideBlockTexture = -1;
    }

    public boolean renderBlockByRenderType(Block block, int x, int y, int z) {
        int var5 = block.getRenderType();
        block.setBlockBoundsBasedOnState(this.blockAccess, x, y, z);
        return var5 == 0 ? this.renderStandardBlock(block, x, y, z) : (var5 == 4 ? this.renderBlockFluids(block, x, y, z) : (var5 == 13 ? this.renderBlockCactus(block, x, y, z) : (var5 == 1 ? this.renderBlockReed(block, x, y, z) : (var5 == 6 ? this.renderBlockCrops(block, x, y, z) : (var5 == 2 ? this.renderBlockTorch(block, x, y, z) : (var5 == 3 ? this.renderBlockFire(block, x, y, z) : (var5 == 5 ? this.renderBlockRedstoneWire(block, x, y, z) : (var5 == 8 ? this.renderBlockLadder(block, x, y, z) : (var5 == 7 ? this.renderBlockDoor(block, x, y, z) : (var5 == 9 ? this.renderBlockMinecartTrack(block, x, y, z) : (var5 == 10 ? this.renderBlockStairs(block, x, y, z) : (var5 == 11 ? this.renderBlockFence(block, x, y, z) : (var5 == 12 ? this.renderBlockLever(block, x, y, z) : false)))))))))))));
    }

    public boolean renderBlockTorch(Block block, int x, int y, int z) {
        int var5 = this.blockAccess.getBlockMetadata(x, y, z);
        Tessellator var6 = Tessellator.instance;
        float var7 = block.getBlockBrightness(this.blockAccess, x, y, z);
        if (Block.lightValue[block.blockID] > 0) {
            var7 = 1.0f;
        }
        var6.setColorOpaque_F(var7, var7, var7);
        double var8 = 0.4f;
        double var10 = 0.5 - var8;
        double var12 = 0.2f;
        if (var5 == 1) {
            this.renderTorchAtAngle(block, (double)x - var10, (double)y + var12, z, -var8, 0.0);
        } else if (var5 == 2) {
            this.renderTorchAtAngle(block, (double)x + var10, (double)y + var12, z, var8, 0.0);
        } else if (var5 == 3) {
            this.renderTorchAtAngle(block, x, (double)y + var12, (double)z - var10, 0.0, -var8);
        } else if (var5 == 4) {
            this.renderTorchAtAngle(block, x, (double)y + var12, (double)z + var10, 0.0, var8);
        } else {
            this.renderTorchAtAngle(block, x, y, z, 0.0, 0.0);
        }
        return true;
    }

    public boolean renderBlockLever(Block block, int x, int y, int z) {
        boolean var9;
        int var5 = this.blockAccess.getBlockMetadata(x, y, z);
        int var6 = var5 & 7;
        boolean var7 = (var5 & 8) > 0;
        Tessellator var8 = Tessellator.instance;
        boolean bl = var9 = this.overrideBlockTexture >= 0;
        if (!var9) {
            this.overrideBlockTexture = Block.cobblestone.blockIndexInTexture;
        }
        float var10 = 0.25f;
        float var11 = 0.1875f;
        float var12 = 0.1875f;
        if (var6 == 5) {
            block.setBlockBounds(0.5f - var11, 0.0f, 0.5f - var10, 0.5f + var11, var12, 0.5f + var10);
        } else if (var6 == 6) {
            block.setBlockBounds(0.5f - var10, 0.0f, 0.5f - var11, 0.5f + var10, var12, 0.5f + var11);
        } else if (var6 == 4) {
            block.setBlockBounds(0.5f - var11, 0.5f - var10, 1.0f - var12, 0.5f + var11, 0.5f + var10, 1.0f);
        } else if (var6 == 3) {
            block.setBlockBounds(0.5f - var11, 0.5f - var10, 0.0f, 0.5f + var11, 0.5f + var10, var12);
        } else if (var6 == 2) {
            block.setBlockBounds(1.0f - var12, 0.5f - var10, 0.5f - var11, 1.0f, 0.5f + var10, 0.5f + var11);
        } else if (var6 == 1) {
            block.setBlockBounds(0.0f, 0.5f - var10, 0.5f - var11, var12, 0.5f + var10, 0.5f + var11);
        }
        this.renderStandardBlock(block, x, y, z);
        if (!var9) {
            this.overrideBlockTexture = -1;
        }
        float var13 = block.getBlockBrightness(this.blockAccess, x, y, z);
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var8.setColorOpaque_F(var13, var13, var13);
        int var14 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var14 = this.overrideBlockTexture;
        }
        int var15 = (var14 & 0xF) << 4;
        int var16 = var14 & 0xF0;
        float var17 = (float)var15 / 256.0f;
        float var18 = ((float)var15 + 15.99f) / 256.0f;
        float var19 = (float)var16 / 256.0f;
        float var20 = ((float)var16 + 15.99f) / 256.0f;
        Vec3D[] var21 = new Vec3D[8];
        float var22 = 0.0625f;
        float var23 = 0.0625f;
        float var24 = 0.625f;
        var21[0] = Vec3D.createVector(-var22, 0.0, -var23);
        var21[1] = Vec3D.createVector(var22, 0.0, -var23);
        var21[2] = Vec3D.createVector(var22, 0.0, var23);
        var21[3] = Vec3D.createVector(-var22, 0.0, var23);
        var21[4] = Vec3D.createVector(-var22, var24, -var23);
        var21[5] = Vec3D.createVector(var22, var24, -var23);
        var21[6] = Vec3D.createVector(var22, var24, var23);
        var21[7] = Vec3D.createVector(-var22, var24, var23);
        for (int var25 = 0; var25 < 8; ++var25) {
            if (var7) {
                var21[var25].zCoord -= 0.0625;
                var21[var25].rotateAroundX(0.69813174f);
            } else {
                var21[var25].zCoord += 0.0625;
                var21[var25].rotateAroundX(-0.69813174f);
            }
            if (var6 == 6) {
                var21[var25].rotateAroundY(1.5707964f);
            }
            if (var6 < 5) {
                var21[var25].yCoord -= 0.375;
                var21[var25].rotateAroundX(1.5707964f);
                if (var6 == 4) {
                    var21[var25].rotateAroundY(0.0f);
                }
                if (var6 == 3) {
                    var21[var25].rotateAroundY((float)Math.PI);
                }
                if (var6 == 2) {
                    var21[var25].rotateAroundY(1.5707964f);
                }
                if (var6 == 1) {
                    var21[var25].rotateAroundY(-1.5707964f);
                }
                var21[var25].xCoord += (double)x + 0.5;
                var21[var25].yCoord += (double)((float)y + 0.5f);
                var21[var25].zCoord += (double)z + 0.5;
                continue;
            }
            var21[var25].xCoord += (double)x + 0.5;
            var21[var25].yCoord += (double)((float)y + 0.125f);
            var21[var25].zCoord += (double)z + 0.5;
        }
        Vec3D var30 = null;
        Vec3D var26 = null;
        Vec3D var27 = null;
        Vec3D var28 = null;
        for (int var29 = 0; var29 < 6; ++var29) {
            if (var29 == 0) {
                var17 = (float)(var15 + 7) / 256.0f;
                var18 = ((float)(var15 + 9) - 0.01f) / 256.0f;
                var19 = (float)(var16 + 6) / 256.0f;
                var20 = ((float)(var16 + 8) - 0.01f) / 256.0f;
            } else if (var29 == 2) {
                var17 = (float)(var15 + 7) / 256.0f;
                var18 = ((float)(var15 + 9) - 0.01f) / 256.0f;
                var19 = (float)(var16 + 6) / 256.0f;
                var20 = ((float)(var16 + 16) - 0.01f) / 256.0f;
            }
            if (var29 == 0) {
                var30 = var21[0];
                var26 = var21[1];
                var27 = var21[2];
                var28 = var21[3];
            } else if (var29 == 1) {
                var30 = var21[7];
                var26 = var21[6];
                var27 = var21[5];
                var28 = var21[4];
            } else if (var29 == 2) {
                var30 = var21[1];
                var26 = var21[0];
                var27 = var21[4];
                var28 = var21[5];
            } else if (var29 == 3) {
                var30 = var21[2];
                var26 = var21[1];
                var27 = var21[5];
                var28 = var21[6];
            } else if (var29 == 4) {
                var30 = var21[3];
                var26 = var21[2];
                var27 = var21[6];
                var28 = var21[7];
            } else if (var29 == 5) {
                var30 = var21[0];
                var26 = var21[3];
                var27 = var21[7];
                var28 = var21[4];
            }
            var8.addVertexWithUV(var30.xCoord, var30.yCoord, var30.zCoord, var17, var20);
            var8.addVertexWithUV(var26.xCoord, var26.yCoord, var26.zCoord, var18, var20);
            var8.addVertexWithUV(var27.xCoord, var27.yCoord, var27.zCoord, var18, var19);
            var8.addVertexWithUV(var28.xCoord, var28.yCoord, var28.zCoord, var17, var19);
        }
        return true;
    }

    public boolean renderBlockFire(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        int var6 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var6 = this.overrideBlockTexture;
        }
        float var7 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var7, var7, var7);
        int var8 = (var6 & 0xF) << 4;
        int var9 = var6 & 0xF0;
        double var10 = (float)var8 / 256.0f;
        double var12 = ((float)var8 + 15.99f) / 256.0f;
        double var14 = (float)var9 / 256.0f;
        double var16 = ((float)var9 + 15.99f) / 256.0f;
        float var18 = 1.4f;
        if (!this.blockAccess.isBlockNormalCube(x, y - 1, z) && !Block.fire.canBlockCatchFire(this.blockAccess, x, y - 1, z)) {
            double var21;
            float var37 = 0.2f;
            float var20 = 0.0625f;
            if ((x + y + z & 1) == 1) {
                var10 = (float)var8 / 256.0f;
                var12 = ((float)var8 + 15.99f) / 256.0f;
                var14 = (float)(var9 + 16) / 256.0f;
                var16 = ((float)var9 + 15.99f + 16.0f) / 256.0f;
            }
            if ((x / 2 + y / 2 + z / 2 & 1) == 1) {
                var21 = var12;
                var12 = var10;
                var10 = var21;
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, x - 1, y, z)) {
                var5.addVertexWithUV((float)x + var37, (float)y + var18 + var20, z + 1, var12, var14);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 1, var12, var16);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV((float)x + var37, (float)y + var18 + var20, z + 0, var10, var14);
                var5.addVertexWithUV((float)x + var37, (float)y + var18 + var20, z + 0, var10, var14);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 1, var12, var16);
                var5.addVertexWithUV((float)x + var37, (float)y + var18 + var20, z + 1, var12, var14);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, x + 1, y, z)) {
                var5.addVertexWithUV((float)(x + 1) - var37, (float)y + var18 + var20, z + 0, var10, var14);
                var5.addVertexWithUV(x + 1 - 0, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV(x + 1 - 0, (float)(y + 0) + var20, z + 1, var12, var16);
                var5.addVertexWithUV((float)(x + 1) - var37, (float)y + var18 + var20, z + 1, var12, var14);
                var5.addVertexWithUV((float)(x + 1) - var37, (float)y + var18 + var20, z + 1, var12, var14);
                var5.addVertexWithUV(x + 1 - 0, (float)(y + 0) + var20, z + 1, var12, var16);
                var5.addVertexWithUV(x + 1 - 0, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV((float)(x + 1) - var37, (float)y + var18 + var20, z + 0, var10, var14);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, x, y, z - 1)) {
                var5.addVertexWithUV(x + 0, (float)y + var18 + var20, (float)z + var37, var12, var14);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 0, var12, var16);
                var5.addVertexWithUV(x + 1, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV(x + 1, (float)y + var18 + var20, (float)z + var37, var10, var14);
                var5.addVertexWithUV(x + 1, (float)y + var18 + var20, (float)z + var37, var10, var14);
                var5.addVertexWithUV(x + 1, (float)(y + 0) + var20, z + 0, var10, var16);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 0, var12, var16);
                var5.addVertexWithUV(x + 0, (float)y + var18 + var20, (float)z + var37, var12, var14);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, x, y, z + 1)) {
                var5.addVertexWithUV(x + 1, (float)y + var18 + var20, (float)(z + 1) - var37, var10, var14);
                var5.addVertexWithUV(x + 1, (float)(y + 0) + var20, z + 1 - 0, var10, var16);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 1 - 0, var12, var16);
                var5.addVertexWithUV(x + 0, (float)y + var18 + var20, (float)(z + 1) - var37, var12, var14);
                var5.addVertexWithUV(x + 0, (float)y + var18 + var20, (float)(z + 1) - var37, var12, var14);
                var5.addVertexWithUV(x + 0, (float)(y + 0) + var20, z + 1 - 0, var12, var16);
                var5.addVertexWithUV(x + 1, (float)(y + 0) + var20, z + 1 - 0, var10, var16);
                var5.addVertexWithUV(x + 1, (float)y + var18 + var20, (float)(z + 1) - var37, var10, var14);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, x, y + 1, z)) {
                var21 = (double)x + 0.5 + 0.5;
                double var23 = (double)x + 0.5 - 0.5;
                double var25 = (double)z + 0.5 + 0.5;
                double var27 = (double)z + 0.5 - 0.5;
                double var29 = (double)x + 0.5 - 0.5;
                double var31 = (double)x + 0.5 + 0.5;
                double var33 = (double)z + 0.5 - 0.5;
                double var35 = (double)z + 0.5 + 0.5;
                var10 = (float)var8 / 256.0f;
                var12 = ((float)var8 + 15.99f) / 256.0f;
                var14 = (float)var9 / 256.0f;
                var16 = ((float)var9 + 15.99f) / 256.0f;
                var18 = -0.2f;
                if ((x + ++y + z & 1) == 0) {
                    var5.addVertexWithUV(var29, (float)y + var18, z + 0, var12, var14);
                    var5.addVertexWithUV(var21, y + 0, z + 0, var12, var16);
                    var5.addVertexWithUV(var21, y + 0, z + 1, var10, var16);
                    var5.addVertexWithUV(var29, (float)y + var18, z + 1, var10, var14);
                    var10 = (float)var8 / 256.0f;
                    var12 = ((float)var8 + 15.99f) / 256.0f;
                    var14 = (float)(var9 + 16) / 256.0f;
                    var16 = ((float)var9 + 15.99f + 16.0f) / 256.0f;
                    var5.addVertexWithUV(var31, (float)y + var18, z + 1, var12, var14);
                    var5.addVertexWithUV(var23, y + 0, z + 1, var12, var16);
                    var5.addVertexWithUV(var23, y + 0, z + 0, var10, var16);
                    var5.addVertexWithUV(var31, (float)y + var18, z + 0, var10, var14);
                } else {
                    var5.addVertexWithUV(x + 0, (float)y + var18, var35, var12, var14);
                    var5.addVertexWithUV(x + 0, y + 0, var27, var12, var16);
                    var5.addVertexWithUV(x + 1, y + 0, var27, var10, var16);
                    var5.addVertexWithUV(x + 1, (float)y + var18, var35, var10, var14);
                    var10 = (float)var8 / 256.0f;
                    var12 = ((float)var8 + 15.99f) / 256.0f;
                    var14 = (float)(var9 + 16) / 256.0f;
                    var16 = ((float)var9 + 15.99f + 16.0f) / 256.0f;
                    var5.addVertexWithUV(x + 1, (float)y + var18, var33, var12, var14);
                    var5.addVertexWithUV(x + 1, y + 0, var25, var12, var16);
                    var5.addVertexWithUV(x + 0, y + 0, var25, var10, var16);
                    var5.addVertexWithUV(x + 0, (float)y + var18, var33, var10, var14);
                }
            }
        } else {
            double var19 = (double)x + 0.5 + 0.2;
            double var21 = (double)x + 0.5 - 0.2;
            double var23 = (double)z + 0.5 + 0.2;
            double var25 = (double)z + 0.5 - 0.2;
            double var27 = (double)x + 0.5 - 0.3;
            double var29 = (double)x + 0.5 + 0.3;
            double var31 = (double)z + 0.5 - 0.3;
            double var33 = (double)z + 0.5 + 0.3;
            var5.addVertexWithUV(var27, (float)y + var18, z + 1, var12, var14);
            var5.addVertexWithUV(var19, y + 0, z + 1, var12, var16);
            var5.addVertexWithUV(var19, y + 0, z + 0, var10, var16);
            var5.addVertexWithUV(var27, (float)y + var18, z + 0, var10, var14);
            var5.addVertexWithUV(var29, (float)y + var18, z + 0, var12, var14);
            var5.addVertexWithUV(var21, y + 0, z + 0, var12, var16);
            var5.addVertexWithUV(var21, y + 0, z + 1, var10, var16);
            var5.addVertexWithUV(var29, (float)y + var18, z + 1, var10, var14);
            var10 = (float)var8 / 256.0f;
            var12 = ((float)var8 + 15.99f) / 256.0f;
            var14 = (float)(var9 + 16) / 256.0f;
            var16 = ((float)var9 + 15.99f + 16.0f) / 256.0f;
            var5.addVertexWithUV(x + 1, (float)y + var18, var33, var12, var14);
            var5.addVertexWithUV(x + 1, y + 0, var25, var12, var16);
            var5.addVertexWithUV(x + 0, y + 0, var25, var10, var16);
            var5.addVertexWithUV(x + 0, (float)y + var18, var33, var10, var14);
            var5.addVertexWithUV(x + 0, (float)y + var18, var31, var12, var14);
            var5.addVertexWithUV(x + 0, y + 0, var23, var12, var16);
            var5.addVertexWithUV(x + 1, y + 0, var23, var10, var16);
            var5.addVertexWithUV(x + 1, (float)y + var18, var31, var10, var14);
            var19 = (double)x + 0.5 - 0.5;
            var21 = (double)x + 0.5 + 0.5;
            var23 = (double)z + 0.5 - 0.5;
            var25 = (double)z + 0.5 + 0.5;
            var27 = (double)x + 0.5 - 0.4;
            var29 = (double)x + 0.5 + 0.4;
            var31 = (double)z + 0.5 - 0.4;
            var33 = (double)z + 0.5 + 0.4;
            var5.addVertexWithUV(var27, (float)y + var18, z + 0, var10, var14);
            var5.addVertexWithUV(var19, y + 0, z + 0, var10, var16);
            var5.addVertexWithUV(var19, y + 0, z + 1, var12, var16);
            var5.addVertexWithUV(var27, (float)y + var18, z + 1, var12, var14);
            var5.addVertexWithUV(var29, (float)y + var18, z + 1, var10, var14);
            var5.addVertexWithUV(var21, y + 0, z + 1, var10, var16);
            var5.addVertexWithUV(var21, y + 0, z + 0, var12, var16);
            var5.addVertexWithUV(var29, (float)y + var18, z + 0, var12, var14);
            var10 = (float)var8 / 256.0f;
            var12 = ((float)var8 + 15.99f) / 256.0f;
            var14 = (float)var9 / 256.0f;
            var16 = ((float)var9 + 15.99f) / 256.0f;
            var5.addVertexWithUV(x + 0, (float)y + var18, var33, var10, var14);
            var5.addVertexWithUV(x + 0, y + 0, var25, var10, var16);
            var5.addVertexWithUV(x + 1, y + 0, var25, var12, var16);
            var5.addVertexWithUV(x + 1, (float)y + var18, var33, var12, var14);
            var5.addVertexWithUV(x + 1, (float)y + var18, var31, var10, var14);
            var5.addVertexWithUV(x + 1, y + 0, var23, var10, var16);
            var5.addVertexWithUV(x + 0, y + 0, var23, var12, var16);
            var5.addVertexWithUV(x + 0, (float)y + var18, var31, var12, var14);
        }
        return true;
    }

    public boolean renderBlockRedstoneWire(Block block, int x, int y, int z) {
        boolean var23;
        Tessellator var5 = Tessellator.instance;
        int var6 = block.getBlockTextureFromSideAndMetadata(1, this.blockAccess.getBlockMetadata(x, y, z));
        if (this.overrideBlockTexture >= 0) {
            var6 = this.overrideBlockTexture;
        }
        float var7 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var7, var7, var7);
        int var8 = (var6 & 0xF) << 4;
        int var9 = var6 & 0xF0;
        double var10 = (float)var8 / 256.0f;
        double var12 = ((float)var8 + 15.99f) / 256.0f;
        double var14 = (float)var9 / 256.0f;
        double var16 = ((float)var9 + 15.99f) / 256.0f;
        float var18 = 0.0f;
        float var19 = 0.03125f;
        boolean var20 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x - 1, y, z) || !this.blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x - 1, y - 1, z);
        boolean var21 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x + 1, y, z) || !this.blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x + 1, y - 1, z);
        boolean var22 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y, z - 1) || !this.blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y - 1, z - 1);
        boolean bl = var23 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y, z + 1) || !this.blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y - 1, z + 1);
        if (!this.blockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (this.blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x - 1, y + 1, z)) {
                var20 = true;
            }
            if (this.blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x + 1, y + 1, z)) {
                var21 = true;
            }
            if (this.blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y + 1, z - 1)) {
                var22 = true;
            }
            if (this.blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, x, y + 1, z + 1)) {
                var23 = true;
            }
        }
        float var24 = 0.3125f;
        float var25 = x + 0;
        float var26 = x + 1;
        float var27 = z + 0;
        float var28 = z + 1;
        int var29 = 0;
        if ((var20 || var21) && !var22 && !var23) {
            var29 = 1;
        }
        if ((var22 || var23) && !var21 && !var20) {
            var29 = 2;
        }
        if (var29 != 0) {
            var10 = (float)(var8 + 16) / 256.0f;
            var12 = ((float)(var8 + 16) + 15.99f) / 256.0f;
            var14 = (float)var9 / 256.0f;
            var16 = ((float)var9 + 15.99f) / 256.0f;
        }
        if (var29 == 0) {
            if (var21 || var22 || var23 || var20) {
                if (!var20) {
                    var25 += var24;
                }
                if (!var20) {
                    var10 += (double)(var24 / 16.0f);
                }
                if (!var21) {
                    var26 -= var24;
                }
                if (!var21) {
                    var12 -= (double)(var24 / 16.0f);
                }
                if (!var22) {
                    var27 += var24;
                }
                if (!var22) {
                    var14 += (double)(var24 / 16.0f);
                }
                if (!var23) {
                    var28 -= var24;
                }
                if (!var23) {
                    var16 -= (double)(var24 / 16.0f);
                }
            }
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var28 + var18, var12, var16);
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var27 - var18, var12, var14);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var27 - var18, var10, var14);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var28 + var18, var10, var16);
        }
        if (var29 == 1) {
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var28 + var18, var12, var16);
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var27 - var18, var12, var14);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var27 - var18, var10, var14);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var28 + var18, var10, var16);
        }
        if (var29 == 2) {
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var28 + var18, var12, var16);
            var5.addVertexWithUV(var26 + var18, (float)y + var19, var27 - var18, var10, var16);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var27 - var18, var10, var14);
            var5.addVertexWithUV(var25 - var18, (float)y + var19, var28 + var18, var12, var14);
        }
        var10 = (float)(var8 + 16) / 256.0f;
        var12 = ((float)(var8 + 16) + 15.99f) / 256.0f;
        var14 = (float)var9 / 256.0f;
        var16 = ((float)var9 + 15.99f) / 256.0f;
        if (!this.blockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (this.blockAccess.isBlockNormalCube(x - 1, y, z) && this.blockAccess.getBlockId(x - 1, y + 1, z) == Block.redstoneWire.blockID) {
                var5.addVertexWithUV((float)x + var19, (float)(y + 1) + var18, (float)(z + 1) + var18, var12, var14);
                var5.addVertexWithUV((float)x + var19, (float)(y + 0) - var18, (float)(z + 1) + var18, var10, var14);
                var5.addVertexWithUV((float)x + var19, (float)(y + 0) - var18, (float)(z + 0) - var18, var10, var16);
                var5.addVertexWithUV((float)x + var19, (float)(y + 1) + var18, (float)(z + 0) - var18, var12, var16);
            }
            if (this.blockAccess.isBlockNormalCube(x + 1, y, z) && this.blockAccess.getBlockId(x + 1, y + 1, z) == Block.redstoneWire.blockID) {
                var5.addVertexWithUV((float)(x + 1) - var19, (float)(y + 0) - var18, (float)(z + 1) + var18, var10, var16);
                var5.addVertexWithUV((float)(x + 1) - var19, (float)(y + 1) + var18, (float)(z + 1) + var18, var12, var16);
                var5.addVertexWithUV((float)(x + 1) - var19, (float)(y + 1) + var18, (float)(z + 0) - var18, var12, var14);
                var5.addVertexWithUV((float)(x + 1) - var19, (float)(y + 0) - var18, (float)(z + 0) - var18, var10, var14);
            }
            if (this.blockAccess.isBlockNormalCube(x, y, z - 1) && this.blockAccess.getBlockId(x, y + 1, z - 1) == Block.redstoneWire.blockID) {
                var5.addVertexWithUV((float)(x + 1) + var18, (float)(y + 0) - var18, (float)z + var19, var10, var16);
                var5.addVertexWithUV((float)(x + 1) + var18, (float)(y + 1) + var18, (float)z + var19, var12, var16);
                var5.addVertexWithUV((float)(x + 0) - var18, (float)(y + 1) + var18, (float)z + var19, var12, var14);
                var5.addVertexWithUV((float)(x + 0) - var18, (float)(y + 0) - var18, (float)z + var19, var10, var14);
            }
            if (this.blockAccess.isBlockNormalCube(x, y, z + 1) && this.blockAccess.getBlockId(x, y + 1, z + 1) == Block.redstoneWire.blockID) {
                var5.addVertexWithUV((float)(x + 1) + var18, (float)(y + 1) + var18, (float)(z + 1) - var19, var12, var14);
                var5.addVertexWithUV((float)(x + 1) + var18, (float)(y + 0) - var18, (float)(z + 1) - var19, var10, var14);
                var5.addVertexWithUV((float)(x + 0) - var18, (float)(y + 0) - var18, (float)(z + 1) - var19, var10, var16);
                var5.addVertexWithUV((float)(x + 0) - var18, (float)(y + 1) + var18, (float)(z + 1) - var19, var12, var16);
            }
        }
        return true;
    }

    public boolean renderBlockMinecartTrack(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        int var6 = this.blockAccess.getBlockMetadata(x, y, z);
        int var7 = block.getBlockTextureFromSideAndMetadata(0, var6);
        if (this.overrideBlockTexture >= 0) {
            var7 = this.overrideBlockTexture;
        }
        float var8 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var8, var8, var8);
        int var9 = (var7 & 0xF) << 4;
        int var10 = var7 & 0xF0;
        double var11 = (float)var9 / 256.0f;
        double var13 = ((float)var9 + 15.99f) / 256.0f;
        double var15 = (float)var10 / 256.0f;
        double var17 = ((float)var10 + 15.99f) / 256.0f;
        float var19 = 0.0625f;
        float var20 = x + 1;
        float var21 = x + 1;
        float var22 = x + 0;
        float var23 = x + 0;
        float var24 = z + 0;
        float var25 = z + 1;
        float var26 = z + 1;
        float var27 = z + 0;
        float var28 = (float)y + var19;
        float var29 = (float)y + var19;
        float var30 = (float)y + var19;
        float var31 = (float)y + var19;
        if (var6 != 1 && var6 != 2 && var6 != 3 && var6 != 7) {
            if (var6 == 8) {
                var20 = var21 = (float)(x + 0);
                var22 = var23 = (float)(x + 1);
                var24 = var27 = (float)(z + 1);
                var25 = var26 = (float)(z + 0);
            } else if (var6 == 9) {
                var20 = var23 = (float)(x + 0);
                var21 = var22 = (float)(x + 1);
                var24 = var25 = (float)(z + 0);
                var26 = var27 = (float)(z + 1);
            }
        } else {
            var20 = var23 = (float)(x + 1);
            var21 = var22 = (float)(x + 0);
            var24 = var25 = (float)(z + 1);
            var26 = var27 = (float)(z + 0);
        }
        if (var6 != 2 && var6 != 4) {
            if (var6 == 3 || var6 == 5) {
                var29 += 1.0f;
                var30 += 1.0f;
            }
        } else {
            var28 += 1.0f;
            var31 += 1.0f;
        }
        var5.addVertexWithUV(var20, var28, var24, var13, var15);
        var5.addVertexWithUV(var21, var29, var25, var13, var17);
        var5.addVertexWithUV(var22, var30, var26, var11, var17);
        var5.addVertexWithUV(var23, var31, var27, var11, var15);
        var5.addVertexWithUV(var23, var31, var27, var11, var15);
        var5.addVertexWithUV(var22, var30, var26, var11, var17);
        var5.addVertexWithUV(var21, var29, var25, var13, var17);
        var5.addVertexWithUV(var20, var28, var24, var13, var15);
        return true;
    }

    public boolean renderBlockLadder(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        int var6 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var6 = this.overrideBlockTexture;
        }
        float var7 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var7, var7, var7);
        int var8 = (var6 & 0xF) << 4;
        int var9 = var6 & 0xF0;
        double var10 = (float)var8 / 256.0f;
        double var12 = ((float)var8 + 15.99f) / 256.0f;
        double var14 = (float)var9 / 256.0f;
        double var16 = ((float)var9 + 15.99f) / 256.0f;
        int var18 = this.blockAccess.getBlockMetadata(x, y, z);
        float var19 = 0.0f;
        float var20 = 0.05f;
        if (var18 == 5) {
            var5.addVertexWithUV((float)x + var20, (float)(y + 1) + var19, (float)(z + 1) + var19, var10, var14);
            var5.addVertexWithUV((float)x + var20, (float)(y + 0) - var19, (float)(z + 1) + var19, var10, var16);
            var5.addVertexWithUV((float)x + var20, (float)(y + 0) - var19, (float)(z + 0) - var19, var12, var16);
            var5.addVertexWithUV((float)x + var20, (float)(y + 1) + var19, (float)(z + 0) - var19, var12, var14);
        }
        if (var18 == 4) {
            var5.addVertexWithUV((float)(x + 1) - var20, (float)(y + 0) - var19, (float)(z + 1) + var19, var12, var16);
            var5.addVertexWithUV((float)(x + 1) - var20, (float)(y + 1) + var19, (float)(z + 1) + var19, var12, var14);
            var5.addVertexWithUV((float)(x + 1) - var20, (float)(y + 1) + var19, (float)(z + 0) - var19, var10, var14);
            var5.addVertexWithUV((float)(x + 1) - var20, (float)(y + 0) - var19, (float)(z + 0) - var19, var10, var16);
        }
        if (var18 == 3) {
            var5.addVertexWithUV((float)(x + 1) + var19, (float)(y + 0) - var19, (float)z + var20, var12, var16);
            var5.addVertexWithUV((float)(x + 1) + var19, (float)(y + 1) + var19, (float)z + var20, var12, var14);
            var5.addVertexWithUV((float)(x + 0) - var19, (float)(y + 1) + var19, (float)z + var20, var10, var14);
            var5.addVertexWithUV((float)(x + 0) - var19, (float)(y + 0) - var19, (float)z + var20, var10, var16);
        }
        if (var18 == 2) {
            var5.addVertexWithUV((float)(x + 1) + var19, (float)(y + 1) + var19, (float)(z + 1) - var20, var10, var14);
            var5.addVertexWithUV((float)(x + 1) + var19, (float)(y + 0) - var19, (float)(z + 1) - var20, var10, var16);
            var5.addVertexWithUV((float)(x + 0) - var19, (float)(y + 0) - var19, (float)(z + 1) - var20, var12, var16);
            var5.addVertexWithUV((float)(x + 0) - var19, (float)(y + 1) + var19, (float)(z + 1) - var20, var12, var14);
        }
        return true;
    }

    public boolean renderBlockReed(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        float var6 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var6, var6, var6);
        this.renderCrossedSquares(block, this.blockAccess.getBlockMetadata(x, y, z), x, y, z);
        return true;
    }

    public boolean renderBlockCrops(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        float var6 = block.getBlockBrightness(this.blockAccess, x, y, z);
        var5.setColorOpaque_F(var6, var6, var6);
        this.renderBlockCropsImpl(block, this.blockAccess.getBlockMetadata(x, y, z), x, (float)y - 0.0625f, z);
        return true;
    }

    public void renderTorchAtAngle(Block block, double var2, double var4, double var6, double var8, double var10) {
        Tessellator var12 = Tessellator.instance;
        int var13 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var13 = this.overrideBlockTexture;
        }
        int var14 = (var13 & 0xF) << 4;
        int var15 = var13 & 0xF0;
        float var16 = (float)var14 / 256.0f;
        float var17 = ((float)var14 + 15.99f) / 256.0f;
        float var18 = (float)var15 / 256.0f;
        float var19 = ((float)var15 + 15.99f) / 256.0f;
        double var20 = (double)var16 + 0.02734375;
        double var22 = (double)var18 + 0.0234375;
        double var24 = (double)var16 + 0.03515625;
        double var26 = (double)var18 + 0.03125;
        double var28 = (var2 += 0.5) - 0.5;
        double var30 = var2 + 0.5;
        double var32 = (var6 += 0.5) - 0.5;
        double var34 = var6 + 0.5;
        double var36 = 0.0625;
        double var38 = 0.625;
        var12.addVertexWithUV(var2 + var8 * (1.0 - var38) - var36, var4 + var38, var6 + var10 * (1.0 - var38) - var36, var20, var22);
        var12.addVertexWithUV(var2 + var8 * (1.0 - var38) - var36, var4 + var38, var6 + var10 * (1.0 - var38) + var36, var20, var26);
        var12.addVertexWithUV(var2 + var8 * (1.0 - var38) + var36, var4 + var38, var6 + var10 * (1.0 - var38) + var36, var24, var26);
        var12.addVertexWithUV(var2 + var8 * (1.0 - var38) + var36, var4 + var38, var6 + var10 * (1.0 - var38) - var36, var24, var22);
        var12.addVertexWithUV(var2 - var36, var4 + 1.0, var32, var16, var18);
        var12.addVertexWithUV(var2 - var36 + var8, var4 + 0.0, var32 + var10, var16, var19);
        var12.addVertexWithUV(var2 - var36 + var8, var4 + 0.0, var34 + var10, var17, var19);
        var12.addVertexWithUV(var2 - var36, var4 + 1.0, var34, var17, var18);
        var12.addVertexWithUV(var2 + var36, var4 + 1.0, var34, var16, var18);
        var12.addVertexWithUV(var2 + var8 + var36, var4 + 0.0, var34 + var10, var16, var19);
        var12.addVertexWithUV(var2 + var8 + var36, var4 + 0.0, var32 + var10, var17, var19);
        var12.addVertexWithUV(var2 + var36, var4 + 1.0, var32, var17, var18);
        var12.addVertexWithUV(var28, var4 + 1.0, var6 + var36, var16, var18);
        var12.addVertexWithUV(var28 + var8, var4 + 0.0, var6 + var36 + var10, var16, var19);
        var12.addVertexWithUV(var30 + var8, var4 + 0.0, var6 + var36 + var10, var17, var19);
        var12.addVertexWithUV(var30, var4 + 1.0, var6 + var36, var17, var18);
        var12.addVertexWithUV(var30, var4 + 1.0, var6 - var36, var16, var18);
        var12.addVertexWithUV(var30 + var8, var4 + 0.0, var6 - var36 + var10, var16, var19);
        var12.addVertexWithUV(var28 + var8, var4 + 0.0, var6 - var36 + var10, var17, var19);
        var12.addVertexWithUV(var28, var4 + 1.0, var6 - var36, var17, var18);
    }

    public void renderCrossedSquares(Block block, int metadata, double x, double y, double z) {
        Tessellator var9 = Tessellator.instance;
        int var10 = block.getBlockTextureFromSideAndMetadata(0, metadata);
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 256.0f;
        double var19 = ((float)var12 + 15.99f) / 256.0f;
        double var21 = x + 0.5 - (double)0.45f;
        double var23 = x + 0.5 + (double)0.45f;
        double var25 = z + 0.5 - (double)0.45f;
        double var27 = z + 0.5 + (double)0.45f;
        var9.addVertexWithUV(var21, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var27, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var21, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var27, var15, var17);
    }

    public void renderBlockCropsImpl(Block block, int metadata, double x, double y, double z) {
        Tessellator var9 = Tessellator.instance;
        int var10 = block.getBlockTextureFromSideAndMetadata(0, metadata);
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 256.0f;
        double var19 = ((float)var12 + 15.99f) / 256.0f;
        double var21 = x + 0.5 - 0.25;
        double var23 = x + 0.5 + 0.25;
        double var25 = z + 0.5 - 0.5;
        double var27 = z + 0.5 + 0.5;
        var9.addVertexWithUV(var21, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var27, var15, var17);
        var9.addVertexWithUV(var21, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var27, var15, var17);
        var21 = x + 0.5 - 0.5;
        var23 = x + 0.5 + 0.5;
        var25 = z + 0.5 - 0.25;
        var27 = z + 0.5 + 0.25;
        var9.addVertexWithUV(var21, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var23, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var21, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var21, y + 1.0, var27, var15, var17);
        var9.addVertexWithUV(var21, y + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var21, y + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var23, y + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var23, y + 1.0, var27, var15, var17);
    }

    public boolean renderBlockFluids(Block block, int x, int y, int z) {
        float var34;
        float var33;
        float var32;
        int var27;
        int var24;
        Tessellator var5 = Tessellator.instance;
        boolean var6 = block.shouldSideBeRendered(this.blockAccess, x, y + 1, z, 1);
        boolean var7 = block.shouldSideBeRendered(this.blockAccess, x, y - 1, z, 0);
        boolean[] var8 = new boolean[]{block.shouldSideBeRendered(this.blockAccess, x, y, z - 1, 2), block.shouldSideBeRendered(this.blockAccess, x, y, z + 1, 3), block.shouldSideBeRendered(this.blockAccess, x - 1, y, z, 4), block.shouldSideBeRendered(this.blockAccess, x + 1, y, z, 5)};
        if (!(var6 || var7 || var8[0] || var8[1] || var8[2] || var8[3])) {
            return false;
        }
        boolean var9 = false;
        float var10 = 0.5f;
        float var11 = 1.0f;
        float var12 = 0.8f;
        float var13 = 0.6f;
        double var14 = 0.0;
        double var16 = 1.0;
        Material var18 = block.material;
        int var19 = this.blockAccess.getBlockMetadata(x, y, z);
        float var20 = this.getFluidHeight(x, y, z, var18);
        float var21 = this.getFluidHeight(x, y, z + 1, var18);
        float var22 = this.getFluidHeight(x + 1, y, z + 1, var18);
        float var23 = this.getFluidHeight(x + 1, y, z, var18);
        if (this.renderAllFaces || var6) {
            var9 = true;
            var24 = block.getBlockTextureFromSideAndMetadata(1, var19);
            float var25 = (float)BlockFluid.getFlowDirection(this.blockAccess, x, y, z, var18);
            if (var25 > -999.0f) {
                var24 = block.getBlockTextureFromSideAndMetadata(2, var19);
            }
            int var26 = (var24 & 0xF) << 4;
            var27 = var24 & 0xF0;
            double var28 = ((double)var26 + 8.0) / 256.0;
            double var30 = ((double)var27 + 8.0) / 256.0;
            if (var25 < -999.0f) {
                var25 = 0.0f;
            } else {
                var28 = (float)(var26 + 16) / 256.0f;
                var30 = (float)(var27 + 16) / 256.0f;
            }
            var32 = MathHelper.sin(var25) * 8.0f / 256.0f;
            var33 = MathHelper.cos(var25) * 8.0f / 256.0f;
            var34 = block.getBlockBrightness(this.blockAccess, x, y, z);
            var5.setColorOpaque_F(var11 * var34, var11 * var34, var11 * var34);
            var5.addVertexWithUV(x + 0, (float)y + var20, z + 0, var28 - (double)var33 - (double)var32, var30 - (double)var33 + (double)var32);
            var5.addVertexWithUV(x + 0, (float)y + var21, z + 1, var28 - (double)var33 + (double)var32, var30 + (double)var33 + (double)var32);
            var5.addVertexWithUV(x + 1, (float)y + var22, z + 1, var28 + (double)var33 + (double)var32, var30 + (double)var33 - (double)var32);
            var5.addVertexWithUV(x + 1, (float)y + var23, z + 0, var28 + (double)var33 - (double)var32, var30 - (double)var33 - (double)var32);
        }
        if (this.renderAllFaces || var7) {
            float var48 = block.getBlockBrightness(this.blockAccess, x, y - 1, z);
            var5.setColorOpaque_F(var10 * var48, var10 * var48, var10 * var48);
            this.renderBottomFace(block, x, y, z, block.getBlockTextureFromSide(0));
            var9 = true;
        }
        for (var24 = 0; var24 < 4; ++var24) {
            float var36;
            float var35;
            float var31;
            int var49 = x;
            var27 = z;
            if (var24 == 0) {
                var27 = z - 1;
            }
            if (var24 == 1) {
                ++var27;
            }
            if (var24 == 2) {
                var49 = x - 1;
            }
            if (var24 == 3) {
                ++var49;
            }
            int var50 = block.getBlockTextureFromSideAndMetadata(var24 + 2, var19);
            int var29 = (var50 & 0xF) << 4;
            int var51 = var50 & 0xF0;
            if (!this.renderAllFaces && !var8[var24]) continue;
            if (var24 == 0) {
                var31 = var20;
                var32 = var23;
                var33 = x;
                var35 = x + 1;
                var34 = z;
                var36 = z;
            } else if (var24 == 1) {
                var31 = var22;
                var32 = var21;
                var33 = x + 1;
                var35 = x;
                var34 = z + 1;
                var36 = z + 1;
            } else if (var24 == 2) {
                var31 = var21;
                var32 = var20;
                var33 = x;
                var35 = x;
                var34 = z + 1;
                var36 = z;
            } else {
                var31 = var23;
                var32 = var22;
                var33 = x + 1;
                var35 = x + 1;
                var34 = z;
                var36 = z + 1;
            }
            var9 = true;
            double var37 = (float)(var29 + 0) / 256.0f;
            double var39 = ((double)(var29 + 16) - 0.01) / 256.0;
            double var41 = ((float)var51 + (1.0f - var31) * 16.0f) / 256.0f;
            double var43 = ((float)var51 + (1.0f - var32) * 16.0f) / 256.0f;
            double var45 = ((double)(var51 + 16) - 0.01) / 256.0;
            float var47 = block.getBlockBrightness(this.blockAccess, var49, y, var27);
            var47 = var24 < 2 ? (var47 *= var12) : (var47 *= var13);
            var5.setColorOpaque_F(var11 * var47, var11 * var47, var11 * var47);
            var5.addVertexWithUV(var33, (float)y + var31, var34, var37, var41);
            var5.addVertexWithUV(var35, (float)y + var32, var36, var39, var43);
            var5.addVertexWithUV(var35, y + 0, var36, var39, var45);
            var5.addVertexWithUV(var33, y + 0, var34, var37, var45);
        }
        block.minY = var14;
        block.maxY = var16;
        return var9;
    }

    private float getFluidHeight(int x, int y, int z, Material material) {
        int var5 = 0;
        float var6 = 0.0f;
        for (int var7 = 0; var7 < 4; ++var7) {
            int var8 = x - (var7 & 1);
            int var10 = z - (var7 >> 1 & 1);
            if (this.blockAccess.getBlockMaterial(var8, y + 1, var10) == material) {
                return 1.0f;
            }
            Material var11 = this.blockAccess.getBlockMaterial(var8, y, var10);
            if (var11 == material) {
                int var12 = this.blockAccess.getBlockMetadata(var8, y, var10);
                if (var12 >= 8 || var12 == 0) {
                    var6 += BlockFluid.getFluidHeightPercent(var12) * 10.0f;
                    var5 += 10;
                }
                var6 += BlockFluid.getFluidHeightPercent(var12);
                ++var5;
                continue;
            }
            if (var11.isSolid()) continue;
            var6 += 1.0f;
            ++var5;
        }
        return 1.0f - var6 / (float)var5;
    }

    public void renderBlockFallingSand(Block block, World worldObj, int x, int y, int z) {
        float var6 = 0.5f;
        float var7 = 1.0f;
        float var8 = 0.8f;
        float var9 = 0.6f;
        Tessellator var10 = Tessellator.instance;
        var10.startDrawingQuads();
        float var11 = block.getBlockBrightness(worldObj, x, y, z);
        float var12 = block.getBlockBrightness(worldObj, x, y - 1, z);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var6 * var12, var6 * var12, var6 * var12);
        this.renderBottomFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(0));
        var12 = block.getBlockBrightness(worldObj, x, y + 1, z);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var7 * var12, var7 * var12, var7 * var12);
        this.renderTopFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(1));
        var12 = block.getBlockBrightness(worldObj, x, y, z - 1);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var8 * var12, var8 * var12, var8 * var12);
        this.renderEastFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(2));
        var12 = block.getBlockBrightness(worldObj, x, y, z + 1);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var8 * var12, var8 * var12, var8 * var12);
        this.renderWestFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(3));
        var12 = block.getBlockBrightness(worldObj, x - 1, y, z);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var9 * var12, var9 * var12, var9 * var12);
        this.renderNorthFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(4));
        var12 = block.getBlockBrightness(worldObj, x + 1, y, z);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var9 * var12, var9 * var12, var9 * var12);
        this.renderSouthFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(5));
        var10.draw();
    }

    public boolean renderStandardBlock(Block block, int x, int y, int z) {
        int var5 = block.colorMultiplier(this.blockAccess, x, y, z);
        float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var5 & 0xFF) / 255.0f;
        return this.renderStandardBlockWithColorMultiplier(block, x, y, z, var6, var7, var8);
    }

    public boolean renderStandardBlockWithColorMultiplier(Block block, int x, int y, int z, float var5, float var6, float var7) {
        float var27;
        Tessellator var8 = Tessellator.instance;
        boolean var9 = false;
        float var10 = 0.5f;
        float var11 = 1.0f;
        float var12 = 0.8f;
        float var13 = 0.6f;
        float var14 = var10 * var5;
        float var15 = var11 * var5;
        float var16 = var12 * var5;
        float var17 = var13 * var5;
        float var18 = var10 * var6;
        float var19 = var11 * var6;
        float var20 = var12 * var6;
        float var21 = var13 * var6;
        float var22 = var10 * var7;
        float var23 = var11 * var7;
        float var24 = var12 * var7;
        float var25 = var13 * var7;
        float var26 = block.getBlockBrightness(this.blockAccess, x, y, z);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y - 1, z, 0)) {
            var27 = block.getBlockBrightness(this.blockAccess, x, y - 1, z);
            var8.setColorOpaque_F(var14 * var27, var18 * var27, var22 * var27);
            this.renderBottomFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 0));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y + 1, z, 1)) {
            var27 = block.getBlockBrightness(this.blockAccess, x, y + 1, z);
            if (block.maxY != 1.0 && !block.material.getIsLiquid()) {
                var27 = var26;
            }
            var8.setColorOpaque_F(var15 * var27, var19 * var27, var23 * var27);
            this.renderTopFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 1));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y, z - 1, 2)) {
            var27 = block.getBlockBrightness(this.blockAccess, x, y, z - 1);
            if (block.minZ > 0.0) {
                var27 = var26;
            }
            var8.setColorOpaque_F(var16 * var27, var20 * var27, var24 * var27);
            this.renderEastFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 2));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y, z + 1, 3)) {
            var27 = block.getBlockBrightness(this.blockAccess, x, y, z + 1);
            if (block.maxZ < 1.0) {
                var27 = var26;
            }
            var8.setColorOpaque_F(var16 * var27, var20 * var27, var24 * var27);
            this.renderWestFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 3));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x - 1, y, z, 4)) {
            var27 = block.getBlockBrightness(this.blockAccess, x - 1, y, z);
            if (block.minX > 0.0) {
                var27 = var26;
            }
            var8.setColorOpaque_F(var17 * var27, var21 * var27, var25 * var27);
            this.renderNorthFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 4));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x + 1, y, z, 5)) {
            var27 = block.getBlockBrightness(this.blockAccess, x + 1, y, z);
            if (block.maxX < 1.0) {
                var27 = var26;
            }
            var8.setColorOpaque_F(var17 * var27, var21 * var27, var25 * var27);
            this.renderSouthFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 5));
            var9 = true;
        }
        return var9;
    }

    public boolean renderBlockCactus(Block blocki, int x, int y, int z) {
        int var5 = blocki.colorMultiplier(this.blockAccess, x, y, z);
        float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var5 & 0xFF) / 255.0f;
        return this.renderBlockCactusImpl(blocki, x, y, z, var6, var7, var8);
    }

    public boolean renderBlockCactusImpl(Block block, int x, int y, int z, float var5, float var6, float var7) {
        float var28;
        Tessellator var8 = Tessellator.instance;
        boolean var9 = false;
        float var10 = 0.5f;
        float var11 = 1.0f;
        float var12 = 0.8f;
        float var13 = 0.6f;
        float var14 = var10 * var5;
        float var15 = var11 * var5;
        float var16 = var12 * var5;
        float var17 = var13 * var5;
        float var18 = var10 * var6;
        float var19 = var11 * var6;
        float var20 = var12 * var6;
        float var21 = var13 * var6;
        float var22 = var10 * var7;
        float var23 = var11 * var7;
        float var24 = var12 * var7;
        float var25 = var13 * var7;
        float var26 = 0.0625f;
        float var27 = block.getBlockBrightness(this.blockAccess, x, y, z);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y - 1, z, 0)) {
            var28 = block.getBlockBrightness(this.blockAccess, x, y - 1, z);
            var8.setColorOpaque_F(var14 * var28, var18 * var28, var22 * var28);
            this.renderBottomFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 0));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y + 1, z, 1)) {
            var28 = block.getBlockBrightness(this.blockAccess, x, y + 1, z);
            if (block.maxY != 1.0 && !block.material.getIsLiquid()) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var15 * var28, var19 * var28, var23 * var28);
            this.renderTopFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 1));
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y, z - 1, 2)) {
            var28 = block.getBlockBrightness(this.blockAccess, x, y, z - 1);
            if (block.minZ > 0.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var16 * var28, var20 * var28, var24 * var28);
            var8.setTranslationF(0.0f, 0.0f, var26);
            this.renderEastFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 2));
            var8.setTranslationF(0.0f, 0.0f, -var26);
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x, y, z + 1, 3)) {
            var28 = block.getBlockBrightness(this.blockAccess, x, y, z + 1);
            if (block.maxZ < 1.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var16 * var28, var20 * var28, var24 * var28);
            var8.setTranslationF(0.0f, 0.0f, -var26);
            this.renderWestFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 3));
            var8.setTranslationF(0.0f, 0.0f, var26);
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x - 1, y, z, 4)) {
            var28 = block.getBlockBrightness(this.blockAccess, x - 1, y, z);
            if (block.minX > 0.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var17 * var28, var21 * var28, var25 * var28);
            var8.setTranslationF(var26, 0.0f, 0.0f);
            this.renderNorthFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 4));
            var8.setTranslationF(-var26, 0.0f, 0.0f);
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x + 1, y, z, 5)) {
            var28 = block.getBlockBrightness(this.blockAccess, x + 1, y, z);
            if (block.maxX < 1.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var17 * var28, var21 * var28, var25 * var28);
            var8.setTranslationF(-var26, 0.0f, 0.0f);
            this.renderSouthFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 5));
            var8.setTranslationF(var26, 0.0f, 0.0f);
            var9 = true;
        }
        return var9;
    }

    public boolean renderBlockFence(Block block, int x, int y, int z) {
        float var19;
        boolean var13;
        boolean var5 = false;
        float var6 = 0.375f;
        float var7 = 0.625f;
        block.setBlockBounds(var6, 0.0f, var6, var7, 1.0f, var7);
        this.renderStandardBlock(block, x, y, z);
        boolean var8 = false;
        boolean var9 = false;
        if (this.blockAccess.getBlockId(x - 1, y, z) == block.blockID || this.blockAccess.getBlockId(x + 1, y, z) == block.blockID) {
            var8 = true;
        }
        if (this.blockAccess.getBlockId(x, y, z - 1) == block.blockID || this.blockAccess.getBlockId(x, y, z + 1) == block.blockID) {
            var9 = true;
        }
        boolean var10 = this.blockAccess.getBlockId(x - 1, y, z) == block.blockID;
        boolean var11 = this.blockAccess.getBlockId(x + 1, y, z) == block.blockID;
        boolean var12 = this.blockAccess.getBlockId(x, y, z - 1) == block.blockID;
        boolean bl = var13 = this.blockAccess.getBlockId(x, y, z + 1) == block.blockID;
        if (!var8 && !var9) {
            var8 = true;
        }
        var6 = 0.4375f;
        var7 = 0.5625f;
        float var14 = 0.75f;
        float var15 = 0.9375f;
        float var16 = var10 ? 0.0f : var6;
        float var17 = var11 ? 1.0f : var7;
        float var18 = var12 ? 0.0f : var6;
        float f = var19 = var13 ? 1.0f : var7;
        if (var8) {
            block.setBlockBounds(var16, var14, var6, var17, var15, var7);
            this.renderStandardBlock(block, x, y, z);
        }
        if (var9) {
            block.setBlockBounds(var6, var14, var18, var7, var15, var19);
            this.renderStandardBlock(block, x, y, z);
        }
        var14 = 0.375f;
        var15 = 0.5625f;
        if (var8) {
            block.setBlockBounds(var16, var14, var6, var17, var15, var7);
            this.renderStandardBlock(block, x, y, z);
        }
        if (var9) {
            block.setBlockBounds(var6, var14, var18, var7, var15, var19);
            this.renderStandardBlock(block, x, y, z);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return var5;
    }

    public boolean renderBlockStairs(Block block, int x, int y, int z) {
        boolean var5 = false;
        int var6 = this.blockAccess.getBlockMetadata(x, y, z);
        if (var6 == 0) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
        } else if (var6 == 1) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
        } else if (var6 == 2) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            this.renderStandardBlock(block, x, y, z);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
        } else if (var6 == 3) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            this.renderStandardBlock(block, x, y, z);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            this.renderStandardBlock(block, x, y, z);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return var5;
    }

    public boolean renderBlockDoor(Block block, int x, int y, int z) {
        Tessellator var5 = Tessellator.instance;
        BlockDoor var6 = (BlockDoor)block;
        boolean var7 = false;
        float var8 = 0.5f;
        float var9 = 1.0f;
        float var10 = 0.8f;
        float var11 = 0.6f;
        float var12 = block.getBlockBrightness(this.blockAccess, x, y, z);
        float var13 = block.getBlockBrightness(this.blockAccess, x, y - 1, z);
        if (var6.minY > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var8 * var13, var8 * var13, var8 * var13);
        this.renderBottomFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 0));
        var7 = true;
        var13 = block.getBlockBrightness(this.blockAccess, x, y + 1, z);
        if (var6.maxY < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var9 * var13, var9 * var13, var9 * var13);
        this.renderTopFace(block, x, y, z, block.getBlockTexture(this.blockAccess, x, y, z, 1));
        var7 = true;
        var13 = block.getBlockBrightness(this.blockAccess, x, y, z - 1);
        if (var6.minZ > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var10 * var13, var10 * var13, var10 * var13);
        int var14 = block.getBlockTexture(this.blockAccess, x, y, z, 2);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        this.renderEastFace(block, x, y, z, var14);
        var7 = true;
        this.flipTexture = false;
        var13 = block.getBlockBrightness(this.blockAccess, x, y, z + 1);
        if (var6.maxZ < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var10 * var13, var10 * var13, var10 * var13);
        var14 = block.getBlockTexture(this.blockAccess, x, y, z, 3);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        this.renderWestFace(block, x, y, z, var14);
        var7 = true;
        this.flipTexture = false;
        var13 = block.getBlockBrightness(this.blockAccess, x - 1, y, z);
        if (var6.minX > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var11 * var13, var11 * var13, var11 * var13);
        var14 = block.getBlockTexture(this.blockAccess, x, y, z, 4);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        this.renderNorthFace(block, x, y, z, var14);
        var7 = true;
        this.flipTexture = false;
        var13 = block.getBlockBrightness(this.blockAccess, x + 1, y, z);
        if (var6.maxX < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[block.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var11 * var13, var11 * var13, var11 * var13);
        var14 = block.getBlockTexture(this.blockAccess, x, y, z, 5);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        this.renderSouthFace(block, x, y, z, var14);
        var7 = true;
        this.flipTexture = false;
        return var7;
    }

    public void renderBottomFace(Block block, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minZ * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxZ * 16.0 - 0.01) / 256.0;
        if (block.minX < 0.0 || block.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        double var20 = var2 + block.minX;
        double var22 = var2 + block.maxX;
        double var24 = var4 + block.minY;
        double var26 = var6 + block.minZ;
        double var28 = var6 + block.maxZ;
        var9.addVertexWithUV(var20, var24, var28, var12, var18);
        var9.addVertexWithUV(var20, var24, var26, var12, var16);
        var9.addVertexWithUV(var22, var24, var26, var14, var16);
        var9.addVertexWithUV(var22, var24, var28, var14, var18);
    }

    public void renderTopFace(Block block, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minZ * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxZ * 16.0 - 0.01) / 256.0;
        if (block.minX < 0.0 || block.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        double var20 = var2 + block.minX;
        double var22 = var2 + block.maxX;
        double var24 = var4 + block.maxY;
        double var26 = var6 + block.minZ;
        double var28 = var6 + block.maxZ;
        var9.addVertexWithUV(var22, var24, var28, var14, var18);
        var9.addVertexWithUV(var22, var24, var26, var14, var16);
        var9.addVertexWithUV(var20, var24, var26, var12, var16);
        var9.addVertexWithUV(var20, var24, var28, var12, var18);
    }

    public void renderEastFace(Block block, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minY * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        var20 = var2 + block.minX;
        double var22 = var2 + block.maxX;
        double var24 = var4 + block.minY;
        double var26 = var4 + block.maxY;
        double var28 = var6 + block.minZ;
        var9.addVertexWithUV(var20, var26, var28, var14, var16);
        var9.addVertexWithUV(var22, var26, var28, var12, var16);
        var9.addVertexWithUV(var22, var24, var28, var12, var18);
        var9.addVertexWithUV(var20, var24, var28, var14, var18);
    }

    public void renderWestFace(Block block, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minY * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        var20 = var2 + block.minX;
        double var22 = var2 + block.maxX;
        double var24 = var4 + block.minY;
        double var26 = var4 + block.maxY;
        double var28 = var6 + block.maxZ;
        var9.addVertexWithUV(var20, var26, var28, var12, var16);
        var9.addVertexWithUV(var20, var24, var28, var12, var18);
        var9.addVertexWithUV(var22, var24, var28, var14, var18);
        var9.addVertexWithUV(var22, var26, var28, var14, var16);
    }

    public void renderNorthFace(Block block, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minY * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        var20 = var2 + block.minX;
        double var22 = var4 + block.minY;
        double var24 = var4 + block.maxY;
        double var26 = var6 + block.minZ;
        double var28 = var6 + block.maxZ;
        var9.addVertexWithUV(var20, var24, var28, var14, var16);
        var9.addVertexWithUV(var20, var24, var26, var12, var16);
        var9.addVertexWithUV(var20, var22, var26, var12, var18);
        var9.addVertexWithUV(var20, var22, var28, var14, var18);
    }

    public void renderSouthFace(Block block, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xF0;
        double var12 = ((double)var10 + block.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + block.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + block.minY * 16.0) / 256.0;
        double var18 = ((double)var11 + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 256.0f;
            var18 = ((float)var11 + 15.99f) / 256.0f;
        }
        var20 = var2 + block.maxX;
        double var22 = var4 + block.minY;
        double var24 = var4 + block.maxY;
        double var26 = var6 + block.minZ;
        double var28 = var6 + block.maxZ;
        var9.addVertexWithUV(var20, var22, var28, var12, var18);
        var9.addVertexWithUV(var20, var22, var26, var14, var18);
        var9.addVertexWithUV(var20, var24, var26, var14, var16);
        var9.addVertexWithUV(var20, var24, var28, var12, var16);
    }

    public void renderBlockAsItem(Block var1, float var2) {
        int var3 = var1.getRenderType();
        Tessellator var4 = Tessellator.instance;
        if (var3 == 0) {
            var1.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float var5 = 0.5f;
            float var6 = 1.0f;
            float var7 = 0.8f;
            float var8 = 0.6f;
            var4.startDrawingQuads();
            var4.setColorRGBA_F(var6, var6, var6, var2);
            this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
            var4.setColorRGBA_F(var5, var5, var5, var2);
            this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
            var4.setColorRGBA_F(var7, var7, var7, var2);
            this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
            this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
            var4.setColorRGBA_F(var8, var8, var8, var2);
            this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
            this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
            var4.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public void renderBlockOnInventory(Block var1) {
        int var2 = -1;
        Tessellator var3 = Tessellator.instance;
        int var4 = var1.getRenderType();
        if (var4 == 0) {
            var1.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
            var3.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (var4 == 1) {
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            this.renderCrossedSquares(var1, var2, -0.5, -0.5, -0.5);
            var3.draw();
        } else if (var4 == 13) {
            var1.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float var5 = 0.0625f;
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            var3.setTranslationF(0.0f, 0.0f, var5);
            this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
            var3.setTranslationF(0.0f, 0.0f, -var5);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            var3.setTranslationF(0.0f, 0.0f, -var5);
            this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
            var3.setTranslationF(0.0f, 0.0f, var5);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            var3.setTranslationF(var5, 0.0f, 0.0f);
            this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
            var3.setTranslationF(-var5, 0.0f, 0.0f);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            var3.setTranslationF(-var5, 0.0f, 0.0f);
            this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
            var3.setTranslationF(var5, 0.0f, 0.0f);
            var3.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (var4 == 6) {
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBlockCropsImpl(var1, var2, -0.5, -0.5, -0.5);
            var3.draw();
        } else if (var4 == 2) {
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            this.renderTorchAtAngle(var1, -0.5, -0.5, -0.5, 0.0, 0.0);
            var3.draw();
        } else if (var4 == 10) {
            for (int var7 = 0; var7 < 2; ++var7) {
                if (var7 == 0) {
                    var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                }
                if (var7 == 1) {
                    var1.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var3.startDrawingQuads();
                var3.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 0.0f, -1.0f);
                this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 0.0f, 1.0f);
                this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(-1.0f, 0.0f, 0.0f);
                this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(1.0f, 0.0f, 0.0f);
                this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
                var3.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (var4 == 11) {
            for (int var7 = 0; var7 < 4; ++var7) {
                float var6 = 0.125f;
                if (var7 == 0) {
                    var1.setBlockBounds(0.5f - var6, 0.0f, 0.0f, 0.5f + var6, 1.0f, var6 * 2.0f);
                }
                if (var7 == 1) {
                    var1.setBlockBounds(0.5f - var6, 0.0f, 1.0f - var6 * 2.0f, 0.5f + var6, 1.0f, 1.0f);
                }
                var6 = 0.0625f;
                if (var7 == 2) {
                    var1.setBlockBounds(0.5f - var6, 1.0f - var6 * 3.0f, -var6 * 2.0f, 0.5f + var6, 1.0f - var6, 1.0f + var6 * 2.0f);
                }
                if (var7 == 3) {
                    var1.setBlockBounds(0.5f - var6, 0.5f - var6 * 3.0f, -var6 * 2.0f, 0.5f + var6, 0.5f - var6, 1.0f + var6 * 2.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var3.startDrawingQuads();
                var3.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 0.0f, -1.0f);
                this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(0.0f, 0.0f, 1.0f);
                this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(-1.0f, 0.0f, 0.0f);
                this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
                var3.draw();
                var3.startDrawingQuads();
                var3.setNormal(1.0f, 0.0f, 0.0f);
                this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
                var3.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static boolean renderItemIn3d(int var0) {
        return var0 == 0 ? true : (var0 == 13 ? true : (var0 == 10 ? true : var0 == 11));
    }
}

