/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public abstract class Render<T extends Entity> {
    protected RenderManager renderManager;
    private ModelBase modelBase = new ModelBiped();
    private RenderBlocks renderBlocks = new RenderBlocks();
    protected float shadowSize = 0.0f;
    protected float shadowOpaque = 1.0f;

    public abstract void doRender(T var1, double var2, double var4, double var6, float var8, float var9);

    protected void loadTexture(String var1) {
        RenderEngine var2 = this.renderManager.renderEngine;
        var2.bindTexture(var2.getTexture(var1));
    }

    protected void loadDownloadableImageTexture(String var1, String var2) {
        RenderEngine var3 = this.renderManager.renderEngine;
        var3.bindTexture(var3.getTextureForDownloadableImage(var1, var2));
    }

    private void renderEntityOnFire(T var1, double var2, double var4, double var6, float var8) {
        GL11.glDisable((int)2896);
        int var9 = Block.fire.blockIndexInTexture;
        int var10 = (var9 & 0xF) << 4;
        int var11 = var9 & 0xF0;
        float var12 = (float)var10 / 256.0f;
        float var13 = ((float)var10 + 15.99f) / 256.0f;
        float var14 = (float)var11 / 256.0f;
        float var15 = ((float)var11 + 15.99f) / 256.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)var2), (float)((float)var4), (float)((float)var6));
        float var16 = ((Entity)var1).width * 1.4f;
        GL11.glScalef((float)var16, (float)var16, (float)var16);
        this.loadTexture("/terrain.png");
        Tessellator var17 = Tessellator.instance;
        float var18 = 1.0f;
        float var19 = 0.5f;
        float var20 = 0.0f;
        float var21 = ((Entity)var1).height / ((Entity)var1).width;
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.4f + (float)((int)var21) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var17.startDrawingQuads();
        while (var21 > 0.0f) {
            var17.addVertexWithUV(var18 - var19, 0.0f - var20, 0.0, var13, var15);
            var17.addVertexWithUV(0.0f - var19, 0.0f - var20, 0.0, var12, var15);
            var17.addVertexWithUV(0.0f - var19, 1.4f - var20, 0.0, var12, var14);
            var17.addVertexWithUV(var18 - var19, 1.4f - var20, 0.0, var13, var14);
            var21 -= 1.0f;
            var20 -= 1.0f;
            var18 *= 0.9f;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.04f);
        }
        var17.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(T var1, double var2, double var4, double var6, float var8, float var9) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderEngine var10 = this.renderManager.renderEngine;
        var10.bindTexture(var10.getTexture("%%/shadow.png"));
        World var11 = this.getWorldFromRenderManager();
        GL11.glDepthMask((boolean)false);
        float var12 = this.shadowSize;
        double var13 = ((Entity)var1).lastTickPosX + (((Entity)var1).posX - ((Entity)var1).lastTickPosX) * (double)var9;
        double var15 = ((Entity)var1).lastTickPosY + (((Entity)var1).posY - ((Entity)var1).lastTickPosY) * (double)var9 + (double)((Entity)var1).getShadowSize();
        double var17 = ((Entity)var1).lastTickPosZ + (((Entity)var1).posZ - ((Entity)var1).lastTickPosZ) * (double)var9;
        int var19 = MathHelper.floor_double(var13 - (double)var12);
        int var20 = MathHelper.floor_double(var13 + (double)var12);
        int var21 = MathHelper.floor_double(var15 - (double)var12);
        int var22 = MathHelper.floor_double(var15);
        int var23 = MathHelper.floor_double(var17 - (double)var12);
        int var24 = MathHelper.floor_double(var17 + (double)var12);
        double var25 = var2 - var13;
        double var27 = var4 - var15;
        double var29 = var6 - var17;
        Tessellator var31 = Tessellator.instance;
        var31.startDrawingQuads();
        for (int var32 = var19; var32 <= var20; ++var32) {
            for (int var33 = var21; var33 <= var22; ++var33) {
                for (int var34 = var23; var34 <= var24; ++var34) {
                    int var35 = var11.getBlockId(var32, var33 - 1, var34);
                    if (var35 <= 0 || var11.getBlockLightValue(var32, var33, var34) <= 3) continue;
                    this.renderShadowOnBlock(Block.blocksList[var35], var2, var4 + (double)((Entity)var1).getShadowSize(), var6, var32, var33, var34, var8, var12, var25, var27 + (double)((Entity)var1).getShadowSize(), var29);
                }
            }
        }
        var31.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.worldObj;
    }

    private void renderShadowOnBlock(Block var1, double var2, double var4, double var6, int var8, int var9, int var10, float var11, float var12, double var13, double var15, double var17) {
        double var20;
        Tessellator var19 = Tessellator.instance;
        if (var1.renderAsNormalBlock() && (var20 = ((double)var11 - (var4 - ((double)var9 + var15)) / 2.0) * 0.5 * (double)this.getWorldFromRenderManager().getBrightness(var8, var9, var10)) >= 0.0) {
            if (var20 > 1.0) {
                var20 = 1.0;
            }
            var19.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)var20);
            double var22 = (double)var8 + var1.minX + var13;
            double var24 = (double)var8 + var1.maxX + var13;
            double var26 = (double)var9 + var1.minY + var15 + 0.015625;
            double var28 = (double)var10 + var1.minZ + var17;
            double var30 = (double)var10 + var1.maxZ + var17;
            float var32 = (float)((var2 - var22) / 2.0 / (double)var12 + 0.5);
            float var33 = (float)((var2 - var24) / 2.0 / (double)var12 + 0.5);
            float var34 = (float)((var6 - var28) / 2.0 / (double)var12 + 0.5);
            float var35 = (float)((var6 - var30) / 2.0 / (double)var12 + 0.5);
            var19.addVertexWithUV(var22, var26, var28, var32, var34);
            var19.addVertexWithUV(var22, var26, var30, var32, var35);
            var19.addVertexWithUV(var24, var26, var30, var33, var35);
            var19.addVertexWithUV(var24, var26, var28, var33, var34);
        }
    }

    public static void renderOffsetAABB(AxisAlignedBB var0, double var1, double var3, double var5) {
        GL11.glDisable((int)3553);
        Tessellator var7 = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var7.startDrawingQuads();
        var7.setTranslationD(var1, var3, var5);
        var7.setNormal(0.0f, 0.0f, -1.0f);
        var7.addVertex(var0.minX, var0.maxY, var0.minZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var7.addVertex(var0.maxX, var0.minY, var0.minZ);
        var7.addVertex(var0.minX, var0.minY, var0.minZ);
        var7.setNormal(0.0f, 0.0f, 1.0f);
        var7.addVertex(var0.minX, var0.minY, var0.maxZ);
        var7.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var7.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var7.setNormal(0.0f, -1.0f, 0.0f);
        var7.addVertex(var0.minX, var0.minY, var0.minZ);
        var7.addVertex(var0.maxX, var0.minY, var0.minZ);
        var7.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var7.addVertex(var0.minX, var0.minY, var0.maxZ);
        var7.setNormal(0.0f, 1.0f, 0.0f);
        var7.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var7.addVertex(var0.minX, var0.maxY, var0.minZ);
        var7.setNormal(-1.0f, 0.0f, 0.0f);
        var7.addVertex(var0.minX, var0.minY, var0.maxZ);
        var7.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var7.addVertex(var0.minX, var0.maxY, var0.minZ);
        var7.addVertex(var0.minX, var0.minY, var0.minZ);
        var7.setNormal(1.0f, 0.0f, 0.0f);
        var7.addVertex(var0.maxX, var0.minY, var0.minZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var7.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var7.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var7.setTranslationD(0.0, 0.0, 0.0);
        var7.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AxisAlignedBB var0) {
        Tessellator var1 = Tessellator.instance;
        var1.startDrawingQuads();
        var1.addVertex(var0.minX, var0.maxY, var0.minZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var1.addVertex(var0.maxX, var0.minY, var0.minZ);
        var1.addVertex(var0.minX, var0.minY, var0.minZ);
        var1.addVertex(var0.minX, var0.minY, var0.maxZ);
        var1.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.minX, var0.minY, var0.minZ);
        var1.addVertex(var0.maxX, var0.minY, var0.minZ);
        var1.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var1.addVertex(var0.minX, var0.minY, var0.maxZ);
        var1.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var1.addVertex(var0.minX, var0.maxY, var0.minZ);
        var1.addVertex(var0.minX, var0.minY, var0.maxZ);
        var1.addVertex(var0.minX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.minX, var0.maxY, var0.minZ);
        var1.addVertex(var0.minX, var0.minY, var0.minZ);
        var1.addVertex(var0.maxX, var0.minY, var0.minZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.minZ);
        var1.addVertex(var0.maxX, var0.maxY, var0.maxZ);
        var1.addVertex(var0.maxX, var0.minY, var0.maxZ);
        var1.draw();
    }

    public void setRenderManager(RenderManager var1) {
        this.renderManager = var1;
    }

    public void doRenderShadowAndFire(T var1, double var2, double var4, double var6, float var8, float var9) {
        double var10;
        float var12;
        if (this.renderManager.options.fancyGraphics && this.shadowSize > 0.0f && (var12 = (float)((1.0 - (var10 = this.renderManager.getDistanceToCamera(((Entity)var1).posX, ((Entity)var1).posY, ((Entity)var1).posZ)) / 256.0) * (double)this.shadowOpaque)) > 0.0f) {
            this.renderShadow(var1, var2, var4, var6, var12, var9);
        }
        if (((Entity)var1).fire > 0) {
            this.renderEntityOnFire(var1, var2, var4, var6, var9);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }
}

