/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.TileEntity;

public class Packet59ComplexEntity
extends Packet {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public byte[] compressedNBT;
    public NBTTagCompound tileEntityNBT;

    public Packet59ComplexEntity() {
        this.isChunkDataPacket = true;
    }

    public Packet59ComplexEntity(int x, int y, int z, TileEntity tileEntity) {
        this.isChunkDataPacket = true;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.tileEntityNBT = new NBTTagCompound();
        tileEntity.writeToNBT(this.tileEntityNBT);
        try {
            this.compressedNBT = CompressedStreamTools.compress(this.tileEntityNBT);
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
    }

    @Override
    public void readPacketData(DataInputStream var1) throws IOException {
        this.xCoord = var1.readInt();
        this.yCoord = var1.readShort();
        this.zCoord = var1.readInt();
        int var2 = var1.readShort() & 0xFFFF;
        this.compressedNBT = new byte[var2];
        var1.readFully(this.compressedNBT);
        this.tileEntityNBT = CompressedStreamTools.decompress(this.compressedNBT);
    }

    @Override
    public void writePacket(DataOutputStream var1) throws IOException {
        var1.writeInt(this.xCoord);
        var1.writeShort(this.yCoord);
        var1.writeInt(this.zCoord);
        var1.writeShort((short)this.compressedNBT.length);
        var1.write(this.compressedNBT);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleComplexEntity(this);
    }

    @Override
    public int getPacketSize() {
        return this.compressedNBT.length + 2 + 10;
    }
}

