/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet0KeepAlive;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet11PlayerPosition;
import net.minecraft.src.Packet12PlayerLook;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet17AddToInventory;
import net.minecraft.src.Packet18ArmAnimation;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet22Collect;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet30Entity;
import net.minecraft.src.Packet31RelEntityMove;
import net.minecraft.src.Packet32EntityLook;
import net.minecraft.src.Packet33RelEntityMoveLook;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet59ComplexEntity;
import net.minecraft.src.Packet5PlayerInventory;
import net.minecraft.src.Packet6SpawnPosition;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    public boolean isChunkDataPacket = false;

    static void addIdClassMapping(int id, Class packetClass) {
        if (packetIdToClassMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate packet id:" + id);
        }
        if (packetClassToIdMap.containsKey(packetClass)) {
            throw new IllegalArgumentException("Duplicate packet class:" + packetClass);
        }
        packetIdToClassMap.put(id, packetClass);
        packetClassToIdMap.put(packetClass, id);
    }

    public static Packet getNewPacket(int id) {
        try {
            Class var1 = (Class)packetIdToClassMap.get(id);
            return var1 == null ? null : (Packet)var1.newInstance();
        }
        catch (Exception var2) {
            var2.printStackTrace();
            System.out.println("Skipping packet with id " + id);
            return null;
        }
    }

    public final int getPacketId() throws IOException {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dataInputStream) throws IOException {
        int var1 = dataInputStream.read();
        if (var1 == -1) {
            return null;
        }
        Packet var2 = Packet.getNewPacket(var1);
        if (var2 == null) {
            throw new IOException("Bad packet id " + var1);
        }
        var2.readPacketData(dataInputStream);
        return var2;
    }

    public static void writePacket(Packet packet, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(packet.getPacketId());
        packet.writePacket(dataOutputStream);
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacket(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static {
        Packet.addIdClassMapping(0, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, Packet1Login.class);
        Packet.addIdClassMapping(2, Packet2Handshake.class);
        Packet.addIdClassMapping(3, Packet3Chat.class);
        Packet.addIdClassMapping(4, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(10, Packet10Flying.class);
        Packet.addIdClassMapping(11, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, Packet15Place.class);
        Packet.addIdClassMapping(16, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, Packet17AddToInventory.class);
        Packet.addIdClassMapping(18, Packet18ArmAnimation.class);
        Packet.addIdClassMapping(20, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, Packet22Collect.class);
        Packet.addIdClassMapping(23, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, Packet24MobSpawn.class);
        Packet.addIdClassMapping(29, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, Packet30Entity.class);
        Packet.addIdClassMapping(31, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(50, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, Packet53BlockChange.class);
        Packet.addIdClassMapping(59, Packet59ComplexEntity.class);
        Packet.addIdClassMapping(255, Packet255KickDisconnect.class);
    }
}

