/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetworkMasterThread;
import net.minecraft.src.NetworkReaderThread;
import net.minecraft.src.NetworkWriterThread;
import net.minecraft.src.Packet;

public class NetworkManager {
    public static final Object threadSyncObject = new Object();
    public static int numReadThreads;
    public static int numWriteThreads;
    private Object sendQueueLock = new Object();
    private Socket networkSocket;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private boolean isRunning = true;
    private List readPackets = Collections.synchronizedList(new LinkedList());
    private List dataPackets = Collections.synchronizedList(new LinkedList());
    private List chunkDataPackets = Collections.synchronizedList(new LinkedList());
    private NetHandler netHandler;
    private boolean isServerTerminating = false;
    private Thread writeThread;
    private Thread readThread;
    private boolean isTerminating = false;
    private String terminationReason = "";
    private int timeSinceLastRead = 0;
    private int sendQueueByteLength = 0;
    private int chunkDataSendCounter = 0;

    public NetworkManager(Socket socket, String name, NetHandler netHandler) throws IOException {
        this.networkSocket = socket;
        this.netHandler = netHandler;
        socket.setTrafficClass(24);
        this.socketInputStream = new DataInputStream(socket.getInputStream());
        this.socketOutputStream = new DataOutputStream(socket.getOutputStream());
        this.readThread = new NetworkReaderThread(this, name + " read thread");
        this.writeThread = new NetworkWriterThread(this, name + " write thread");
        this.readThread.start();
        this.writeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSendQueue(Packet packet) {
        if (!this.isServerTerminating) {
            Object var2 = this.sendQueueLock;
            Object object = this.sendQueueLock;
            synchronized (object) {
                this.sendQueueByteLength += packet.getPacketSize() + 1;
                if (packet.isChunkDataPacket) {
                    this.chunkDataPackets.add(packet);
                } else {
                    this.dataPackets.add(packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket() {
        block12: {
            try {
                Packet var2;
                Object object;
                Object var3;
                boolean var1 = true;
                if (!this.dataPackets.isEmpty()) {
                    var1 = false;
                    var3 = this.sendQueueLock;
                    object = this.sendQueueLock;
                    synchronized (object) {
                        var2 = (Packet)this.dataPackets.remove(0);
                        this.sendQueueByteLength -= var2.getPacketSize() + 1;
                    }
                    Packet.writePacket(var2, this.socketOutputStream);
                }
                if ((var1 || this.chunkDataSendCounter-- <= 0) && !this.chunkDataPackets.isEmpty()) {
                    var1 = false;
                    var3 = this.sendQueueLock;
                    object = this.sendQueueLock;
                    synchronized (object) {
                        var2 = (Packet)this.chunkDataPackets.remove(0);
                        this.sendQueueByteLength -= var2.getPacketSize() + 1;
                    }
                    Packet.writePacket(var2, this.socketOutputStream);
                    this.chunkDataSendCounter = 50;
                }
                if (var1) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException var1) {
            }
            catch (Exception var9) {
                if (this.isTerminating) break block12;
                this.onNetworkError(var9);
            }
        }
    }

    private void readPacket() {
        block4: {
            try {
                Packet var1 = Packet.readPacket(this.socketInputStream);
                if (var1 != null) {
                    this.readPackets.add(var1);
                } else {
                    this.networkShutdown("End of stream");
                }
            }
            catch (Exception var2) {
                if (this.isTerminating) break block4;
                this.onNetworkError(var2);
            }
        }
    }

    private void onNetworkError(Exception exception) {
        exception.printStackTrace();
        this.networkShutdown("Internal exception: " + exception.toString());
    }

    public void networkShutdown(String reason) {
        if (this.isRunning) {
            this.isTerminating = true;
            this.terminationReason = reason;
            new NetworkMasterThread(this).start();
            this.isRunning = false;
            try {
                this.socketInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.socketOutputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.networkSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void processReadPackets() {
        if (this.sendQueueByteLength > 0x100000) {
            this.networkShutdown("Send buffer overflow");
        }
        if (this.readPackets.isEmpty()) {
            if (this.timeSinceLastRead++ == 1200) {
                this.networkShutdown("Timed out");
            }
        } else {
            this.timeSinceLastRead = 0;
        }
        int var1 = 100;
        while (!this.readPackets.isEmpty() && var1-- >= 0) {
            Packet var2 = (Packet)this.readPackets.remove(0);
            var2.processPacket(this.netHandler);
        }
        if (this.isTerminating && this.readPackets.isEmpty()) {
            this.netHandler.handleErrorMessage(this.terminationReason);
        }
    }

    static boolean isRunning(NetworkManager var0) {
        return var0.isRunning;
    }

    static boolean isServerTerminating(NetworkManager var0) {
        return var0.isServerTerminating;
    }

    static void readNetworkPacket(NetworkManager var0) {
        var0.readPacket();
    }

    static void sendNetworkPacket(NetworkManager var0) {
        var0.sendPacket();
    }

    static Thread getReadThread(NetworkManager var0) {
        return var0.readThread;
    }

    static Thread getWriteThread(NetworkManager var0) {
        return var0.writeThread;
    }
}

