/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityMob;
import net.minecraft.src.Item;
import net.minecraft.src.World;

public class MobGiant
extends EntityMob {
    public int maxHP = -1;

    public MobGiant(World var1, int var2) {
        super(var1);
        if (var2 <= 0) {
            var2 = 1;
        }
        this.texture = "/mob/collosal_a.png";
        this.moveSpeed = 0.5f;
        this.attackStrength = 50;
        this.health *= Math.min(4 * var2, 800);
        this.maxHP = this.health;
        this.yOffset *= 6.0f;
        this.setSize(this.width * 6.0f, this.height * 6.0f);
    }

    @Override
    protected float getBlockPathWeight(int var1, int var2, int var3) {
        return this.worldObj.getBrightness(var1, var2, var3) - 0.5f;
    }

    @Override
    protected void fall(float distance) {
    }

    @Override
    protected String getLivingSound() {
        return "ext.giantambient";
    }

    @Override
    protected String getHurtSound() {
        return "ext.gianthurt";
    }

    @Override
    protected String getDeathSound() {
        return "ext.giantdead";
    }

    @Override
    public void onDeath(Entity var1) {
        super.onDeath(var1);
        if (this.rand.nextInt(50) > 10) {
            this.dropItem(Item.flameberge.shiftedIndex, 1);
        }
    }
}

