/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.CraftingInventoryCB;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;

public class InventoryCrafting
implements IInventory {
    private ItemStack[] stackList;
    private int gridSize;
    private CraftingInventoryCB craftingInventory;

    public InventoryCrafting(CraftingInventoryCB var1, int var2, int var3) {
        this.gridSize = var2 * var3;
        this.stackList = new ItemStack[this.gridSize];
        this.craftingInventory = var1;
    }

    public InventoryCrafting(CraftingInventoryCB var1, ItemStack[] var2) {
        this.gridSize = var2.length;
        this.stackList = var2;
        this.craftingInventory = var1;
    }

    @Override
    public int getSizeInventory() {
        return this.gridSize;
    }

    @Override
    public ItemStack getStackInSlot(int var1) {
        return this.stackList[var1];
    }

    @Override
    public String getInvName() {
        return "Crafting";
    }

    @Override
    public ItemStack decrStackSize(int slot, int stackSize) {
        if (this.stackList[slot] != null) {
            if (this.stackList[slot].stackSize <= stackSize) {
                ItemStack var3 = this.stackList[slot];
                this.stackList[slot] = null;
                this.craftingInventory.onCraftMatrixChanged(this);
                return var3;
            }
            ItemStack var3 = this.stackList[slot].splitStack(stackSize);
            if (this.stackList[slot].stackSize == 0) {
                this.stackList[slot] = null;
            }
            this.craftingInventory.onCraftMatrixChanged(this);
            return var3;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.stackList[var1] = var2;
        this.craftingInventory.onCraftMatrixChanged(this);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }
}

