/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiDeleteWorld;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PlayerControllerSP;
import net.minecraft.src.World;

public class GuiSelectWorld
extends GuiScreen {
    protected GuiScreen parentScreen;
    protected String screenTitle = "Select world";
    private boolean selected = false;

    public GuiSelectWorld(GuiScreen var1) {
        this.parentScreen = var1;
    }

    @Override
    public void initGui() {
        File var1 = Minecraft.getMinecraftDir();
        for (int var2 = 0; var2 < 5; ++var2) {
            String var4;
            NBTTagCompound var3 = World.getLevelData(var1, "World" + (var2 + 1));
            if (var3 == null) {
                var4 = "World " + (var2 + 1);
                this.controlList.add(new GuiButton(var2, this.width / 2 - 100, this.height / 6 + 24 * var2, "- empty [" + var4 + "] -"));
                continue;
            }
            var4 = "World " + (var2 + 1);
            long var5 = var3.getLong("SizeOnDisk");
            var4 = var4 + " (" + (float)(var5 / 1024L * 100L / 1024L) / 100.0f + " MB)";
            this.controlList.add(new GuiButton(var2, this.width / 2 - 100, this.height / 6 + 24 * var2, var4));
        }
        this.initButtons();
    }

    protected String getSaveName(int var1) {
        File var2 = Minecraft.getMinecraftDir();
        return World.getLevelData(var2, "World" + var1) != null ? "World" + var1 : null;
    }

    public void initButtons() {
        this.controlList.add(new GuiButton(3, this.width / 2 - 170, this.height / 6 + 80, 60, 20, "<"));
        this.controlList.add(new GuiButton(3, this.width / 2 + 110, this.height / 6 + 80, 60, 20, ">"));
        this.controlList.add(new GuiButton(5, this.width / 2 - 100, this.height / 6 + 120 + 12, "Delete world..."));
        this.controlList.add(new GuiButton(6, this.width / 2 - 100, this.height / 6 + 168, "Cancel"));
        ((GuiButton)this.controlList.get((int)5)).enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton var1) {
        if (var1.enabled) {
            if (var1.id < 5) {
                this.selectWorld(var1.id + 1);
            } else if (var1.id == 5) {
                this.mc.displayGuiScreen(new GuiDeleteWorld(this));
            } else if (var1.id == 6) {
                this.mc.displayGuiScreen(this.parentScreen);
            }
        }
    }

    public void selectWorld(int var1) {
        this.mc.displayGuiScreen(null);
        if (!this.selected) {
            this.selected = true;
            this.mc.playerController = new PlayerControllerSP(this.mc);
            this.mc.startWorld("World" + var1);
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float renderPartialTick) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, renderPartialTick);
    }
}

