/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiFreerun;
import net.minecraft.src.GuiMultiplayer;
import net.minecraft.src.GuiOptions;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSelectWorld;
import net.minecraft.src.LogoEffectRandomizer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiMainMenu
extends GuiScreen {
    private static final Random rand = new Random();
    String[] logoBlockLayers = new String[]{" *   * * *   * *** *** *** *** *** ***", " ** ** * **  * *   *   * * * * *    * ", " * * * * * * * **  *   **  *** **   * ", " *   * * *  ** *   *   * * * * *    * ", " *   * * *   * *** *** * * * * *    * "};
    private LogoEffectRandomizer[][] logoEffects;
    private float updateCounter = 0.0f;
    private String splashString = "missingno";

    public GuiMainMenu() {
        try {
            ArrayList<String> arrayList1 = new ArrayList<String>();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(GuiMainMenu.class.getResourceAsStream("/title/splashes.txt")));
            String string3 = "";
            while ((string3 = bufferedReader2.readLine()) != null) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                arrayList1.add(string3);
            }
            this.splashString = (String)arrayList1.get(rand.nextInt(arrayList1.size()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateScreen() {
        this.updateCounter += 1.0f;
        if (this.logoEffects != null) {
            for (int var1 = 0; var1 < this.logoEffects.length; ++var1) {
                for (int var2 = 0; var2 < this.logoEffects[var1].length; ++var2) {
                    this.logoEffects[var1][var2].updateLogoEffects();
                }
            }
        }
    }

    @Override
    protected void keyTyped(char var1, int var2) {
    }

    @Override
    public void initGui() {
        Calendar var1 = Calendar.getInstance();
        var1.setTime(new Date());
        if (var1.get(2) + 1 == 11 && var1.get(5) == 9) {
            this.splashString = "Happy birthday, ez!";
        } else if (var1.get(2) + 1 == 6 && var1.get(5) == 1) {
            this.splashString = "Happy birthday, Notch!";
        } else if (var1.get(2) + 1 == 12 && var1.get(5) == 24) {
            this.splashString = "Merry X-mas!";
        } else if (var1.get(2) + 1 == 1 && var1.get(5) == 1) {
            this.splashString = "Happy new year!";
        }
        this.controlList.clear();
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 48, 140, 20, "Singleplayer"));
        this.controlList.add(new GuiButton(-1, this.width / 2 + 40, this.height / 4 + 48, 60, 20, "Quickplay"));
        this.controlList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 + 72, "Multiplayer"));
        this.controlList.add(new GuiButton(3, this.width / 2 - 100, this.height / 4 + 96, "Play tutorial level"));
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, 120, 20, "Options"));
        this.controlList.add(new GuiButton(4, this.width / 2 + 20, this.height / 4 + 120 + 12, 80, 20, "Exit"));
        if (this.mc.session == null) {
            ((GuiButton)this.controlList.get((int)1)).enabled = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton var1) {
        if (var1.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.options));
        }
        if (var1.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (var1.id == 2) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        }
        if (var1.id == 3) {
            this.mc.displayGuiScreen(new GuiFreerun(this));
        }
        if (var1.id == 4) {
            this.mc.shutdown();
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float renderPartialTick) {
        this.drawDefaultBackground();
        Tessellator var4 = Tessellator.instance;
        this.drawLogo(renderPartialTick);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/logo.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var4.setColorOpaque_I(0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 90), (float)70.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float var5 = (1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f)) * 100.0f / (float)(this.fontRenderer.getStringWidth(this.splashString) + 32);
        GL11.glScalef((float)var5, (float)var5, (float)var5);
        this.drawCenteredString(this.fontRenderer, this.splashString, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        this.drawString(this.fontRenderer, "Copyright Mojang. Distribution strictly prohibited.", this.width - this.fontRenderer.getStringWidth("Copyright Mojang. Distribution strictly prohibited.") - 2, this.height - 10, 0xFFFFFF);
        long var7 = Runtime.getRuntime().maxMemory();
        long var9 = Runtime.getRuntime().totalMemory();
        String var11 = "Free memory: " + (var7 - Runtime.getRuntime().freeMemory()) * 100L / var7 + "% of " + var7 / 1024L / 1024L + "MB";
        this.drawString(this.fontRenderer, var11, this.width - this.fontRenderer.getStringWidth(var11) - 2, 2, 0x808080);
        String var12 = "Allocated memory: " + var9 * 100L / var7 + "% (" + var9 / 1024L / 1024L + "MB)";
        this.drawString(this.fontRenderer, var12, this.width - this.fontRenderer.getStringWidth(var12) - 2, 12, 0x808080);
        super.drawScreen(mouseX, mouseY, renderPartialTick);
    }

    private void drawLogo(float renderPartialTick) {
        int var3;
        int var2;
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[this.logoBlockLayers[0].length()][this.logoBlockLayers.length];
            for (var2 = 0; var2 < this.logoEffects.length; ++var2) {
                for (var3 = 0; var3 < this.logoEffects[var2].length; ++var3) {
                    this.logoEffects[var2][var3] = new LogoEffectRandomizer(this, var2, var3);
                }
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        var2 = 120 * new ScaledResolution((int)this.mc.displayWidth, (int)this.mc.displayHeight).scaleFactor;
        GLU.gluPerspective((float)70.0f, (float)((float)this.mc.displayWidth / (float)var2), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.mc.displayHeight - var2), (int)this.mc.displayWidth, (int)var2);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        for (var3 = 0; var3 < 3; ++var3) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)0.6f, (float)-12.0f);
            if (var3 == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (var3 == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (var3 == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-this.logoBlockLayers[0].length()) * 0.5f), (float)((float)(-this.logoBlockLayers.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (var3 == 0) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/black.png"));
            }
            RenderBlocks var4 = new RenderBlocks();
            for (int var5 = 0; var5 < this.logoBlockLayers.length; ++var5) {
                for (int var6 = 0; var6 < this.logoBlockLayers[var5].length(); ++var6) {
                    if (this.logoBlockLayers[var5].charAt(var6) == ' ') continue;
                    GL11.glPushMatrix();
                    LogoEffectRandomizer var7 = this.logoEffects[var6][var5];
                    float var8 = (float)(var7.prevHeight + (var7.height - var7.prevHeight) * (double)renderPartialTick);
                    float var9 = 1.0f;
                    float var10 = 1.0f;
                    if (var3 == 0) {
                        var9 = var8 * 0.04f + 1.0f;
                        var10 = 1.0f / var9;
                        var8 = 0.0f;
                    }
                    GL11.glTranslatef((float)var6, (float)var5, (float)var8);
                    GL11.glScalef((float)var9, (float)var9, (float)var9);
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var4.renderBlockAsItem(Block.stone, var10);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        GL11.glEnable((int)2884);
    }

    public static Random getRandom() {
        return rand;
    }
}

