/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMob;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.World;

public class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public byte unusedMiningCooldown = 0;
    public int score = 0;
    public float prevCameraYaw;
    public float cameraYaw;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    private int damageRemainder = 0;
    public Random rand;

    public EntityPlayer(World var1) {
        super(var1);
        this.yOffset = 1.62f;
        this.setLocationAndAngles((double)var1.spawnX + 0.5, var1.spawnY + 1, (double)var1.spawnZ + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.entityType = "humanoid";
        this.unusedRotation = 180.0f;
        this.fireResistance = 20;
        this.texture = "/char.png";
        this.rand = new Random();
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        this.prevCameraYaw = this.cameraYaw;
        this.cameraYaw = 0.0f;
    }

    @Override
    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.health = 20;
        this.deathTime = 0;
    }

    @Override
    protected void updateEntityActionState() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt == 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    @Override
    public void onLivingUpdate() {
        List var3;
        if (this.worldObj.difficultySetting == 0 && this.health < 20 && this.ticksExisted % 20 * 4 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.prevCameraYaw = this.cameraYaw;
        super.onLivingUpdate();
        float var1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float var2 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (var1 > 0.1f) {
            var1 = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            var1 = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            var2 = 0.0f;
        }
        this.cameraYaw += (var1 - this.cameraYaw) * 0.4f;
        this.cameraPitch += (var2 - this.cameraPitch) * 0.8f;
        if (this.health > 0 && (var3 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                this.collideWithPlayer((Entity)var3.get(var4));
            }
        }
        if (this.posY < -1.0) {
            this.posZ += (double)(this.rand.nextFloat() * 500.0f + 500.0f);
            int var6 = 80;
            boolean var7 = false;
            while (var6 != 0) {
                int var5 = this.worldObj.getBlockId((int)this.posX, var6, (int)this.posZ);
                if (var5 != 0 && var5 != 116) {
                    if (var7) {
                        ++var6;
                        break;
                    }
                    ++var6;
                    continue;
                }
                --var6;
                var7 = true;
            }
            this.posY = var6;
            this.setPosition(this.posX, this.posY, this.posZ);
            System.out.println("Sending player to Brazil at: " + this.posX + " " + this.posY + " " + this.posZ);
        }
    }

    private void collideWithPlayer(Entity entity) {
        entity.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void onDeath(Entity var1) {
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.username.equals("Notch")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.appleRed, 1), true);
        }
        this.inventory.dropAllItems();
        if (var1 != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
    }

    @Override
    public void addToPlayerScore(Entity var1, int var2) {
        this.score += var2;
    }

    public void dropPlayerItem(ItemStack itemStack) {
        this.dropPlayerItemWithRandomChoice(itemStack, false);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack itemStack, boolean isRandom) {
        if (itemStack != null) {
            EntityItem var3 = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.getEyeHeight(), this.posZ, itemStack);
            var3.delayBeforeCanPickup = 40;
            if (isRandom) {
                float var4 = this.rand.nextFloat() * 0.5f;
                float var5 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                var3.motionX = -MathHelper.sin(var5) * var4;
                var3.motionZ = MathHelper.cos(var5) * var4;
                var3.motionY = 0.2f;
            } else {
                var3.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * 0.3f;
                var3.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * 0.3f;
                var3.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI) * 0.3f + 0.1f;
                float var6 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float var7 = 0.02f * this.rand.nextFloat();
                var3.motionX += Math.cos(var6) * (double)var7;
                var3.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                var3.motionZ += Math.sin(var6) * (double)var7;
            }
            this.joinEntityItemWithWorld(var3);
        }
    }

    protected void joinEntityItemWithWorld(EntityItem entityItem) {
        this.worldObj.spawnEntityInWorld(entityItem);
    }

    public float getCurrentPlayerStrVsBlock(Block block) {
        float var2 = this.inventory.getStrVsBlock(block);
        if (this.isInsideOfMaterial(Material.water)) {
            var2 /= 5.0f;
        }
        if (!this.onGround) {
            var2 /= 5.0f;
        }
        return var2;
    }

    public boolean canHarvestBlock(Block block) {
        return this.inventory.canHarvestBlock(block);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.inventory.readFromNBT(var1.getTagList("Inventory"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
    }

    public void displayGUIChest(IInventory inventory) {
    }

    public void displayWorkbenchGUI() {
    }

    public void displayEssenceGUI() {
    }

    public void onItemPickup(Entity entity, int var2) {
    }

    @Override
    protected float getEyeHeight() {
        return 0.12f;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            return false;
        }
        if (var1 instanceof EntityMob || var1 instanceof EntityArrow) {
            if (this.worldObj.difficultySetting == 0) {
                var2 = 0;
            }
            if (this.worldObj.difficultySetting == 1) {
                var2 = var2 / 3 + 1;
            }
            if (this.worldObj.difficultySetting == 3) {
                var2 = var2 * 3 / 2;
            }
        }
        int var3 = var2 * (25 - this.inventory.getTotalArmorValue()) + this.damageRemainder;
        this.inventory.damageArmor(var2);
        var2 = var3 / 25;
        this.damageRemainder = var3 % 25;
        return var2 != 0 && super.attackEntityFrom(var1, var2);
    }

    public void displayGUIFurnace(TileEntityFurnace furnaceTileEntity) {
    }

    public void displayGUIEditSign(TileEntitySign signTileEntity) {
    }

    public void interactWithEntity(Entity entity) {
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }
}

