/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] cargoItems = new ItemStack[36];
    public int damageTaken = 0;
    public int timeSinceHit = 0;
    public int forwardDirection = 1;
    private boolean isInReverse = false;
    public int minecartType;
    public int fuel;
    public double pushX;
    public double pushZ;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;

    public EntityMinecart(World var1) {
        super(var1);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
        this.yOffset = this.height / 2.0f;
        this.canTriggerWalking = false;
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity var1) {
        return var1.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityMinecart(World worldObj, double x, double y, double z, int minecartType) {
        this(worldObj);
        this.setPosition(x, y + (double)this.yOffset, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.minecartType = minecartType;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        this.forwardDirection = -this.forwardDirection;
        this.timeSinceHit = 10;
        this.damageTaken += var2 * 10;
        if (this.damageTaken > 40) {
            this.entityDropItem(Item.minecartEmpty.shiftedIndex, 1, 0.0f);
            if (this.minecartType == 1) {
                this.entityDropItem(Block.chest.blockID, 1, 0.0f);
            } else if (this.minecartType == 2) {
                this.entityDropItem(Block.stoneOvenIdle.blockID, 1, 0.0f);
            }
            this.setEntityDead();
        }
        return true;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setEntityDead() {
        for (int var1 = 0; var1 < this.getSizeInventory(); ++var1) {
            ItemStack var2 = this.getStackInSlot(var1);
            if (var2 == null) continue;
            float var3 = this.rand.nextFloat() * 0.8f + 0.1f;
            float var4 = this.rand.nextFloat() * 0.8f + 0.1f;
            float var5 = this.rand.nextFloat() * 0.8f + 0.1f;
            while (var2.stackSize > 0) {
                int var6 = this.rand.nextInt(21) + 10;
                if (var6 > var2.stackSize) {
                    var6 = var2.stackSize;
                }
                var2.stackSize -= var6;
                EntityItem var7 = new EntityItem(this.worldObj, this.posX + (double)var3, this.posY + (double)var4, this.posZ + (double)var5, new ItemStack(var2.itemID, var6, var2.itemDmg));
                float var8 = 0.05f;
                var7.motionX = (float)this.rand.nextGaussian() * var8;
                var7.motionY = (float)this.rand.nextGaussian() * var8 + 0.2f;
                var7.motionZ = (float)this.rand.nextGaussian() * var8;
                this.worldObj.spawnEntityInWorld(var7);
            }
        }
        super.setEntityDead();
    }

    @Override
    public void onUpdate() {
        if (this.worldObj.multiplayerWorld) {
            if (this.turnProgress > 0) {
                double var7;
                double var41 = this.posX + (this.minecartX - this.posX) / (double)this.turnProgress;
                double var42 = this.posY + (this.minecartY - this.posY) / (double)this.turnProgress;
                double var5 = this.posZ + (this.minecartZ - this.posZ) / (double)this.turnProgress;
                for (var7 = this.minecartYaw - (double)this.rotationYaw; var7 < -180.0; var7 += 360.0) {
                }
                while (var7 >= 180.0) {
                    var7 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.turnProgress);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.minecartPitch - (double)this.rotationPitch) / (double)this.turnProgress);
                --this.turnProgress;
                this.setPosition(var41, var42, var5);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
        } else {
            double var13;
            int var3;
            int var2;
            if (this.timeSinceHit > 0) {
                --this.timeSinceHit;
            }
            if (this.damageTaken > 0) {
                --this.damageTaken;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.motionY -= (double)0.04f;
            int var1 = MathHelper.floor_double(this.posX);
            if (this.worldObj.getBlockId(var1, (var2 = MathHelper.floor_double(this.posY)) - 1, var3 = MathHelper.floor_double(this.posZ)) == Block.minecartTrack.blockID) {
                --var2;
            }
            double var4 = 0.4;
            boolean var6 = false;
            double var7 = 0.0078125;
            if (this.worldObj.getBlockId(var1, var2, var3) == Block.minecartTrack.blockID) {
                double var39;
                double var36;
                double var34;
                double var32;
                Vec3D var9 = this.getPos(this.posX, this.posY, this.posZ);
                int var10 = this.worldObj.getBlockMetadata(var1, var2, var3);
                this.posY = var2;
                if (var10 >= 2 && var10 <= 5) {
                    this.posY = var2 + 1;
                }
                if (var10 == 2) {
                    this.motionX -= var7;
                }
                if (var10 == 3) {
                    this.motionX += var7;
                }
                if (var10 == 4) {
                    this.motionZ += var7;
                }
                if (var10 == 5) {
                    this.motionZ -= var7;
                }
                int[][] var11 = matrix[var10];
                double var12 = var11[1][0] - var11[0][0];
                double var14 = var11[1][2] - var11[0][2];
                double var16 = Math.sqrt(var12 * var12 + var14 * var14);
                double var18 = this.motionX * var12 + this.motionZ * var14;
                if (var18 < 0.0) {
                    var12 = -var12;
                    var14 = -var14;
                }
                double var20 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                this.motionX = var20 * var12 / var16;
                this.motionZ = var20 * var14 / var16;
                double var22 = 0.0;
                double var24 = (double)var1 + 0.5 + (double)var11[0][0] * 0.5;
                double var26 = (double)var3 + 0.5 + (double)var11[0][2] * 0.5;
                double var28 = (double)var1 + 0.5 + (double)var11[1][0] * 0.5;
                double var30 = (double)var3 + 0.5 + (double)var11[1][2] * 0.5;
                var12 = var28 - var24;
                var14 = var30 - var26;
                if (var12 == 0.0) {
                    this.posX = (double)var1 + 0.5;
                    var22 = this.posZ - (double)var3;
                } else if (var14 == 0.0) {
                    this.posZ = (double)var3 + 0.5;
                    var22 = this.posX - (double)var1;
                } else {
                    var32 = this.posX - var24;
                    var34 = this.posZ - var26;
                    var22 = var36 = (var32 * var12 + var34 * var14) * 2.0;
                }
                this.posX = var24 + var12 * var22;
                this.posZ = var26 + var14 * var22;
                this.setPosition(this.posX, this.posY + (double)this.yOffset, this.posZ);
                var32 = this.motionX;
                var34 = this.motionZ;
                if (this.riddenByEntity != null) {
                    var32 *= 0.75;
                    var34 *= 0.75;
                }
                if (var32 < -var4) {
                    var32 = -var4;
                }
                if (var32 > var4) {
                    var32 = var4;
                }
                if (var34 < -var4) {
                    var34 = -var4;
                }
                if (var34 > var4) {
                    var34 = var4;
                }
                this.moveEntity(var32, 0.0, var34);
                if (var11[0][1] != 0 && MathHelper.floor_double(this.posX) - var1 == var11[0][0] && MathHelper.floor_double(this.posZ) - var3 == var11[0][2]) {
                    this.setPosition(this.posX, this.posY + (double)var11[0][1], this.posZ);
                } else if (var11[1][1] != 0 && MathHelper.floor_double(this.posX) - var1 == var11[1][0] && MathHelper.floor_double(this.posZ) - var3 == var11[1][2]) {
                    this.setPosition(this.posX, this.posY + (double)var11[1][1], this.posZ);
                }
                if (this.riddenByEntity != null) {
                    this.motionX *= (double)0.997f;
                    this.motionY *= 0.0;
                    this.motionZ *= (double)0.997f;
                } else {
                    if (this.minecartType == 2) {
                        var36 = MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ);
                        if (var36 > 0.01) {
                            var6 = true;
                            this.pushX /= var36;
                            this.pushZ /= var36;
                            double var38 = 0.04;
                            this.motionX *= (double)0.8f;
                            this.motionY *= 0.0;
                            this.motionZ *= (double)0.8f;
                            this.motionX += this.pushX * var38;
                            this.motionZ += this.pushZ * var38;
                        } else {
                            this.motionX *= (double)0.9f;
                            this.motionY *= 0.0;
                            this.motionZ *= (double)0.9f;
                        }
                    }
                    this.motionX *= (double)0.96f;
                    this.motionY *= 0.0;
                    this.motionZ *= (double)0.96f;
                }
                Vec3D var46 = this.getPos(this.posX, this.posY, this.posZ);
                if (var46 != null && var9 != null) {
                    double var37 = (var9.yCoord - var46.yCoord) * 0.05;
                    var20 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                    if (var20 > 0.0) {
                        this.motionX = this.motionX / var20 * (var20 + var37);
                        this.motionZ = this.motionZ / var20 * (var20 + var37);
                    }
                    this.setPosition(this.posX, var46.yCoord, this.posZ);
                }
                int var47 = MathHelper.floor_double(this.posX);
                int var48 = MathHelper.floor_double(this.posZ);
                if (var47 != var1 || var48 != var3) {
                    var20 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                    this.motionX = var20 * (double)(var47 - var1);
                    this.motionZ = var20 * (double)(var48 - var3);
                }
                if (this.minecartType == 2 && (var39 = (double)MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ)) > 0.01 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
                    this.pushX /= var39;
                    this.pushZ /= var39;
                    if (this.pushX * this.motionX + this.pushZ * this.motionZ < 0.0) {
                        this.pushX = 0.0;
                        this.pushZ = 0.0;
                    } else {
                        this.pushX = this.motionX;
                        this.pushZ = this.motionZ;
                    }
                }
            } else {
                if (this.motionX < -var4) {
                    this.motionX = -var4;
                }
                if (this.motionX > var4) {
                    this.motionX = var4;
                }
                if (this.motionZ < -var4) {
                    this.motionZ = -var4;
                }
                if (this.motionZ > var4) {
                    this.motionZ = var4;
                }
                if (this.onGround) {
                    this.motionX *= 0.5;
                    this.motionY *= 0.5;
                    this.motionZ *= 0.5;
                }
                this.moveEntity(this.motionX, this.motionY, this.motionZ);
                if (!this.onGround) {
                    this.motionX *= (double)0.95f;
                    this.motionY *= (double)0.95f;
                    this.motionZ *= (double)0.95f;
                }
            }
            this.rotationPitch = 0.0f;
            double var43 = this.prevPosX - this.posX;
            double var44 = this.prevPosZ - this.posZ;
            if (var43 * var43 + var44 * var44 > 0.001) {
                this.rotationYaw = (float)(Math.atan2(var44, var43) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.rotationYaw += 180.0f;
                }
            }
            for (var13 = (double)(this.rotationYaw - this.prevRotationYaw); var13 >= 180.0; var13 -= 360.0) {
            }
            while (var13 < -180.0) {
                var13 += 360.0;
            }
            if (var13 < -170.0 || var13 >= 170.0) {
                this.rotationYaw += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.setRotation(this.rotationYaw, this.rotationPitch);
            List var15 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
            if (var15 != null && var15.size() > 0) {
                for (int var45 = 0; var45 < var15.size(); ++var45) {
                    Entity var17 = (Entity)var15.get(var45);
                    if (var17 == this.riddenByEntity || !var17.canBePushed() || !(var17 instanceof EntityMinecart)) continue;
                    var17.applyEntityCollision(this);
                }
            }
            if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
                this.riddenByEntity = null;
            }
            if (var6 && this.rand.nextInt(4) == 0) {
                --this.fuel;
                if (this.fuel < 0) {
                    this.pushZ = 0.0;
                    this.pushX = 0.0;
                }
                this.worldObj.spawnParticle("largesmoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public Vec3D getPosOffset(double x, double y, double z, double offset) {
        int var11;
        int var10;
        int var9 = MathHelper.floor_double(x);
        if (this.worldObj.getBlockId(var9, (var10 = MathHelper.floor_double(y)) - 1, var11 = MathHelper.floor_double(z)) == Block.minecartTrack.blockID) {
            --var10;
        }
        if (this.worldObj.getBlockId(var9, var10, var11) == Block.minecartTrack.blockID) {
            int var12 = this.worldObj.getBlockMetadata(var9, var10, var11);
            y = var10;
            if (var12 >= 2 && var12 <= 5) {
                y = var10 + 1;
            }
            int[][] var13 = matrix[var12];
            double var14 = var13[1][0] - var13[0][0];
            double var16 = var13[1][2] - var13[0][2];
            double var18 = Math.sqrt(var14 * var14 + var16 * var16);
            if (var13[0][1] != 0 && MathHelper.floor_double(x += (var14 /= var18) * offset) - var9 == var13[0][0] && MathHelper.floor_double(z += (var16 /= var18) * offset) - var11 == var13[0][2]) {
                y += (double)var13[0][1];
            } else if (var13[1][1] != 0 && MathHelper.floor_double(x) - var9 == var13[1][0] && MathHelper.floor_double(z) - var11 == var13[1][2]) {
                y += (double)var13[1][1];
            }
            return this.getPos(x, y, z);
        }
        return null;
    }

    public Vec3D getPos(double x, double y, double z) {
        int var9;
        int var8;
        int var7 = MathHelper.floor_double(x);
        if (this.worldObj.getBlockId(var7, (var8 = MathHelper.floor_double(y)) - 1, var9 = MathHelper.floor_double(z)) == Block.minecartTrack.blockID) {
            --var8;
        }
        if (this.worldObj.getBlockId(var7, var8, var9) == Block.minecartTrack.blockID) {
            int var10 = this.worldObj.getBlockMetadata(var7, var8, var9);
            y = var8;
            if (var10 >= 2 && var10 <= 5) {
                y = var8 + 1;
            }
            int[][] var11 = matrix[var10];
            double var12 = 0.0;
            double var14 = (double)var7 + 0.5 + (double)var11[0][0] * 0.5;
            double var16 = (double)var8 + 0.5 + (double)var11[0][1] * 0.5;
            double var18 = (double)var9 + 0.5 + (double)var11[0][2] * 0.5;
            double var20 = (double)var7 + 0.5 + (double)var11[1][0] * 0.5;
            double var22 = (double)var8 + 0.5 + (double)var11[1][1] * 0.5;
            double var24 = (double)var9 + 0.5 + (double)var11[1][2] * 0.5;
            double var26 = var20 - var14;
            double var28 = (var22 - var16) * 2.0;
            double var30 = var24 - var18;
            if (var26 == 0.0) {
                x = (double)var7 + 0.5;
                var12 = z - (double)var9;
            } else if (var30 == 0.0) {
                z = (double)var9 + 0.5;
                var12 = x - (double)var7;
            } else {
                double var36;
                double var32 = x - var14;
                double var34 = z - var18;
                var12 = var36 = (var32 * var26 + var34 * var30) * 2.0;
            }
            x = var14 + var26 * var12;
            y = var16 + var28 * var12;
            z = var18 + var30 * var12;
            if (var28 < 0.0) {
                y += 1.0;
            }
            if (var28 > 0.0) {
                y += 0.5;
            }
            return Vec3D.createVector(x, y, z);
        }
        return null;
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound var1) {
        var1.setInteger("Type", this.minecartType);
        if (this.minecartType == 2) {
            var1.setDouble("PushX", this.pushX);
            var1.setDouble("PushZ", this.pushZ);
            var1.setShort("Fuel", (short)this.fuel);
        } else if (this.minecartType == 1) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.cargoItems[var3].writeToNBT(var4);
                var2.setTag(var4);
            }
            var1.setTag("Items", var2);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound var1) {
        this.minecartType = var1.getInteger("Type");
        if (this.minecartType == 2) {
            this.pushX = var1.getDouble("PushX");
            this.pushZ = var1.getDouble("PushZ");
            this.fuel = var1.getShort("Fuel");
        } else if (this.minecartType == 1) {
            NBTTagList var2 = var1.getTagList("Items");
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            for (int var3 = 0; var3 < var2.tagCount(); ++var3) {
                NBTTagCompound var4 = (NBTTagCompound)var2.tagAt(var3);
                int var5 = var4.getByte("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = new ItemStack(var4);
            }
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (entity != this.riddenByEntity) {
            double var4;
            double var2;
            double var6;
            if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer) && this.minecartType == 0 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && this.riddenByEntity == null && entity.ridingEntity == null) {
                entity.mountEntity(this);
            }
            if ((var6 = (var2 = entity.posX - this.posX) * var2 + (var4 = entity.posZ - this.posZ) * var4) >= (double)1.0E-4f) {
                var6 = MathHelper.sqrt_double(var6);
                var2 /= var6;
                var4 /= var6;
                double var8 = 1.0 / var6;
                if (var8 > 1.0) {
                    var8 = 1.0;
                }
                var2 *= var8;
                var4 *= var8;
                var2 *= (double)0.1f;
                var4 *= (double)0.1f;
                var2 *= (double)(1.0f - this.entityCollisionReduction);
                var4 *= (double)(1.0f - this.entityCollisionReduction);
                var2 *= 0.5;
                var4 *= 0.5;
                if (entity instanceof EntityMinecart) {
                    double var10 = entity.motionX + this.motionX;
                    double var12 = entity.motionZ + this.motionZ;
                    if (((EntityMinecart)entity).minecartType == 2 && this.minecartType != 2) {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity(entity.motionX - var2, 0.0, entity.motionZ - var4);
                        entity.motionX *= (double)0.7f;
                        entity.motionZ *= (double)0.7f;
                    } else if (((EntityMinecart)entity).minecartType != 2 && this.minecartType == 2) {
                        entity.motionX *= (double)0.2f;
                        entity.motionZ *= (double)0.2f;
                        entity.addVelocity(this.motionX + var2, 0.0, this.motionZ + var4);
                        this.motionX *= (double)0.7f;
                        this.motionZ *= (double)0.7f;
                    } else {
                        this.motionX *= (double)0.2f;
                        this.motionZ *= (double)0.2f;
                        this.addVelocity((var10 /= 2.0) - var2, 0.0, (var12 /= 2.0) - var4);
                        entity.motionX *= (double)0.2f;
                        entity.motionZ *= (double)0.2f;
                        entity.addVelocity(var10 + var2, 0.0, var12 + var4);
                    }
                } else {
                    this.addVelocity(-var2, 0.0, -var4);
                    entity.addVelocity(var2 / 4.0, 0.0, var4 / 4.0);
                }
            }
        }
    }

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public ItemStack getStackInSlot(int var1) {
        return this.cargoItems[var1];
    }

    @Override
    public ItemStack decrStackSize(int slot, int stackSize) {
        if (this.cargoItems[slot] != null) {
            if (this.cargoItems[slot].stackSize <= stackSize) {
                ItemStack var3 = this.cargoItems[slot];
                this.cargoItems[slot] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[slot].splitStack(stackSize);
            if (this.cargoItems[slot].stackSize == 0) {
                this.cargoItems[slot] = null;
            }
            return var3;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.cargoItems[var1] = var2;
        if (var2 != null && var2.stackSize > this.getInventoryStackLimit()) {
            var2.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Minecart";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public boolean interact(EntityPlayer var1) {
        if (this.minecartType == 0) {
            var1.mountEntity(this);
        } else if (this.minecartType == 1) {
            var1.displayGUIChest(this);
        } else if (this.minecartType == 2) {
            ItemStack var2 = var1.inventory.getCurrentItem();
            if (var2 != null && var2.itemID == Item.coal.shiftedIndex) {
                if (--var2.stackSize == 0) {
                    var1.inventory.setInventorySlotContents(var1.inventory.currentItem, null);
                }
                this.fuel += 1200;
            }
            this.pushX = this.posX - var1.posX;
            this.pushZ = this.posZ - var1.posZ;
        }
        return true;
    }

    @Override
    public void setPositionAndRotation(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.minecartX = var1;
        this.minecartY = var3;
        this.minecartZ = var5;
        this.minecartYaw = var7;
        this.minecartPitch = var8;
        this.turnProgress = var9;
    }
}

