/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityBoat
extends Entity {
    public int damageTaken = 0;
    public int timeSinceHit = 0;
    public int forwardDirection = 1;

    public EntityBoat(World var1) {
        super(var1);
        this.preventEntitySpawning = true;
        this.setSize(1.5f, 0.6f);
        this.yOffset = this.height / 2.0f;
        this.canTriggerWalking = false;
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity var1) {
        return var1.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityBoat(World worldObj, double x, double y, double z) {
        this(worldObj);
        this.setPosition(x, y + (double)this.yOffset, z);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        this.forwardDirection = -this.forwardDirection;
        this.timeSinceHit = 10;
        this.damageTaken += var2 * 10;
        if (this.damageTaken > 40) {
            int var3;
            for (var3 = 0; var3 < 3; ++var3) {
                this.entityDropItem(Block.planks.blockID, 1, 0.0f);
            }
            for (var3 = 0; var3 < 2; ++var3) {
                this.entityDropItem(Item.stick.shiftedIndex, 1, 0.0f);
            }
            this.setEntityDead();
        }
        return true;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        double var16;
        double var12;
        double var10;
        double var6;
        super.onUpdate();
        if (this.timeSinceHit > 0) {
            --this.timeSinceHit;
        }
        if (this.damageTaken > 0) {
            --this.damageTaken;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int var1 = 5;
        double var2 = 0.0;
        for (int var4 = 0; var4 < var1; ++var4) {
            double var5 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var4 + 0) / (double)var1 - 0.125;
            double var7 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var4 + 1) / (double)var1 - 0.125;
            AxisAlignedBB var9 = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, var5, this.boundingBox.minZ, this.boundingBox.maxX, var7, this.boundingBox.maxZ);
            if (!this.worldObj.isAABBInMaterial(var9, Material.water)) continue;
            var2 += 1.0 / (double)var1;
        }
        double var23 = var2 * 2.0 - 1.0;
        this.motionY += (double)0.04f * var23;
        if (this.riddenByEntity != null) {
            this.motionX += this.riddenByEntity.motionX * 0.2;
            this.motionZ += this.riddenByEntity.motionZ * 0.2;
        }
        if (this.motionX < -(var6 = 0.4)) {
            this.motionX = -var6;
        }
        if (this.motionX > var6) {
            this.motionX = var6;
        }
        if (this.motionZ < -var6) {
            this.motionZ = -var6;
        }
        if (this.motionZ > var6) {
            this.motionZ = var6;
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        double var8 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (var8 > 0.15) {
            var10 = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            var12 = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
            int var14 = 0;
            while ((double)var14 < 1.0 + var8 * 60.0) {
                double var21;
                double var19;
                double var15 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var17 = (double)(this.rand.nextInt(2) * 2 - 1) * 0.7;
                if (this.rand.nextBoolean()) {
                    var19 = this.posX - var10 * var15 * 0.8 + var12 * var17;
                    var21 = this.posZ - var12 * var15 * 0.8 - var10 * var17;
                    this.worldObj.spawnParticle("splash", var19, this.posY - 0.125, var21, this.motionX, this.motionY, this.motionZ);
                } else {
                    var19 = this.posX + var10 + var12 * var15 * 0.7;
                    var21 = this.posZ + var12 - var10 * var15 * 0.7;
                    this.worldObj.spawnParticle("splash", var19, this.posY - 0.125, var21, this.motionX, this.motionY, this.motionZ);
                }
                ++var14;
            }
        }
        if (this.isCollidedHorizontally && var8 > 0.15) {
            int var24;
            this.setEntityDead();
            for (var24 = 0; var24 < 3; ++var24) {
                this.entityDropItem(Block.planks.blockID, 1, 0.0f);
            }
            for (var24 = 0; var24 < 2; ++var24) {
                this.entityDropItem(Item.stick.shiftedIndex, 1, 0.0f);
            }
        } else {
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.95f;
            this.motionZ *= (double)0.99f;
        }
        this.rotationPitch = 0.0f;
        var10 = this.rotationYaw;
        var12 = this.prevPosX - this.posX;
        double var25 = this.prevPosZ - this.posZ;
        if (var12 * var12 + var25 * var25 > 0.001) {
            var10 = (float)(Math.atan2(var25, var12) * 180.0 / Math.PI);
        }
        for (var16 = var10 - (double)this.rotationYaw; var16 >= 180.0; var16 -= 360.0) {
        }
        while (var16 < -180.0) {
            var16 += 360.0;
        }
        if (var16 > 20.0) {
            var16 = 20.0;
        }
        if (var16 < -20.0) {
            var16 = -20.0;
        }
        this.rotationYaw = (float)((double)this.rotationYaw + var16);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List var18 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (var18 != null && var18.size() > 0) {
            for (int var26 = 0; var26 < var18.size(); ++var26) {
                Entity var20 = (Entity)var18.get(var26);
                if (var20 == this.riddenByEntity || !var20.canBePushed() || !(var20 instanceof EntityBoat)) continue;
                var20.applyEntityCollision(this);
            }
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            this.riddenByEntity = null;
        }
    }

    @Override
    protected void updateRiderPosition() {
        double var1 = Math.cos((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        double var3 = Math.sin((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        this.riddenByEntity.setPosition(this.posX + var1, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ + var3);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound var1) {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound var1) {
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public boolean interact(EntityPlayer var1) {
        var1.mountEntity(this);
        return true;
    }
}

