/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeSorter;
import net.minecraft.src.RecipesArmor;
import net.minecraft.src.RecipesCrafting;
import net.minecraft.src.RecipesFood;
import net.minecraft.src.RecipesIngots;
import net.minecraft.src.RecipesTools;
import net.minecraft.src.RecipesWeapons;

public class CraftingManager {
    private static final CraftingManager instance = new CraftingManager();
    private List recipes = new ArrayList();

    public static final CraftingManager getInstance() {
        return instance;
    }

    private CraftingManager() {
        new RecipesTools().addRecipes(this);
        new RecipesWeapons().addRecipes(this);
        new RecipesIngots().addRecipes(this);
        new RecipesFood().addRecipes(this);
        new RecipesCrafting().addRecipes(this);
        new RecipesArmor().addRecipes(this);
        this.addRecipe(new ItemStack(Item.paper, 3), "###", Character.valueOf('#'), Item.reed);
        this.addRecipe(new ItemStack(Item.book, 1), "#", "#", "#", Character.valueOf('#'), Item.paper);
        this.addRecipe(new ItemStack(Block.fence, 2), "###", "###", Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Block.jukebox, 1), "###", "#X#", "###", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.diamond);
        this.addRecipe(new ItemStack(Block.bookshelf, 1), "###", "XXX", "###", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.book);
        this.addRecipe(new ItemStack(Block.blockSnow, 1), "##", "##", Character.valueOf('#'), Item.snowball);
        this.addRecipe(new ItemStack(Block.blockClay, 1), "##", "##", Character.valueOf('#'), Item.clay);
        this.addRecipe(new ItemStack(Block.brick, 1), "##", "##", Character.valueOf('#'), Item.brick);
        this.addRecipe(new ItemStack(Block.cloth, 1), "###", "###", "###", Character.valueOf('#'), Item.silk);
        this.addRecipe(new ItemStack(Block.tnt, 1), "X#X", "#X#", "X#X", Character.valueOf('X'), Item.gunpowder, Character.valueOf('#'), Block.sand);
        this.addRecipe(new ItemStack(Block.stairSingle, 3), "###", Character.valueOf('#'), Block.cobblestone);
        this.addRecipe(new ItemStack(Block.ladder, 1), "# #", "###", "# #", Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Item.doorWood, 1), "##", "##", "##", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Item.doorSteel, 1), "##", "##", "##", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.sign, 1), "###", "###", " X ", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.stick);
        this.addRecipe(new ItemStack(Block.planks, 4), "#", Character.valueOf('#'), Block.wood);
        this.addRecipe(new ItemStack(Item.stick, 4), "#", "#", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Block.torch, 4), "X", "#", Character.valueOf('X'), Item.coal, Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Item.bowlEmpty, 4), "# #", " # ", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Block.minecartTrack, 16), "X X", "X#X", "X X", Character.valueOf('X'), Item.ingotIron, Character.valueOf('#'), Item.stick);
        this.addRecipe(new ItemStack(Item.minecartEmpty, 1), "# #", "###", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.minecartBox, 1), "A", "B", Character.valueOf('A'), Block.chest, Character.valueOf('B'), Item.minecartEmpty);
        this.addRecipe(new ItemStack(Item.minecartEngine, 1), "A", "B", Character.valueOf('A'), Block.stoneOvenIdle, Character.valueOf('B'), Item.minecartEmpty);
        this.addRecipe(new ItemStack(Item.boat, 1), "# #", "###", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Item.bucketEmpty, 1), "# #", " # ", Character.valueOf('#'), Item.ingotIron);
        this.addRecipe(new ItemStack(Item.striker, 1), "A ", " B", Character.valueOf('A'), Item.ingotIron, Character.valueOf('B'), Item.flint);
        this.addRecipe(new ItemStack(Item.bread, 1), "###", Character.valueOf('#'), Item.wheat);
        this.addRecipe(new ItemStack(Block.stairCompactWood, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Block.stairCompactStone, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.cobblestone);
        this.addRecipe(new ItemStack(Item.painting, 1), "###", "#X#", "###", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Block.cloth);
        this.addRecipe(new ItemStack(Item.appleGold, 1), "###", "#X#", "###", Character.valueOf('#'), Block.blockGold, Character.valueOf('X'), Item.appleRed);
        this.addRecipe(new ItemStack(Block.lever, 1), "X", "#", Character.valueOf('#'), Block.cobblestone, Character.valueOf('X'), Item.stick);
        this.addRecipe(new ItemStack(Block.torchRedstoneActive, 1), "X", "#", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.redstone);
        this.addRecipe(new ItemStack(Item.compass, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.redstone);
        this.addRecipe(new ItemStack(Block.button, 1), "#", "#", Character.valueOf('#'), Block.stone);
        this.addRecipe(new ItemStack(Block.pressurePlateStone, 1), "###", Character.valueOf('#'), Block.stone);
        this.addRecipe(new ItemStack(Block.pressurePlateWood, 1), "###", Character.valueOf('#'), Block.planks);
        this.addRecipe(new ItemStack(Block.PillarBlock, 4), "#X#", "X X", "#X#", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.stick);
        this.addRecipe(new ItemStack(Block.QuadWindowGlassBlock, 1), " # ", "#X#", " # ", Character.valueOf('#'), Block.cobblestone, Character.valueOf('X'), Block.glass);
        this.addRecipe(new ItemStack(Item.obsidianSword), "#", "#", "$", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianShovel), "#", "$", "$", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianPick), "###", " $ ", " $ ", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianHoe), "##", " $", " $", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianHoe), "##", "$ ", "$ ", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianAxe), "##", "#$", " $", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianAxe), "##", "$ ", "$ ", Character.valueOf('#'), Item.obsidianIngot, Character.valueOf('$'), Item.stick);
        this.addRecipe(new ItemStack(Item.obsidianArmor0), "###", "# #", Character.valueOf('#'), Item.obsidianIngot);
        this.addRecipe(new ItemStack(Item.obsidianArmor2), "###", "# #", "# #", Character.valueOf('#'), Item.obsidianIngot);
        this.addRecipe(new ItemStack(Item.obsidianArmor3), "# #", "# #", Character.valueOf('#'), Item.obsidianIngot);
        this.addRecipe(new ItemStack(Item.obsidianArmor1), "# #", "###", "###", Character.valueOf('#'), Item.obsidianIngot);
        this.addRecipe(new ItemStack(Block.woolPink), "#X", Character.valueOf('#'), Block.cloth, Character.valueOf('X'), Item.pinkDye);
        this.addRecipe(new ItemStack(Block.woolBlue), "#X", Character.valueOf('#'), Block.cloth, Character.valueOf('X'), Item.blueDye);
        this.addRecipe(new ItemStack(Block.woolGreen), "#X", Character.valueOf('#'), Block.cloth, Character.valueOf('X'), Item.greenDye);
        this.addRecipe(new ItemStack(Block.woolBlack), "#X", Character.valueOf('#'), Block.cloth, Character.valueOf('X'), Item.blackDye);
        this.addRecipe(new ItemStack(Item.edibleFire), "#", Character.valueOf('#'), Block.blueFireIdk);
        Collections.sort(this.recipes, new RecipeSorter(this));
        System.out.println(this.recipes.size() + " recipes");
    }

    void addRecipe(ItemStack var1, Object ... var2) {
        int var15;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (var2[var4] instanceof String[]) {
            String[] var7 = (String[])var2[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (var2[var4] instanceof String) {
                String var11 = (String)var2[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, Integer> var12 = new HashMap<Character, Integer>();
        while (var4 < var2.length) {
            Character var13 = (Character)var2[var4];
            var15 = 0;
            if (var2[var4 + 1] instanceof Item) {
                var15 = ((Item)var2[var4 + 1]).shiftedIndex;
            } else if (var2[var4 + 1] instanceof Block) {
                var15 = ((Block)var2[var4 + 1]).blockID;
            }
            var12.put(var13, var15);
            var4 += 2;
        }
        int[] var14 = new int[var5 * var6];
        for (var15 = 0; var15 < var5 * var6; ++var15) {
            char var10 = var3.charAt(var15);
            var14[var15] = var12.containsKey(Character.valueOf(var10)) ? (Integer)var12.get(Character.valueOf(var10)) : -1;
        }
        this.recipes.add(new CraftingRecipe(var5, var6, var14, var1));
    }

    public ItemStack findMatchingRecipe(int[] var1) {
        for (int var2 = 0; var2 < this.recipes.size(); ++var2) {
            CraftingRecipe var3 = (CraftingRecipe)this.recipes.get(var2);
            if (!var3.matches(var1)) continue;
            return var3.getCraftingResult(var1);
        }
        return null;
    }
}

