/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockStep
extends Block {
    private boolean blockType;

    public BlockStep(int id, boolean blockType) {
        super(id, 6, Material.rock);
        this.blockType = blockType;
        if (!blockType) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightOpacity(255);
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        return var1 <= 1 ? 6 : 5;
    }

    @Override
    public boolean isOpaqueCube() {
        return this.blockType;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (this == Block.stairSingle) {
            // empty if block
        }
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        int var5;
        if (this != Block.stairSingle) {
            super.onBlockAdded(var1, var2, var3, var4);
        }
        if ((var5 = var1.getBlockId(var2, var3 - 1, var4)) == BlockStep.stairSingle.blockID) {
            var1.setBlockWithNotify(var2, var3, var4, 0);
            var1.setBlockWithNotify(var2, var3 - 1, var4, Block.stairDouble.blockID);
        }
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.stairSingle.blockID;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return this.blockType;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (this != Block.stairSingle) {
            super.shouldSideBeRendered(var1, var2, var3, var4, var5);
        }
        return var5 == 1 ? true : (!super.shouldSideBeRendered(var1, var2, var3, var4, var5) ? false : (var5 == 0 ? true : var1.getBlockId(var2, var3, var4) != this.blockID));
    }
}

