/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.src.ChunkProviderClient;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.MCHashTable;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet59ComplexEntity;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.WorldBlockPositionType;

public class WorldClient
extends World {
    private LinkedList blocksToReceive = new LinkedList();
    private NetClientHandler sendQueue;
    private ChunkProviderClient clientChunkProvider;
    private boolean noTileEntityUpdates = false;
    private MCHashTable entityHashTable = new MCHashTable();
    private Set entityList = new HashSet();
    private Set entitySpawnQueue = new HashSet();

    public WorldClient(NetClientHandler netClientHandler) {
        super("MpServer");
        this.sendQueue = netClientHandler;
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
    }

    @Override
    public void tick() {
        int var2;
        ++this.worldTime;
        int var1 = this.calculateSkylightSubtracted(1.0f);
        if (var1 != this.skylightSubtracted) {
            this.skylightSubtracted = var1;
            var2 = 0;
            while (var2 < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(var2)).updateAllRenderers();
                ++var2;
            }
        }
        var2 = 0;
        while (var2 < 10 && !this.entitySpawnQueue.isEmpty()) {
            Entity var4 = (Entity)this.entitySpawnQueue.iterator().next();
            this.spawnEntityInWorld(var4);
            ++var2;
        }
        this.sendQueue.processReadPackets();
        var2 = 0;
        while (var2 < this.blocksToReceive.size()) {
            WorldBlockPositionType worldBlockPositionType4 = (WorldBlockPositionType)this.blocksToReceive.get(var2);
            if (--worldBlockPositionType4.acceptCountdown == 0) {
                super.setBlockAndMetadata(worldBlockPositionType4.posX, worldBlockPositionType4.posY, worldBlockPositionType4.posZ, worldBlockPositionType4.blockID, worldBlockPositionType4.metadata);
                super.markBlockNeedsUpdate(worldBlockPositionType4.posX, worldBlockPositionType4.posY, worldBlockPositionType4.posZ);
                this.blocksToReceive.remove(var2--);
            }
            ++var2;
        }
    }

    public void invalidateBlockReceiveRegion(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int var7 = 0;
        while (var7 < this.blocksToReceive.size()) {
            WorldBlockPositionType var8 = (WorldBlockPositionType)this.blocksToReceive.get(var7);
            if (var8.posX >= minX && var8.posY >= minY && var8.posZ >= minZ && var8.posX <= maxX && var8.posY <= maxY && var8.posZ <= maxZ) {
                this.blocksToReceive.remove(var7--);
            }
            ++var7;
        }
    }

    @Override
    protected IChunkProvider getChunkProvider(File var1) {
        this.clientChunkProvider = new ChunkProviderClient(this);
        return this.clientChunkProvider;
    }

    @Override
    public void setSpawnLocation() {
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int var1, int var2, int var3, int var4) {
    }

    @Override
    public boolean tickUpdates(boolean var1) {
        return false;
    }

    public void doPreChunk(int x, int z, boolean mode) {
        if (mode) {
            this.clientChunkProvider.loadChunk(x, z);
        } else {
            this.clientChunkProvider.unloadChunk(x, z);
        }
        if (!mode) {
            this.markBlocksDirty(x * 16, 0, z * 16, x * 16 + 15, 128, z * 16 + 15);
        }
    }

    @Override
    public boolean spawnEntityInWorld(Entity var1) {
        boolean var2 = super.spawnEntityInWorld(var1);
        if (var1 instanceof EntityPlayerSP) {
            this.entityList.add(var1);
        }
        return var2;
    }

    @Override
    public void setEntityDead(Entity var1) {
        super.setEntityDead(var1);
        if (var1 instanceof EntityPlayerSP) {
            this.entityList.remove(var1);
        }
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (this.entitySpawnQueue.contains(entity)) {
            this.entitySpawnQueue.remove(entity);
        }
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.entityList.contains(entity)) {
            this.entitySpawnQueue.add(entity);
        }
    }

    public void addEntityToWorld(int id, Entity entity) {
        this.entityList.add(entity);
        if (!this.spawnEntityInWorld(entity)) {
            this.entitySpawnQueue.add(entity);
        }
        this.entityHashTable.addKey(id, entity);
    }

    public Entity getEntityByID(int id) {
        return (Entity)this.entityHashTable.lookup(id);
    }

    public Entity removeEntityFromWorld(int id) {
        Entity var2 = (Entity)this.entityHashTable.removeObject(id);
        if (var2 != null) {
            this.entityList.remove(var2);
            this.setEntityDead(var2);
        }
        return var2;
    }

    @Override
    public boolean setBlockMetadata(int x, int y, int z, int metadata) {
        int var5 = this.getBlockId(x, y, z);
        int var6 = this.getBlockMetadata(x, y, z);
        if (super.setBlockMetadata(x, y, z, metadata)) {
            this.blocksToReceive.add(new WorldBlockPositionType(this, x, y, z, var5, var6));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int x, int y, int z, int id, int metadata) {
        int var6 = this.getBlockId(x, y, z);
        int var7 = this.getBlockMetadata(x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, metadata)) {
            this.blocksToReceive.add(new WorldBlockPositionType(this, x, y, z, var6, var7));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int id) {
        int var5 = this.getBlockId(x, y, z);
        int var6 = this.getBlockMetadata(x, y, z);
        if (super.setBlock(x, y, z, id)) {
            this.blocksToReceive.add(new WorldBlockPositionType(this, x, y, z, var5, var6));
            return true;
        }
        return false;
    }

    public boolean handleBlockChange(int x, int y, int z, int id, int metadata) {
        this.invalidateBlockReceiveRegion(x, y, z, x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, metadata)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public void updateTileEntityChunkAndDoNothing(int var1, int var2, int var3, TileEntity var4) {
        if (!this.noTileEntityUpdates) {
            this.sendQueue.addToSendQueue(new Packet59ComplexEntity(var1, var2, var3, var4));
        }
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.addToSendQueue(new Packet255KickDisconnect("Quitting"));
    }
}

