/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Render;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private RenderBlocks itemRenderBlocks = new RenderBlocks();
    private Random random = new Random();

    public RenderItem() {
        this.shadowSize = 0.15f;
        this.shadowOpaque = 0.75f;
    }

    public void doRender(EntityItem var1, double var2, double var4, double var6, float var8, float var9) {
        this.random.setSeed(187L);
        ItemStack var10 = var1.item;
        GL11.glPushMatrix();
        float var11 = MathHelper.sin(((float)var1.age + var9) / 10.0f + var1.hoverStart) * 0.1f + 0.1f;
        float var12 = (((float)var1.age + var9) / 20.0f + var1.hoverStart) * 57.295776f;
        int var13 = 1;
        if (var1.item.stackSize > 1) {
            var13 = 2;
        }
        if (var1.item.stackSize > 5) {
            var13 = 3;
        }
        if (var1.item.stackSize > 20) {
            var13 = 4;
        }
        GL11.glTranslatef((float)var2, (float)var4 + var11, (float)var6);
        GL11.glEnable(32826);
        if (var10.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var10.itemID].getRenderType())) {
            GL11.glRotatef(var12, 0.0f, 1.0f, 0.0f);
            this.loadTexture("/terrain.png");
            float f27 = 0.25f;
            if (!Block.blocksList[var10.itemID].renderAsNormalBlock() && var10.itemID != Block.stairSingle.blockID) {
                f27 = 0.5f;
            }
            GL11.glScalef(f27, f27, f27);
            int i28 = 0;
            while (i28 < var13) {
                GL11.glPushMatrix();
                if (i28 > 0) {
                    float var16 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f27;
                    float var17 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f27;
                    float var18 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f27;
                    GL11.glTranslatef(var16, var17, var18);
                }
                this.itemRenderBlocks.renderBlockOnInventory(Block.blocksList[var10.itemID]);
                GL11.glPopMatrix();
                ++i28;
            }
        } else {
            GL11.glScalef(0.5f, 0.5f, 0.5f);
            int var14 = var10.getIconIndex();
            if (var10.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator var15 = Tessellator.instance;
            float var16 = (float)(var14 % 16 * 16 + 0) / 256.0f;
            float var17 = (float)(var14 % 16 * 16 + 16) / 256.0f;
            float var18 = (float)(var14 / 16 * 16 + 0) / 256.0f;
            float var19 = (float)(var14 / 16 * 16 + 16) / 256.0f;
            float var20 = 1.0f;
            float var21 = 0.5f;
            float var22 = 0.25f;
            int var23 = 0;
            while (var23 < var13) {
                GL11.glPushMatrix();
                if (var23 > 0) {
                    float var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef(var24, var25, var26);
                }
                GL11.glRotatef(180.0f - this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
                var15.startDrawingQuads();
                var15.setNormal(0.0f, 1.0f, 0.0f);
                var15.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, var16, var19);
                var15.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, var17, var19);
                var15.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, var17, var18);
                var15.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, var16, var18);
                var15.draw();
                GL11.glPopMatrix();
                ++var23;
            }
        }
        GL11.glDisable(32826);
        GL11.glPopMatrix();
    }

    public void renderItemIntoGUI(FontRenderer var1, RenderEngine var2, ItemStack var3, int var4, int var5) {
        if (var3 != null) {
            if (var3.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var3.itemID].getRenderType())) {
                int var6 = var3.itemID;
                var2.bindTexture(var2.getTexture("/terrain.png"));
                Block var7 = Block.blocksList[var6];
                GL11.glPushMatrix();
                GL11.glTranslatef(var4 - 2, var5 + 3, 0.0f);
                GL11.glScalef(10.0f, 10.0f, 10.0f);
                GL11.glTranslatef(1.0f, 0.5f, 8.0f);
                GL11.glRotatef(210.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glScalef(1.0f, 1.0f, 1.0f);
                this.itemRenderBlocks.renderBlockOnInventory(var7);
                GL11.glPopMatrix();
            } else if (var3.getIconIndex() >= 0) {
                GL11.glDisable(2896);
                if (var3.itemID < 256) {
                    var2.bindTexture(var2.getTexture("/terrain.png"));
                } else {
                    var2.bindTexture(var2.getTexture("/gui/items.png"));
                }
                this.renderIcon(var4, var5, var3.getIconIndex() % 16 * 16, var3.getIconIndex() / 16 * 16, 16, 16);
                GL11.glEnable(2896);
            }
            GL11.glEnable(2884);
        }
    }

    public void renderItemOverlayIntoGUI(FontRenderer var1, RenderEngine var2, ItemStack var3, int var4, int var5) {
        if (var3 != null) {
            if (var3.stackSize > 1) {
                String var11 = "" + var3.stackSize;
                GL11.glDisable(2896);
                GL11.glDisable(2929);
                var1.drawStringWithShadow(var11, var4 + 19 - 2 - var1.getStringWidth(var11), var5 + 6 + 3, 0xFFFFFF);
                GL11.glEnable(2896);
                GL11.glEnable(2929);
            }
            if (var3.itemDmg > 0) {
                int var111 = 13 - var3.itemDmg * 13 / var3.getMaxDamage();
                int var7 = 255 - var3.itemDmg * 255 / var3.getMaxDamage();
                GL11.glDisable(2896);
                GL11.glDisable(2929);
                GL11.glDisable(3553);
                Tessellator var8 = Tessellator.instance;
                int var9 = 255 - var7 << 16 | var7 << 8;
                int var10 = (255 - var7) / 4 << 16 | 0x3F00;
                this.renderQuad(var8, var4 + 2, var5 + 13, 13, 2, 0);
                this.renderQuad(var8, var4 + 2, var5 + 13, 12, 1, var10);
                this.renderQuad(var8, var4 + 2, var5 + 13, var111, 1, var9);
                GL11.glEnable(3553);
                GL11.glEnable(2896);
                GL11.glEnable(2929);
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    private void renderQuad(Tessellator var1, int var2, int var3, int var4, int var5, int var6) {
        var1.startDrawingQuads();
        var1.setColorOpaque_I(var6);
        var1.addVertex(var2 + 0, var3 + 0, 0.0);
        var1.addVertex(var2 + 0, var3 + var5, 0.0);
        var1.addVertex(var2 + var4, var3 + var5, 0.0);
        var1.addVertex(var2 + var4, var3 + 0, 0.0);
        var1.draw();
    }

    public void renderIcon(int var1, int var2, int var3, int var4, int var5, int var6) {
        float var7 = 0.0f;
        float var8 = 0.00390625f;
        float var9 = 0.00390625f;
        Tessellator var10 = Tessellator.instance;
        var10.startDrawingQuads();
        var10.addVertexWithUV(var1 + 0, var2 + var6, var7, (float)(var3 + 0) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + var6, var7, (float)(var3 + var5) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + 0, var7, (float)(var3 + var5) * var8, (float)(var4 + 0) * var9);
        var10.addVertexWithUV(var1 + 0, var2 + 0, var7, (float)(var3 + 0) * var8, (float)(var4 + 0) * var9);
        var10.draw();
    }

    @Override
    public void doRender(Entity entity1, double d2, double d4, double d6, float f8, float f9) {
        this.doRender((EntityItem)entity1, d2, d4, d6, f8, f9);
    }
}

