/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.IMobs;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PlayerController;
import net.minecraft.src.SpawnerAnimals;
import net.minecraft.src.SpawnerMonsters;
import net.minecraft.src.World;

public class PlayerControllerSP
extends PlayerController {
    private int curBlockX = -1;
    private int curBlockY = -1;
    private int curBlockZ = -1;
    private float curBlockDamage = 0.0f;
    private float prevBlockDamage = 0.0f;
    private float blockDestroySoundCounter = 0.0f;
    private int blockHitWait = 0;
    private SpawnerAnimals monsterSpawner = new SpawnerMonsters(this, 200, IMobs.class, new Class[]{EntityZombie.class, EntitySkeleton.class, EntityCreeper.class, EntitySpider.class, EntitySlime.class});
    private SpawnerAnimals animalSpawner = new SpawnerAnimals(15, EntityAnimal.class, new Class[]{EntitySheep.class, EntityPig.class, EntityCow.class, EntityChicken.class});

    public PlayerControllerSP(Minecraft var1) {
        super(var1);
    }

    @Override
    public void flipPlayer(EntityPlayer var1) {
        var1.rotationYaw = -180.0f;
    }

    @Override
    public boolean sendBlockRemoved(int x, int y, int z, int side) {
        int var5 = this.mc.theWorld.getBlockId(x, y, z);
        int var6 = this.mc.theWorld.getBlockMetadata(x, y, z);
        boolean var7 = super.sendBlockRemoved(x, y, z, side);
        ItemStack var8 = this.mc.thePlayer.getCurrentEquippedItem();
        boolean var9 = this.mc.thePlayer.canHarvestBlock(Block.blocksList[var5]);
        if (var8 != null) {
            var8.onDestroyBlock(var5, x, y, z);
            if (var8.stackSize == 0) {
                var8.onItemDestroyedByUse(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        if (var7 && var9) {
            Block.blocksList[var5].harvestBlock(this.mc.theWorld, x, y, z, var6);
        }
        return var7;
    }

    @Override
    public void clickBlock(int var1, int var2, int var3, int var4) {
        int var5 = this.mc.theWorld.getBlockId(var1, var2, var3);
        if (var5 > 0 && this.curBlockDamage == 0.0f) {
            Block.blocksList[var5].onBlockClicked(this.mc.theWorld, var1, var2, var3, this.mc.thePlayer);
        }
        if (var5 > 0 && Block.blocksList[var5].blockStrength(this.mc.thePlayer) >= 1.0f) {
            this.sendBlockRemoved(var1, var2, var3, var4);
        }
    }

    @Override
    public void resetBlockRemoving() {
        this.curBlockDamage = 0.0f;
        this.blockHitWait = 0;
    }

    @Override
    public void sendBlockRemoving(int var1, int var2, int var3, int var4) {
        if (this.blockHitWait > 0) {
            --this.blockHitWait;
        } else if (var1 == this.curBlockX && var2 == this.curBlockY && var3 == this.curBlockZ) {
            int var5 = this.mc.theWorld.getBlockId(var1, var2, var3);
            if (var5 == 0) {
                return;
            }
            Block var6 = Block.blocksList[var5];
            this.curBlockDamage += var6.blockStrength(this.mc.thePlayer);
            if (this.blockDestroySoundCounter % 4.0f == 0.0f && var6 != null) {
                this.mc.sndManager.playSound(var6.stepSound.getStepSound(), (float)var1 + 0.5f, (float)var2 + 0.5f, (float)var3 + 0.5f, (var6.stepSound.getVolume() + 1.0f) / 8.0f, var6.stepSound.getPitch() * 0.5f);
            }
            this.blockDestroySoundCounter += 1.0f;
            if (this.curBlockDamage >= 1.0f) {
                this.sendBlockRemoved(var1, var2, var3, var4);
                this.curBlockDamage = 0.0f;
                this.prevBlockDamage = 0.0f;
                this.blockDestroySoundCounter = 0.0f;
                this.blockHitWait = 5;
            }
        } else {
            this.curBlockDamage = 0.0f;
            this.prevBlockDamage = 0.0f;
            this.blockDestroySoundCounter = 0.0f;
            this.curBlockX = var1;
            this.curBlockY = var2;
            this.curBlockZ = var3;
        }
    }

    @Override
    public void setPartialTime(float var1) {
        if (this.curBlockDamage <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float var2;
            this.mc.ingameGUI.damageGuiPartialTime = var2 = this.prevBlockDamage + (this.curBlockDamage - this.prevBlockDamage) * var1;
            this.mc.renderGlobal.damagePartialTime = var2;
        }
    }

    @Override
    public float getBlockReachDistance() {
        return 4.0f;
    }

    @Override
    public void onWorldChange(World world) {
        super.onWorldChange(world);
    }

    @Override
    public void onUpdate() {
        this.prevBlockDamage = this.curBlockDamage;
        this.monsterSpawner.onUpdate(this.mc.theWorld);
        this.animalSpawner.onUpdate(this.mc.theWorld);
        this.mc.sndManager.playRandomMusicIfReady();
    }
}

