/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.EntityItem;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet21PickupSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public byte roll;
    public int itemID;
    public int count;

    public Packet21PickupSpawn() {
    }

    public Packet21PickupSpawn(EntityItem entityItem) {
        this.entityId = entityItem.entityID;
        this.itemID = entityItem.item.itemID;
        this.count = entityItem.item.stackSize;
        this.xPosition = MathHelper.floor_double(entityItem.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entityItem.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entityItem.posZ * 32.0);
        this.rotation = (byte)(entityItem.motionX * 128.0);
        this.pitch = (byte)(entityItem.motionY * 128.0);
        this.roll = (byte)(entityItem.motionZ * 128.0);
    }

    @Override
    public void readPacketData(DataInputStream var1) throws IOException {
        this.entityId = var1.readInt();
        this.itemID = var1.readShort();
        this.count = var1.readByte();
        this.xPosition = var1.readInt();
        this.yPosition = var1.readInt();
        this.zPosition = var1.readInt();
        this.rotation = var1.readByte();
        this.pitch = var1.readByte();
        this.roll = var1.readByte();
    }

    @Override
    public void writePacket(DataOutputStream var1) throws IOException {
        var1.writeInt(this.entityId);
        var1.writeShort(this.itemID);
        var1.writeByte(this.count);
        var1.writeInt(this.xPosition);
        var1.writeInt(this.yPosition);
        var1.writeInt(this.zPosition);
        var1.writeByte(this.rotation);
        var1.writeByte(this.pitch);
        var1.writeByte(this.roll);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePickupSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 22;
    }
}

