/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MinecraftError;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class LoadingScreenRenderer
implements IProgressUpdate {
    private String currentlyDisplayedProgress = "";
    private Minecraft mc;
    private String currentlyDisplayedText = "";
    private long systemTime = System.currentTimeMillis();
    private boolean noError = false;

    public LoadingScreenRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void resetProgressAndMessage(String msg) {
        this.noError = false;
        this.drawScreen(msg);
    }

    @Override
    public void displayProgressMessage(String msg) {
        this.noError = true;
        this.drawScreen(this.currentlyDisplayedText);
    }

    public void drawScreen(String msg) {
        if (!this.mc.running) {
            if (!this.noError) {
                throw new MinecraftError();
            }
        } else {
            this.currentlyDisplayedText = msg;
            ScaledResolution var2 = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight);
            int var3 = var2.getScaledWidth();
            int var4 = var2.getScaledHeight();
            GL11.glClear(256);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glOrtho(0.0, var3, var4, 0.0, 100.0, 300.0);
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef(0.0f, 0.0f, -200.0f);
        }
    }

    @Override
    public void displayLoadingString(String string) {
        if (!this.mc.running) {
            if (!this.noError) {
                throw new MinecraftError();
            }
        } else {
            this.systemTime = 0L;
            this.currentlyDisplayedProgress = string;
            this.setLoadingProgress(-1);
            this.systemTime = 0L;
        }
    }

    @Override
    public void setLoadingProgress(int var1) {
        if (!this.mc.running) {
            if (!this.noError) {
                throw new MinecraftError();
            }
        } else {
            long var2 = System.currentTimeMillis();
            if (var2 - this.systemTime >= 20L) {
                this.systemTime = var2;
                ScaledResolution var4 = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight);
                int var5 = var4.getScaledWidth();
                int var6 = var4.getScaledHeight();
                GL11.glClear(256);
                GL11.glMatrixMode(5889);
                GL11.glLoadIdentity();
                GL11.glOrtho(0.0, var5, var6, 0.0, 100.0, 300.0);
                GL11.glMatrixMode(5888);
                GL11.glLoadIdentity();
                GL11.glTranslatef(0.0f, 0.0f, -200.0f);
                GL11.glClear(16640);
                Tessellator var7 = Tessellator.instance;
                int var8 = this.mc.renderEngine.getTexture("/dirt.png");
                GL11.glBindTexture(3553, var8);
                float var9 = 32.0f;
                var7.startDrawingQuads();
                var7.setColorOpaque_I(0x404040);
                var7.addVertexWithUV(0.0, var6, 0.0, 0.0, (float)var6 / var9);
                var7.addVertexWithUV(var5, var6, 0.0, (float)var5 / var9, (float)var6 / var9);
                var7.addVertexWithUV(var5, 0.0, 0.0, (float)var5 / var9, 0.0);
                var7.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
                var7.draw();
                if (var1 >= 0) {
                    int var10 = 100;
                    int var11 = 2;
                    int var12 = var5 / 2 - var10 / 2;
                    int var13 = var6 / 2 + 16;
                    GL11.glDisable(3553);
                    var7.startDrawingQuads();
                    var7.setColorOpaque_I(0x808080);
                    var7.addVertex(var12, var13, 0.0);
                    var7.addVertex(var12, var13 + var11, 0.0);
                    var7.addVertex(var12 + var10, var13 + var11, 0.0);
                    var7.addVertex(var12 + var10, var13, 0.0);
                    var7.setColorOpaque_I(0x80FF80);
                    var7.addVertex(var12, var13, 0.0);
                    var7.addVertex(var12, var13 + var11, 0.0);
                    var7.addVertex(var12 + var1, var13 + var11, 0.0);
                    var7.addVertex(var12 + var1, var13, 0.0);
                    var7.draw();
                    GL11.glEnable(3553);
                }
                this.mc.fontRenderer.drawStringWithShadow(this.currentlyDisplayedText, (var5 - this.mc.fontRenderer.getStringWidth(this.currentlyDisplayedText)) / 2, var6 / 2 - 4 - 16, 0xFFFFFF);
                this.mc.fontRenderer.drawStringWithShadow(this.currentlyDisplayedProgress, (var5 - this.mc.fontRenderer.getStringWidth(this.currentlyDisplayedProgress)) / 2, var6 / 2 - 4 + 8, 0xFFFFFF);
                Display.update();
                try {
                    Thread.yield();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

