/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class ItemTool
extends Item {
    private Block[] blocksEffectiveAgainst;
    private float efficiencyOnProperMaterial = 4.0f;
    private int damageVsEntity;
    protected int toolMaterial;

    public ItemTool(int id, int attackDmg, int strength, Block[] blocks) {
        super(id);
        this.toolMaterial = strength;
        this.blocksEffectiveAgainst = blocks;
        this.maxStackSize = 1;
        this.maxDamage = 32 << strength;
        if (strength == 3) {
            this.maxDamage *= 4;
        }
        this.efficiencyOnProperMaterial = (strength + 1) * 2;
        this.damageVsEntity = attackDmg + strength;
    }

    @Override
    public float getStrVsBlock(ItemStack var1, Block var2) {
        int var3 = 0;
        while (var3 < this.blocksEffectiveAgainst.length) {
            if (this.blocksEffectiveAgainst[var3] == var2) {
                return this.efficiencyOnProperMaterial;
            }
            ++var3;
        }
        return 1.0f;
    }

    @Override
    public void hitEntity(ItemStack var1, EntityLiving var2) {
        var1.damageItem(2);
    }

    @Override
    public void onBlockDestroyed(ItemStack var1, int var2, int var3, int var4, int var5) {
        var1.damageItem(1);
    }

    @Override
    public int getDamageVsEntity(Entity var1) {
        return this.damageVsEntity;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }
}

