/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Chunk;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IMobs;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySlime
extends EntityLiving
implements IMobs {
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay = 0;
    public int size = 1;

    public EntitySlime(World var1) {
        super(var1);
        this.texture = "/mob/slime.png";
        this.size = 1 << this.rand.nextInt(3);
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(20) + 10;
        this.setSlimeSize(this.size);
    }

    public void setSlimeSize(int var1) {
        this.size = var1;
        this.setSize(0.6f * (float)var1, 0.6f * (float)var1);
        this.health = var1 * var1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setInteger("Size", this.size - 1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.size = var1.getInteger("Size") + 1;
    }

    @Override
    public void onUpdate() {
        this.prevSquishFactor = this.squishFactor;
        boolean var1 = this.onGround;
        super.onUpdate();
        if (this.onGround && !var1) {
            int var2 = 0;
            while (var2 < this.size * 8) {
                float var3 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float var4 = this.rand.nextFloat() * 0.5f + 0.5f;
                float var5 = MathHelper.sin(var3) * (float)this.size * 0.5f * var4;
                float var6 = MathHelper.cos(var3) * (float)this.size * 0.5f * var4;
                this.worldObj.spawnParticle("slime", this.posX + (double)var5, this.boundingBox.minY, this.posZ + (double)var6, 0.0, 0.0, 0.0);
                ++var2;
            }
            if (this.size > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishFactor = -0.5f;
        }
        this.squishFactor *= 0.6f;
    }

    @Override
    protected void updateEntityActionState() {
        EntityPlayer var1 = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (var1 != null) {
            this.faceEntity(var1, 10.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.rand.nextInt(20) + 10;
            if (var1 != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.size > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.squishFactor = 1.0f;
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = 1 * this.size;
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    @Override
    public void setEntityDead() {
        if (this.size > 1 && this.health == 0) {
            int var1 = 0;
            while (var1 < 4) {
                float var2 = ((float)(var1 % 2) - 0.5f) * (float)this.size / 4.0f;
                float var3 = ((float)(var1 / 2) - 0.5f) * (float)this.size / 4.0f;
                EntitySlime var4 = new EntitySlime(this.worldObj);
                var4.setSlimeSize(this.size / 2);
                var4.setLocationAndAngles(this.posX + (double)var2, this.posY + 0.5, this.posZ + (double)var3, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.spawnEntityInWorld(var4);
                ++var1;
            }
        }
        super.setEntityDead();
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer var1) {
        if (this.size > 1 && this.canEntityBeSeen(var1) && (double)this.getDistanceToEntity(var1) < 0.6 * (double)this.size && var1.attackEntityFrom(this, this.size)) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.slime";
    }

    @Override
    protected String getDeathSound() {
        return "mob.slime";
    }

    @Override
    protected int getDropItemId() {
        return this.size == 1 ? Item.slimeBall.shiftedIndex : 0;
    }

    @Override
    public boolean getCanSpawnHere() {
        Chunk var1 = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY));
        return (this.size == 1 || this.worldObj.difficultySetting > 0) && this.rand.nextInt(10) == 0 && var1.getRandomWithSeed(987234911L).nextInt(30) == 0 && this.posY < 16.0;
    }

    @Override
    protected float getSoundVolume() {
        return 0.6f;
    }
}

