/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ClippingHelperImplementation;
import net.minecraft.src.ColorUtil;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityRainFX;
import net.minecraft.src.Frustum;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.PlayerControllerCreative;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    private Minecraft mc;
    private float fl_i = 0.0f;
    public ItemRenderer itemRenderer;
    private int int_j;
    private Entity pointedEntity = null;
    private long prevFrameTime = System.currentTimeMillis();
    private Random random = new Random();
    volatile int unusedInt1 = 0;
    volatile int unusedInt2 = 0;
    FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float prevFogColor;
    private float fogColor;

    public EntityRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemRenderer = new ItemRenderer(minecraft);
    }

    public void updateRenderer() {
        this.prevFogColor = this.fogColor;
        float var1 = this.mc.theWorld.getBrightness(MathHelper.floor_double(this.mc.thePlayer.posX), MathHelper.floor_double(this.mc.thePlayer.posY), MathHelper.floor_double(this.mc.thePlayer.posZ));
        float var2 = (float)(3 - this.mc.options.renderDistance) / 3.0f;
        this.fogColor += (var1 * (1.0f - var2) + var2 - this.fogColor) * 0.1f;
        ++this.int_j;
        this.itemRenderer.updateEquippedItem();
        if (this.mc.isRaining) {
            this.addRainParticles();
        }
    }

    public void getMouseOver(float renderPartialTick) {
        if (this.mc.thePlayer != null) {
            double var7;
            double var2 = this.mc.playerController.getBlockReachDistance();
            this.mc.objectMouseOver = this.mc.thePlayer.rayTrace(var2, renderPartialTick);
            double var4 = var2;
            Vec3D var6 = this.mc.thePlayer.getPosition(renderPartialTick);
            if (this.mc.objectMouseOver != null) {
                var4 = this.mc.objectMouseOver.hitVec.distanceTo(var6);
            }
            if (this.mc.playerController instanceof PlayerControllerCreative) {
                var7 = 32.0;
            } else {
                if (var4 > 3.0) {
                    var4 = 3.0;
                }
                var7 = var4;
            }
            Vec3D var9 = this.mc.thePlayer.getLook(renderPartialTick);
            Vec3D var10 = var6.addVector(var9.xCoord * var7, var9.yCoord * var7, var9.zCoord * var7);
            this.pointedEntity = null;
            List var11 = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, this.mc.thePlayer.boundingBox.addCoord(var9.xCoord * var7, var9.yCoord * var7, var9.zCoord * var7));
            double var12 = 0.0;
            int var14 = 0;
            while (var14 < var11.size()) {
                double var18;
                MovingObjectPosition var17;
                Entity var15 = (Entity)var11.get(var14);
                if (var15.canBeCollidedWith() && (var17 = var15.boundingBox.expand(0.1f, 0.1f, 0.1f).calculateIntercept(var6, var10)) != null && ((var18 = var6.distanceTo(var17.hitVec)) < var12 || var12 == 0.0)) {
                    this.pointedEntity = var15;
                    var12 = var18;
                }
                ++var14;
            }
            if (this.pointedEntity != null && !(this.mc.playerController instanceof PlayerControllerCreative)) {
                this.mc.objectMouseOver = new MovingObjectPosition(this.pointedEntity);
            }
        }
    }

    private float getFOVModifier(float renderPartialTick) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        float var3 = 70.0f;
        if (var2.isInsideOfMaterial(Material.water)) {
            var3 = 60.0f;
        }
        if (var2.health <= 0) {
            var3 /= (1.0f - 500.0f / ((float)var2.deathTime + renderPartialTick + 500.0f)) * 2.0f + 1.0f;
        }
        return var3;
    }

    private void hurtCameraEffect(float renderPartialTick) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        float var3 = (float)var2.hurtTime - renderPartialTick;
        if (var2.health <= 0) {
            GL11.glRotatef(40.0f - 8000.0f / ((float)var2.deathTime + renderPartialTick + 200.0f), 0.0f, 0.0f, 1.0f);
        }
        if (var3 >= 0.0f) {
            float var4 = var3 / (float)var2.maxHurtTime;
            float var5 = MathHelper.sin(var4 * var4 * var4 * var4 * (float)Math.PI);
            float var6 = var2.attackedAtYaw;
            GL11.glRotatef(-var6, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-var5 * 14.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(var6, 0.0f, 1.0f, 0.0f);
        }
    }

    private void setupViewBobbing(float renderPartialTick) {
        if (!this.mc.options.thirdPersonView) {
            EntityPlayerSP var2 = this.mc.thePlayer;
            float var3 = var2.distanceWalkedModified + (var2.distanceWalkedModified - var2.prevDistanceWalkedModified) * renderPartialTick;
            float var4 = var2.prevCameraYaw + (var2.cameraYaw - var2.prevCameraYaw) * renderPartialTick;
            float var5 = var2.prevCameraPitch + (var2.cameraPitch - var2.prevCameraPitch) * renderPartialTick;
            GL11.glTranslatef(MathHelper.sin(var3 * (float)Math.PI) * var4 * 0.5f, -Math.abs(MathHelper.cos(var3 * (float)Math.PI) * var4), 0.0f);
            GL11.glRotatef(MathHelper.sin(var3 * (float)Math.PI) * var4 * 3.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(Math.abs(MathHelper.cos(var3 * (float)Math.PI + 0.2f) * var4) * 5.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(var5, 1.0f, 0.0f, 0.0f);
        }
    }

    private void orientCamera(float renderPartialTick) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        double var3 = var2.prevPosX + (var2.posX - var2.prevPosX) * (double)renderPartialTick;
        double var5 = var2.prevPosY + (var2.posY - var2.prevPosY) * (double)renderPartialTick;
        double var7 = var2.prevPosZ + (var2.posZ - var2.prevPosZ) * (double)renderPartialTick;
        if (this.mc.options.thirdPersonView) {
            double var9 = 4.0;
            float var11 = var2.rotationYaw - 10.0f;
            float var12 = var2.rotationPitch + 2.0f;
            double var13 = (double)(-MathHelper.sin(var11 / 180.0f * (float)Math.PI) * MathHelper.cos(var12 / 180.0f * (float)Math.PI)) * var9;
            double var15 = (double)(MathHelper.cos(var11 / 180.0f * (float)Math.PI) * MathHelper.cos(var12 / 180.0f * (float)Math.PI)) * var9;
            double var17 = (double)(-MathHelper.sin(var12 / 180.0f * (float)Math.PI)) * var9;
            int var19 = 0;
            while (var19 < 8) {
                double var27;
                float var20 = (var19 & 1) * 2 - 1;
                float var23 = var20 * 0.1f;
                float var21 = (var19 >> 1 & 1) * 2 - 1;
                float var24 = var21 * 0.1f;
                float var22 = (var19 >> 2 & 1) * 2 - 1;
                float var25 = var22 * 0.1f;
                MovingObjectPosition var26 = this.mc.theWorld.rayTraceBlocks(Vec3D.createVector(var3 + (double)var23, var5 + (double)var24, var7 + (double)var25), Vec3D.createVector(var3 - var13 + (double)var23 + (double)var25, var5 - var17 + (double)var24, var7 - var15 + (double)var25));
                if (var26 != null && (var27 = var26.hitVec.distanceTo(Vec3D.createVector(var3, var5, var7))) < var9) {
                    var9 = var27;
                }
                ++var19;
            }
            GL11.glRotatef(var2.rotationPitch - var12, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(var2.rotationYaw - var11, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, 0.0f, (float)(-var9));
            GL11.glRotatef(var11 - var2.rotationYaw, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(var12 - var2.rotationPitch, 1.0f, 0.0f, 0.0f);
        } else {
            GL11.glTranslatef(0.0f, 0.0f, -0.1f);
        }
        GL11.glRotatef(var2.prevRotationPitch + (var2.rotationPitch - var2.prevRotationPitch) * renderPartialTick, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(var2.prevRotationYaw + (var2.rotationYaw - var2.prevRotationYaw) * renderPartialTick + 180.0f, 0.0f, 1.0f, 0.0f);
    }

    private void setupCameraTransform(float renderPartialTick, int var2) {
        this.fl_i = 256 >> this.mc.options.renderDistance;
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)(-(var2 * 2 - 1)) * 0.07f, 0.0f, 0.0f);
        }
        GLU.gluPerspective(this.getFOVModifier(renderPartialTick), (float)this.mc.displayWidth / (float)this.mc.displayHeight, 0.05f, this.fl_i);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)(var2 * 2 - 1) * 0.1f, 0.0f, 0.0f);
        }
        this.hurtCameraEffect(renderPartialTick);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(renderPartialTick);
        }
        this.orientCamera(renderPartialTick);
    }

    private void renderHand(float renderPartialTick, int var2) {
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)(var2 * 2 - 1) * 0.1f, 0.0f, 0.0f);
        }
        GL11.glPushMatrix();
        this.hurtCameraEffect(renderPartialTick);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(renderPartialTick);
        }
        if (!this.mc.options.thirdPersonView) {
            this.itemRenderer.renderItemInFirstPerson(renderPartialTick);
        }
        GL11.glPopMatrix();
        if (!this.mc.options.thirdPersonView) {
            this.itemRenderer.renderOverlays(renderPartialTick);
            this.hurtCameraEffect(renderPartialTick);
        }
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(renderPartialTick);
        }
    }

    public void updateCameraAndRender(float renderPartialTick) {
        int var3;
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.prevFrameTime > 500L) {
                this.mc.displayInGameMenu();
            }
        } else {
            this.prevFrameTime = System.currentTimeMillis();
        }
        if (this.mc.inGameHasFocus) {
            this.mc.mouseHelper.mouseXYChange();
            int var7 = this.mc.mouseHelper.deltaX;
            var3 = this.mc.mouseHelper.deltaY;
            int var8 = 1;
            if (this.mc.options.invertMouse) {
                var8 = -1;
            }
            this.mc.thePlayer.setAngles(var7, var3 * var8);
        }
        if (!this.mc.skipRenderWorld) {
            ScaledResolution var71 = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight);
            var3 = var71.getScaledWidth();
            int var81 = var71.getScaledHeight();
            int var5 = Mouse.getX() * var3 / this.mc.displayWidth;
            int var6 = var81 - Mouse.getY() * var81 / this.mc.displayHeight - 1;
            if (this.mc.theWorld != null) {
                this.renderWorld(renderPartialTick);
                this.mc.ingameGUI.renderGameOverlay(renderPartialTick, this.mc.currentScreen != null, var5, var6);
            } else {
                GL11.glViewport(0, 0, this.mc.displayWidth, this.mc.displayHeight);
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                GL11.glClear(16640);
                GL11.glMatrixMode(5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode(5888);
                GL11.glLoadIdentity();
                this.setupOverlayRendering();
            }
            if (this.mc.currentScreen != null) {
                GL11.glClear(256);
                this.mc.currentScreen.drawScreen(var5, var6, renderPartialTick);
            }
        }
    }

    public void renderWorld(float renderPartialTick) {
        this.getMouseOver(renderPartialTick);
        EntityPlayerSP var2 = this.mc.thePlayer;
        RenderGlobal var3 = this.mc.renderGlobal;
        EffectRenderer var4 = this.mc.effectRenderer;
        double var5 = var2.lastTickPosX + (var2.posX - var2.lastTickPosX) * (double)renderPartialTick;
        double var7 = var2.lastTickPosY + (var2.posY - var2.lastTickPosY) * (double)renderPartialTick;
        double var9 = var2.lastTickPosZ + (var2.posZ - var2.lastTickPosZ) * (double)renderPartialTick;
        int var11 = 0;
        while (var11 < 2) {
            if (this.mc.options.anaglyph) {
                if (var11 == 0) {
                    GL11.glColorMask(false, true, true, false);
                } else {
                    GL11.glColorMask(true, false, false, false);
                }
            }
            GL11.glViewport(0, 0, this.mc.displayWidth, this.mc.displayHeight);
            this.updateFogColor(renderPartialTick);
            GL11.glClear(16640);
            GL11.glEnable(2884);
            this.setupCameraTransform(renderPartialTick, var11);
            ClippingHelperImplementation.getInstance();
            if (this.mc.options.renderDistance < 2) {
                this.setupFog(-1);
                var3.renderSky(renderPartialTick);
            }
            GL11.glEnable(2912);
            this.setupFog(1);
            Frustum var12 = new Frustum();
            var12.setPosition(var5, var7, var9);
            this.mc.renderGlobal.clipRenderersByFrustum(var12, renderPartialTick);
            this.mc.renderGlobal.updateRenderers(var2, false);
            this.setupFog(0);
            GL11.glEnable(2912);
            GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            var3.sortAndRender(var2, 0, renderPartialTick);
            RenderHelper.enableStandardItemLighting();
            var3.renderEntities(var2.getPosition(renderPartialTick), var12, renderPartialTick);
            var4.renderLitParticles(var2, renderPartialTick);
            RenderHelper.disableStandardItemLighting();
            this.setupFog(0);
            var4.renderParticles(var2, renderPartialTick);
            if (this.mc.objectMouseOver != null && var2.isInsideOfMaterial(Material.water)) {
                GL11.glDisable(3008);
                var3.drawBlockBreaking(var2, this.mc.objectMouseOver, 0, var2.inventory.getCurrentItem(), renderPartialTick);
                var3.drawSelectionBox(var2, this.mc.objectMouseOver, 0, var2.inventory.getCurrentItem(), renderPartialTick);
                GL11.glEnable(3008);
            }
            GL11.glBlendFunc(770, 771);
            this.setupFog(0);
            GL11.glEnable(3042);
            GL11.glDisable(2884);
            GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/terrain.png"));
            if (this.mc.options.fancyGraphics) {
                GL11.glColorMask(false, false, false, false);
                int var13 = var3.sortAndRender(var2, 1, renderPartialTick);
                GL11.glColorMask(true, true, true, true);
                if (this.mc.options.anaglyph) {
                    if (var11 == 0) {
                        GL11.glColorMask(false, true, true, false);
                    } else {
                        GL11.glColorMask(true, false, false, false);
                    }
                }
                if (var13 > 0) {
                    var3.renderAllRenderLists(1, renderPartialTick);
                }
            } else {
                var3.sortAndRender(var2, 1, renderPartialTick);
            }
            GL11.glDepthMask(true);
            GL11.glEnable(2884);
            GL11.glDisable(3042);
            if (this.mc.objectMouseOver != null && !var2.isInsideOfMaterial(Material.water)) {
                GL11.glDisable(3008);
                var3.drawBlockBreaking(var2, this.mc.objectMouseOver, 0, var2.inventory.getCurrentItem(), renderPartialTick);
                var3.drawSelectionBox(var2, this.mc.objectMouseOver, 0, var2.inventory.getCurrentItem(), renderPartialTick);
                GL11.glEnable(3008);
            }
            GL11.glDisable(2912);
            if (this.mc.theWorld.snowCovered) {
                this.renderSnow(renderPartialTick);
            }
            if (this.pointedEntity != null) {
                // empty if block
            }
            this.setupFog(0);
            GL11.glEnable(2912);
            var3.renderClouds(renderPartialTick);
            GL11.glDisable(2912);
            this.setupFog(1);
            GL11.glClear(256);
            this.renderHand(renderPartialTick, var11);
            if (!this.mc.options.anaglyph) {
                return;
            }
            ++var11;
        }
        GL11.glColorMask(true, true, true, false);
    }

    private void addRainParticles() {
        if (this.mc.options.fancyGraphics) {
            EntityPlayerSP var1 = this.mc.thePlayer;
            World var2 = this.mc.theWorld;
            int var3 = MathHelper.floor_double(var1.posX);
            int var4 = MathHelper.floor_double(var1.posY);
            int var5 = MathHelper.floor_double(var1.posZ);
            int var7 = 0;
            while (var7 < 150) {
                int var8 = var3 + this.random.nextInt(16) - this.random.nextInt(16);
                int var9 = var5 + this.random.nextInt(16) - this.random.nextInt(16);
                int var10 = var2.getPrecipitationHeight(var8, var9);
                int var11 = var2.getBlockId(var8, var10 - 1, var9);
                if (var10 <= var4 + 16 && var10 >= var4 - 16) {
                    float var12 = this.random.nextFloat();
                    float var13 = this.random.nextFloat();
                    if (var11 > 0) {
                        this.mc.effectRenderer.addEffect(new EntityRainFX(var2, (float)var8 + var12, (double)((float)var10 + 0.1f) - Block.blocksList[var11].minY, (float)var9 + var13));
                    }
                }
                ++var7;
            }
        }
    }

    private void renderSnow(float renderPartialTick) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        World var3 = this.mc.theWorld;
        int var4 = MathHelper.floor_double(var2.posX);
        int var5 = MathHelper.floor_double(var2.posY);
        int var6 = MathHelper.floor_double(var2.posZ);
        Tessellator var7 = Tessellator.instance;
        GL11.glDisable(2884);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glBindTexture(3553, this.mc.renderEngine.getTexture("/snow.png"));
        double var8 = var2.lastTickPosX + (var2.posX - var2.lastTickPosX) * (double)renderPartialTick;
        double var10 = var2.lastTickPosY + (var2.posY - var2.lastTickPosY) * (double)renderPartialTick;
        double var12 = var2.lastTickPosZ + (var2.posZ - var2.lastTickPosZ) * (double)renderPartialTick;
        int var14 = 5;
        if (this.mc.options.fancyGraphics) {
            var14 = 10;
        }
        int var15 = var4 - var14;
        while (var15 <= var4 + var14) {
            int var16 = var6 - var14;
            while (var16 <= var6 + var14) {
                int var17 = var3.getTopSolidOrLiquidBlock(var15, var16);
                if (var17 < 0) {
                    var17 = 0;
                }
                int var18 = var5 - var14;
                int var19 = var5 + var14;
                if (var18 < var17) {
                    var18 = var17;
                }
                if (var19 < var17) {
                    var19 = var17;
                }
                if (var18 != var19) {
                    this.random.setSeed(var15 * var15 * 3121 + var15 * 45238971 + var16 * var16 * 418711 + var16 * 13761);
                    float var21 = (float)this.int_j + renderPartialTick;
                    float var22 = ((float)(this.int_j & 0x1FF) + renderPartialTick) / 512.0f;
                    float var23 = this.random.nextFloat() + var21 * 0.01f * (float)this.random.nextGaussian();
                    float var24 = this.random.nextFloat() + var21 * (float)this.random.nextGaussian() * 0.001f;
                    double var25 = (double)((float)var15 + 0.5f) - var2.posX;
                    double var27 = (double)((float)var16 + 0.5f) - var2.posZ;
                    float var29 = MathHelper.sqrt_double(var25 * var25 + var27 * var27) / (float)var14;
                    var7.startDrawingQuads();
                    float var30 = var3.getBrightness(var15, 128, var16);
                    GL11.glColor4f(var30, var30, var30, (1.0f - var29 * var29) * 0.7f);
                    var7.setTranslationD(-var8 * 1.0, -var10 * 1.0, -var12 * 1.0);
                    var7.addVertexWithUV(var15 + 0, var18, var16 + 0, 0.0f + var23, (float)var18 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 1, var18, var16 + 1, 2.0f + var23, (float)var18 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 1, var19, var16 + 1, 2.0f + var23, (float)var19 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 0, var19, var16 + 0, 0.0f + var23, (float)var19 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 0, var18, var16 + 1, 0.0f + var23, (float)var18 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 1, var18, var16 + 0, 2.0f + var23, (float)var18 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 1, var19, var16 + 0, 2.0f + var23, (float)var19 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.addVertexWithUV(var15 + 0, var19, var16 + 1, 0.0f + var23, (float)var19 * 2.0f / 8.0f + var22 * 2.0f + var24);
                    var7.setTranslationD(0.0, 0.0, 0.0);
                    var7.draw();
                }
                ++var16;
            }
            ++var15;
        }
        GL11.glEnable(2884);
        GL11.glDisable(3042);
    }

    public void setupOverlayRendering() {
        ScaledResolution var1 = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight);
        int var2 = var1.getScaledWidth();
        int var3 = var1.getScaledHeight();
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, var2, var3, 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
    }

    private void updateFogColor(float renderPartialTick) {
        float var11;
        World var2 = this.mc.theWorld;
        EntityPlayerSP var3 = this.mc.thePlayer;
        float var4 = 1.0f - (float)Math.pow(1.0f / (float)(4 - this.mc.options.renderDistance), 0.25);
        Vec3D var5 = var2.getSkyColor(renderPartialTick);
        float var6 = (float)var5.xCoord;
        float var7 = (float)var5.yCoord;
        float var8 = (float)var5.zCoord;
        Vec3D var9 = var2.getFogColor(renderPartialTick);
        this.fogColorRed = (float)var9.xCoord;
        this.fogColorGreen = (float)var9.yCoord;
        this.fogColorBlue = (float)var9.zCoord;
        this.fogColorRed += (var6 - this.fogColorRed) * var4;
        this.fogColorGreen += (var7 - this.fogColorGreen) * var4;
        this.fogColorBlue += (var8 - this.fogColorBlue) * var4;
        if (var3.isInsideOfMaterial(Material.water)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (var3.isInsideOfMaterial(Material.lava)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float var10 = this.prevFogColor + (this.fogColor - this.prevFogColor) * renderPartialTick;
        this.fogColorRed *= var10;
        this.fogColorGreen *= var10;
        this.fogColorBlue *= var10;
        if (this.mc.options.anaglyph) {
            var11 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float var14 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float var13 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = var11;
            this.fogColorGreen = var14;
            this.fogColorBlue = var13;
        }
        var11 = (float)(1000L - Math.abs(23000L - var2.worldTime % 24000L)) / 1000.0f;
        float[] var141 = ColorUtil.BlendColor(Math.max(0.0f, var11) / 2.0f, this.fogColorRed, this.fogColorGreen, this.fogColorBlue);
        this.fogColorRed = var141[0];
        this.fogColorGreen = var141[1];
        this.fogColorBlue = var141[2];
        GL11.glClearColor(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 0.0f);
    }

    private void setupFog(int var1) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        GL11.glFog(2918, this.setFogColorBuffer(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        GL11.glNormal3f(0.0f, -1.0f, 0.0f);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (var2.isInsideOfMaterial(Material.water)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 0.1f);
            if (this.mc.options.anaglyph) {
                // empty if block
            }
        } else if (var2.isInsideOfMaterial(Material.lava)) {
            GL11.glFogi(2917, 2048);
            GL11.glFogf(2914, 2.0f);
            if (this.mc.options.anaglyph) {
                // empty if block
            }
        } else {
            GL11.glFogi(2917, 9729);
            GL11.glFogf(2915, this.fl_i * 0.25f);
            GL11.glFogf(2916, this.fl_i);
            if (var1 < 0) {
                GL11.glFogf(2915, 0.0f);
                GL11.glFogf(2916, this.fl_i * 0.8f);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi(34138, 34139);
            }
        }
        GL11.glEnable(2903);
        GL11.glColorMaterial(1028, 4608);
    }

    private FloatBuffer setFogColorBuffer(float r, float g, float b, float a) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(r).put(g).put(b).put(a);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

