/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPickupFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiChest;
import net.minecraft.src.GuiCrafting;
import net.minecraft.src.GuiEditSign;
import net.minecraft.src.GuiEssence;
import net.minecraft.src.GuiFurnace;
import net.minecraft.src.IInventory;
import net.minecraft.src.InputHandler;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovementInput;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Session;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.World;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput movementInput;
    private Minecraft mc;
    private Random rng = new Random();
    public int hunger = 0;
    public int dashTimer = 0;
    private int lastGroupX = 0;
    private int lastGroupY = 0;

    public EntityPlayerSP(Minecraft mc, World worldObj, Session session) {
        super(worldObj);
        this.mc = mc;
        if (session != null && session.username != null && session.username.length() > 0) {
            boolean var4 = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1;
            this.skinUrl = "file:///" + (var4 ? "." : "C:") + "/skincache/" + session.username + ".png";
            System.out.println("Loading texture " + this.skinUrl);
        }
        this.username = session.username;
    }

    @Override
    public void updateEntityActionState() {
        super.updateEntityActionState();
        this.moveStrafing = this.movementInput.moveStrafe;
        this.moveForward = this.movementInput.moveForward;
        this.isJumping = this.movementInput.jump;
    }

    @Override
    public void onLivingUpdate() {
        this.movementInput.updatePlayerMoveState(this);
        if (this.mc.options.difficulty != 4 && this.mc.options.difficulty != 0) {
            ++this.hunger;
            if (this.hunger >= 1200) {
                this.attackEntityFrom(null, 2);
                this.hunger = 0;
            }
        }
        if (this.dashTimer > 0) {
            --this.dashTimer;
            if (this.dashTimer == 0) {
                this.mc.theWorld.playSoundEffect(this.posX, this.posY, this.posZ, "ext.recharg", 0.6f, 1.0f);
            }
        }
        int var1 = (int)this.posX / 32;
        int var2 = (int)this.posZ / 32;
        if (this.lastGroupX != var1 || this.lastGroupY != var2) {
            this.lastGroupX = var1;
            this.lastGroupY = var2;
            if (InputHandler.IsKeyDown(207) || this.rng.nextInt(100) > 90) {
                if (InputHandler.IsKeyDown(207)) {
                    System.out.println("Taken the Titan's challenge. Good luck.");
                }
                this.worldObj.CueSpawnBossFrom((int)this.posX, (int)this.posZ);
            }
        }
        if (this.worldObj.milestone >= 10L) {
            // empty if block
        }
        super.onLivingUpdate();
    }

    public void resetPlayerKeyState() {
        this.movementInput.resetKeyState();
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (this.mc.options.difficulty != 4) {
            return super.attackEntityFrom(var1, var2);
        }
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            return false;
        }
        this.heartsLife = this.heartsHalvesLife;
        System.out.println("Damage taken: " + var2);
        if (this.inventory.getTotalArmorValue() == 0) {
            this.health = 0;
            this.onDeath(null);
            this.worldObj.playSoundAtEntity(this, "random.glass", 1.0f, 1.0f);
        } else {
            this.worldObj.playSoundAtEntity(this, "ext.crack", 1.0f, 1.0f);
            int var3 = 0;
            int var4 = 0;
            while (var4 != 4) {
                var3 += this.inventory.armorItemInSlot(var4) == null ? 0 : 1;
                ++var4;
            }
            this.inventory.damageArmor(var2 * 16 / var3);
        }
        return true;
    }

    public void handleKeyPress(int var1, boolean var2) {
        this.movementInput.checkKeyForMovementInput(var1, var2);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setInteger("Score", this.score);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.score = var1.getInteger("Score");
    }

    @Override
    public void displayGUIChest(IInventory var1) {
        this.mc.displayGuiScreen(new GuiChest(this.inventory, var1));
    }

    @Override
    public void displayGUIEditSign(TileEntitySign signTileEntity) {
        this.mc.displayGuiScreen(new GuiEditSign(signTileEntity));
    }

    @Override
    public void displayWorkbenchGUI() {
        this.mc.displayGuiScreen(new GuiCrafting(this.inventory));
    }

    @Override
    public void displayEssenceGUI() {
        this.mc.displayGuiScreen(new GuiEssence(this.inventory));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace var1) {
        this.mc.displayGuiScreen(new GuiFurnace(this.inventory, var1));
    }

    public void attackEntity(Entity entity) {
        int var2 = this.inventory.getDamageVsEntity(entity);
        if (var2 > 0) {
            entity.attackEntityFrom(this, var2);
            ItemStack var3 = this.getCurrentEquippedItem();
            if (var3 != null && entity instanceof EntityLiving) {
                var3.hitEntity((EntityLiving)entity);
                if (var3.stackSize <= 0) {
                    var3.onItemDestroyedByUse(this);
                    this.destroyCurrentEquippedItem();
                }
            }
        }
    }

    @Override
    public void onItemPickup(Entity var1, int var2) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, var1, this, -0.5f));
    }

    public int getPlayerArmorValue() {
        return this.inventory.getTotalArmorValue();
    }

    @Override
    public void interactWithEntity(Entity var1) {
        ItemStack var2;
        if (!var1.interact(this) && (var2 = this.getCurrentEquippedItem()) != null && var1 instanceof EntityLiving) {
            var2.useItemOnEntity((EntityLiving)var1);
            if (var2.stackSize <= 0) {
                var2.onItemDestroyedByUse(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public void sendChatMessage(String chatMessage) {
    }

    public void onPlayerUpdate() {
    }
}

