/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityCreeper
extends EntityMob {
    int timeSinceIgnited;
    int lastActiveTime;
    int fuseDuration = 30;
    int creeperState = -1;

    public EntityCreeper(World var1) {
        super(var1);
        this.texture = "/mob/creeper.png";
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
    }

    @Override
    protected void updateEntityActionState() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.timeSinceIgnited > 0 && this.creeperState < 0) {
            --this.timeSinceIgnited;
        }
        if (this.creeperState >= 0) {
            this.creeperState = 2;
        }
        super.updateEntityActionState();
        if (this.creeperState != 1) {
            this.creeperState = -1;
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.creeper";
    }

    @Override
    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    @Override
    public void onDeath(Entity var1) {
        super.onDeath(var1);
        if (var1 instanceof EntitySkeleton) {
            this.dropItem(Item.record13.shiftedIndex + this.rand.nextInt(2), 1);
        }
    }

    @Override
    protected void attackEntity(Entity var1, float var2) {
        if (this.creeperState <= 0 && var2 < 3.0f || this.creeperState > 0 && var2 < 7.0f) {
            if (this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.creeperState = 1;
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited == this.fuseDuration) {
                this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 3.0f);
                this.setEntityDead();
            }
            this.hasAttacked = true;
        }
    }

    public float getCreeperFlashTime(float var1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * var1) / (float)(this.fuseDuration - 2);
    }

    @Override
    protected int getDropItemId() {
        return Item.gunpowder.shiftedIndex;
    }
}

