/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    protected Entity entityToAttack;
    protected boolean hasAttacked = false;

    public EntityCreature(World var1) {
        super(var1);
    }

    @Override
    protected void updateEntityActionState() {
        this.hasAttacked = false;
        float var1 = 16.0f;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, var1);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float var22 = this.entityToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, var22);
            }
        }
        if (this.hasAttacked || this.entityToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0) {
            if (this.pathToEntity == null && this.rand.nextInt(80) == 0 || this.rand.nextInt(80) == 0) {
                boolean z21 = false;
                int var23 = -1;
                int var24 = -1;
                int var25 = -1;
                float var26 = -99999.0f;
                int var7 = 0;
                while (var7 < 10) {
                    int var28;
                    int var9;
                    int var27 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
                    float var11 = this.getBlockPathWeight(var27, var9 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), var28 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
                    if (var11 > var26) {
                        var26 = var11;
                        var23 = var27;
                        var24 = var9;
                        var25 = var28;
                        z21 = true;
                    }
                    ++var7;
                }
                if (z21) {
                    this.pathToEntity = this.worldObj.getEntityPathToXYZ(this, var23, var24, var25, 10.0f);
                }
            }
        } else {
            this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, var1);
        }
        int i22 = MathHelper.floor_double(this.boundingBox.minY);
        boolean z23 = this.handleWaterMovement();
        boolean z24 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity != null && this.rand.nextInt(100) != 0) {
            Vec3D vec3D25 = this.pathToEntity.getPosition(this);
            double d26 = this.width * 2.0f;
            while (vec3D25 != null && vec3D25.squareDistanceTo(this.posX, vec3D25.yCoord, this.posZ) < d26 * d26) {
                this.pathToEntity.incrementPathIndex();
                if (this.pathToEntity.isFinished()) {
                    vec3D25 = null;
                    this.pathToEntity = null;
                    continue;
                }
                vec3D25 = this.pathToEntity.getPosition(this);
            }
            this.isJumping = false;
            if (vec3D25 != null) {
                double d27 = vec3D25.xCoord - this.posX;
                double d28 = vec3D25.zCoord - this.posZ;
                double var12 = vec3D25.yCoord - (double)i22;
                float var14 = (float)(Math.atan2(d28, d27) * 180.0 / 3.1415927410125732) - 90.0f;
                float var15 = var14 - this.rotationYaw;
                this.moveForward = this.moveSpeed;
                while (var15 < -180.0f) {
                    var15 += 360.0f;
                }
                while (var15 >= 180.0f) {
                    var15 -= 360.0f;
                }
                if (var15 > 30.0f) {
                    var15 = 30.0f;
                }
                if (var15 < -30.0f) {
                    var15 = -30.0f;
                }
                this.rotationYaw += var15;
                if (this.hasAttacked && this.entityToAttack != null) {
                    double var16 = this.entityToAttack.posX - this.posX;
                    double var18 = this.entityToAttack.posZ - this.posZ;
                    float var20 = this.rotationYaw;
                    this.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / 3.1415927410125732) - 90.0f;
                    var15 = (var20 - this.rotationYaw + 90.0f) * (float)Math.PI / 180.0f;
                    this.moveStrafing = -MathHelper.sin(var15) * this.moveForward * 1.0f;
                    this.moveForward = MathHelper.cos(var15) * this.moveForward * 1.0f;
                }
                if (var12 > 0.0) {
                    this.isJumping = true;
                }
            }
            if (this.entityToAttack != null) {
                this.faceEntity(this.entityToAttack, 30.0f);
            }
            if (this.isCollidedHorizontally) {
                this.isJumping = true;
            }
            if (this.rand.nextFloat() < 0.8f && (z23 || z24)) {
                this.isJumping = true;
            }
        } else {
            super.updateEntityActionState();
            this.pathToEntity = null;
        }
    }

    protected void attackEntity(Entity entity, float distance) {
    }

    protected float getBlockPathWeight(int x, int y, int z) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    @Override
    public boolean getCanSpawnHere() {
        int var1 = MathHelper.floor_double(this.posX);
        int var2 = MathHelper.floor_double(this.boundingBox.minY);
        int var3 = MathHelper.floor_double(this.posZ);
        return super.getCanSpawnHere() && this.getBlockPathWeight(var1, var2, var3) >= 0.0f;
    }
}

