/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityArrow
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inData = false;
    public int arrowShake = 0;
    private EntityLiving shootingEntity;
    private int ticksInGround;
    private int ticksInAir = 0;

    public EntityArrow(World var1) {
        super(var1);
        this.setSize(0.5f, 0.5f);
    }

    public EntityArrow(World world, EntityLiving entityLiving) {
        super(world);
        this.shootingEntity = entityLiving;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(entityLiving.posX, entityLiving.posY, entityLiving.posZ, entityLiving.rotationYaw, entityLiving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI);
        this.setArrowHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public void setArrowHeading(double moveX, double moveY, double moveZ, float arrowSpeed, float arrowSpread) {
        float var9 = MathHelper.sqrt_double(moveX * moveX + moveY * moveY + moveZ * moveZ);
        moveX /= (double)var9;
        moveY /= (double)var9;
        moveZ /= (double)var9;
        moveX += this.rand.nextGaussian() * (double)0.0075f * (double)arrowSpread;
        moveY += this.rand.nextGaussian() * (double)0.0075f * (double)arrowSpread;
        moveZ += this.rand.nextGaussian() * (double)0.0075f * (double)arrowSpread;
        this.motionX = moveX *= (double)arrowSpeed;
        this.motionY = moveY *= (double)arrowSpeed;
        this.motionZ = moveZ *= (double)arrowSpeed;
        float var10 = MathHelper.sqrt_double(moveX * moveX + moveZ * moveZ);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(moveX, moveZ) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(moveY, var10) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @Override
    public void onUpdate() {
        float var10;
        super.onUpdate();
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inData) {
            int var15 = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
            if (var15 == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setEntityDead();
                }
                return;
            }
            this.inData = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3D vec3D15 = Vec3D.createVector(this.posX, this.posY, this.posZ);
        Vec3D var2 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition var3 = this.worldObj.rayTraceBlocks(vec3D15, var2);
        vec3D15 = Vec3D.createVector(this.posX, this.posY, this.posZ);
        var2 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (var3 != null) {
            var2 = Vec3D.createVector(var3.hitVec.xCoord, var3.hitVec.yCoord, var3.hitVec.zCoord);
        }
        Entity var4 = null;
        List var5 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        double var6 = 0.0;
        int var16 = 0;
        while (var16 < var5.size()) {
            double var13;
            AxisAlignedBB var18;
            MovingObjectPosition var19;
            Entity var17 = (Entity)var5.get(var16);
            if (var17.canBeCollidedWith() && (var17 != this.shootingEntity || this.ticksInAir >= 5) && (var19 = (var18 = var17.boundingBox.expand(var10 = 0.3f, var10, var10)).calculateIntercept(vec3D15, var2)) != null && ((var13 = vec3D15.distanceTo(var19.hitVec)) < var6 || var6 == 0.0)) {
                var4 = var17;
                var6 = var13;
            }
            ++var16;
        }
        if (var4 != null) {
            var3 = new MovingObjectPosition(var4);
        }
        if (var3 != null) {
            if (var3.entityHit != null) {
                if (var3.entityHit.attackEntityFrom(this.shootingEntity, 4)) {
                    this.worldObj.playSoundAtEntity(this, "random.drr", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.setEntityDead();
                } else {
                    this.motionX *= (double)-0.1f;
                    this.motionY *= (double)-0.1f;
                    this.motionZ *= (double)-0.1f;
                    this.rotationYaw += 180.0f;
                    this.prevRotationYaw += 180.0f;
                    this.ticksInAir = 0;
                }
            } else {
                this.xTile = var3.blockX;
                this.yTile = var3.blockY;
                this.zTile = var3.blockZ;
                this.inTile = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
                this.motionX = (float)(var3.hitVec.xCoord - this.posX);
                this.motionY = (float)(var3.hitVec.yCoord - this.posY);
                this.motionZ = (float)(var3.hitVec.zCoord - this.posZ);
                float f16 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
                this.posX -= this.motionX / (double)f16 * (double)0.05f;
                this.posY -= this.motionY / (double)f16 * (double)0.05f;
                this.posZ -= this.motionZ / (double)f16 * (double)0.05f;
                this.worldObj.playSoundAtEntity(this, "random.drr", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                this.inData = true;
                this.arrowShake = 7;
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f16 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f16) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f17 = 0.99f;
        var10 = 0.03f;
        if (this.handleWaterMovement()) {
            int i18 = 0;
            while (i18 < 4) {
                float f19 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f19, this.posY - this.motionY * (double)f19, this.posZ - this.motionZ * (double)f19, this.motionX, this.motionY, this.motionZ);
                ++i18;
            }
            f17 = 0.8f;
        }
        this.motionX *= (double)f17;
        this.motionY *= (double)f17;
        this.motionZ *= (double)f17;
        this.motionY -= (double)var10;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("xTile", (short)this.xTile);
        var1.setShort("yTile", (short)this.yTile);
        var1.setShort("zTile", (short)this.zTile);
        var1.setByte("inTile", (byte)this.inTile);
        var1.setByte("shake", (byte)this.arrowShake);
        var1.setByte("inGround", (byte)(this.inData ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.xTile = var1.getShort("xTile");
        this.yTile = var1.getShort("yTile");
        this.zTile = var1.getShort("zTile");
        this.inTile = var1.getByte("inTile") & 0xFF;
        this.arrowShake = var1.getByte("shake") & 0xFF;
        this.inData = var1.getByte("inGround") == 1;
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer var1) {
        if (this.inData && this.shootingEntity == var1 && this.arrowShake <= 0 && var1.inventory.addItemStackToInventory(new ItemStack(Item.arrow.shiftedIndex, 1))) {
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            var1.onItemPickup(this, 1);
            this.setEntityDead();
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

