/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ItemStack;

public class CraftingRecipe {
    private int width;
    private int height;
    private int[] ingredientMap;
    private ItemStack resultStack;
    public final int resultId;

    public CraftingRecipe(int width, int height, int[] ingredientMap, ItemStack resultStack) {
        this.resultId = resultStack.itemID;
        this.width = width;
        this.height = height;
        this.ingredientMap = ingredientMap;
        this.resultStack = resultStack;
    }

    public boolean matches(int[] var1) {
        int var2 = 0;
        while (var2 <= 3 - this.width) {
            int var3 = 0;
            while (var3 <= 3 - this.height) {
                if (this.checkMatch(var1, var2, var3, true)) {
                    return true;
                }
                if (this.checkMatch(var1, var2, var3, false)) {
                    return true;
                }
                ++var3;
            }
            ++var2;
        }
        return false;
    }

    private boolean checkMatch(int[] var1, int var2, int var3, boolean var4) {
        int var5 = 0;
        while (var5 < 3) {
            int var6 = 0;
            while (var6 < 3) {
                int var7 = var5 - var2;
                int var8 = var6 - var3;
                int var9 = -1;
                if (var7 >= 0 && var8 >= 0 && var7 < this.width && var8 < this.height) {
                    var9 = var4 ? this.ingredientMap[this.width - var7 - 1 + var8 * this.width] : this.ingredientMap[var7 + var8 * this.width];
                }
                if (var1[var5 + var6 * 3] != var9) {
                    return false;
                }
                ++var6;
            }
            ++var5;
        }
        return true;
    }

    public ItemStack getCraftingResult(int[] var1) {
        return new ItemStack(this.resultStack.itemID, this.resultStack.stackSize);
    }

    public int getRecipeSize() {
        return this.width * this.height;
    }
}

