/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.src.EnumOSIsom;
import net.minecraft.src.IsoImageBuffer;
import net.minecraft.src.TerrainTextureManager;
import net.minecraft.src.ThreadRunIsoClient;
import net.minecraft.src.World;
import net.minecraft.src.WorldIso;

public class CanvasIsomPreview
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    private int currentRender = 0;
    private int zoomLevel = 2;
    private boolean displayHelpText = true;
    private World level;
    private File dataFolder = this.getWorkingDirectory();
    private boolean running = true;
    private List zonesToRender = Collections.synchronizedList(new LinkedList());
    private IsoImageBuffer[][] zoneMap = new IsoImageBuffer[64][64];
    private int translateX;
    private int translateY;
    private int xPosition;
    private int yPosition;

    public File getWorkingDirectory() {
        if (this.dataFolder == null) {
            this.dataFolder = this.getWorkingDirectory("minecraft");
        }
        return this.dataFolder;
    }

    public File getWorkingDirectory(String name) {
        File var3;
        String var2 = System.getProperty("user.home", ".");
        switch (SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOSIsom[CanvasIsomPreview.getPlatform().ordinal()]) {
            case 1: 
            case 2: {
                var3 = new File(var2, String.valueOf('.') + name + '/');
                break;
            }
            case 3: {
                String var4 = System.getenv("APPDATA");
                if (var4 != null) {
                    var3 = new File(var4, "." + name + '/');
                    break;
                }
                var3 = new File(var2, String.valueOf('.') + name + '/');
                break;
            }
            case 4: {
                var3 = new File(var2, "Library/Application Support/" + name);
                break;
            }
            default: {
                var3 = new File(var2, String.valueOf(name) + '/');
            }
        }
        if (!var3.exists() && !var3.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + var3);
        }
        return var3;
    }

    private static EnumOSIsom getPlatform() {
        String var0 = System.getProperty("os.name").toLowerCase();
        return var0.contains("win") ? EnumOSIsom.windows : (var0.contains("mac") ? EnumOSIsom.macos : (var0.contains("solaris") ? EnumOSIsom.solaris : (var0.contains("sunos") ? EnumOSIsom.solaris : (var0.contains("linux") ? EnumOSIsom.linux : (var0.contains("unix") ? EnumOSIsom.linux : EnumOSIsom.unknown)))));
    }

    public CanvasIsomPreview() {
        int var1 = 0;
        while (var1 < 64) {
            int var2 = 0;
            while (var2 < 64) {
                this.zoneMap[var1][var2] = new IsoImageBuffer(null, var1, var2);
                ++var2;
            }
            ++var1;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.setBackground(Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevel(String levelName) {
        this.translateY = 0;
        this.translateX = 0;
        this.level = new WorldIso(this, new File(this.dataFolder, "saves"), levelName);
        this.level.skylightSubtracted = 0;
        List var2 = this.zonesToRender;
        List list3 = this.zonesToRender;
        List list = this.zonesToRender;
        synchronized (list) {
            this.zonesToRender.clear();
            int var3 = 0;
            while (var3 < 64) {
                int var4 = 0;
                while (var4 < 64) {
                    this.zoneMap[var3][var4].setLevel(this.level, var3, var4);
                    ++var4;
                }
                ++var3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBrightness(int brightness) {
        List var2 = this.zonesToRender;
        List list3 = this.zonesToRender;
        List list = this.zonesToRender;
        synchronized (list) {
            this.level.skylightSubtracted = brightness;
            this.zonesToRender.clear();
            int var3 = 0;
            while (var3 < 64) {
                int var4 = 0;
                while (var4 < 64) {
                    this.zoneMap[var3][var4].setLevel(this.level, var3, var4);
                    ++var4;
                }
                ++var3;
            }
        }
    }

    public void start() {
        new ThreadRunIsoClient(this).start();
        int var1 = 0;
        while (var1 < 8) {
            new Thread(this).start();
            ++var1;
        }
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsoImageBuffer getZone(int x, int z) {
        int var3 = x & 0x3F;
        int var4 = z & 0x3F;
        IsoImageBuffer var5 = this.zoneMap[var3][var4];
        if (var5.x == x && var5.y == z) {
            return var5;
        }
        List var6 = this.zonesToRender;
        List list7 = this.zonesToRender;
        List list = this.zonesToRender;
        synchronized (list) {
            this.zonesToRender.remove(var5);
        }
        var5.init(x, z);
        return var5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TerrainTextureManager var1 = new TerrainTextureManager();
        while (this.running) {
            IsoImageBuffer var2 = null;
            List var3 = this.zonesToRender;
            List var5 = this.zonesToRender;
            List list = this.zonesToRender;
            synchronized (list) {
                if (this.zonesToRender.size() > 0) {
                    var2 = (IsoImageBuffer)this.zonesToRender.remove(0);
                }
            }
            if (var2 != null) {
                if (this.currentRender - var2.lastVisible < 2) {
                    var1.render(var2);
                    this.repaint();
                } else {
                    var2.addedToRenderQueue = false;
                }
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException6) {
                interruptedException6.printStackTrace();
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    public void render() {
        BufferStrategy var1 = this.getBufferStrategy();
        if (var1 == null) {
            this.createBufferStrategy(2);
        } else {
            this.render((Graphics2D)var1.getDrawGraphics());
            var1.show();
        }
    }

    public void render(Graphics2D graphics2D) {
        ++this.currentRender;
        AffineTransform var2 = graphics2D.getTransform();
        graphics2D.setClip(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.translate(this.getWidth() / 2, this.getHeight() / 2);
        graphics2D.scale(this.zoomLevel, this.zoomLevel);
        graphics2D.translate(this.translateX, this.translateY);
        if (this.level != null) {
            graphics2D.translate(-(this.level.spawnX + this.level.spawnZ), -(-this.level.spawnX + this.level.spawnZ) + 64);
        }
        Rectangle var3 = graphics2D.getClipBounds();
        graphics2D.setColor(new Color(-15724512));
        graphics2D.fillRect(var3.x, var3.y, var3.width, var3.height);
        int var4 = 16;
        int var5 = 3;
        int var6 = var3.x / var4 / 2 - 2 - var5;
        int var7 = (var3.x + var3.width) / var4 / 2 + 1 + var5;
        int var8 = var3.y / var4 - 1 - var5 * 2;
        int var9 = (var3.y + var3.height + 16 + 128) / var4 + 1 + var5 * 2;
        int var10 = var8;
        while (var10 <= var9) {
            int var17 = var6;
            while (var17 <= var7) {
                int var12 = var17 - (var10 >> 1);
                int var13 = var17 + (var10 + 1 >> 1);
                IsoImageBuffer var14 = this.getZone(var12, var13);
                var14.lastVisible = this.currentRender;
                if (!var14.rendered) {
                    if (!var14.addedToRenderQueue) {
                        var14.addedToRenderQueue = true;
                        this.zonesToRender.add(var14);
                    }
                } else {
                    var14.addedToRenderQueue = false;
                    if (!var14.noContent) {
                        int var15 = var17 * var4 * 2 + (var10 & 1) * var4;
                        int var16 = var10 * var4 - 128 - 16;
                        graphics2D.drawImage((Image)var14.image, var15, var16, null);
                    }
                }
                ++var17;
            }
            ++var10;
        }
        if (this.displayHelpText) {
            graphics2D.setTransform(var2);
            var10 = this.getHeight() - 32 - 4;
            graphics2D.setColor(new Color(Integer.MIN_VALUE, true));
            graphics2D.fillRect(4, this.getHeight() - 32 - 4, this.getWidth() - 8, 32);
            graphics2D.setColor(Color.WHITE);
            String string17 = "F1 - F5: load levels   |   0-9: Set time of day   |   Space: return to spawn   |   Double click: zoom   |   Escape: hide this text";
            graphics2D.drawString(string17, this.getWidth() / 2 - graphics2D.getFontMetrics().stringWidth(string17) / 2, var10 + 20);
        }
        graphics2D.dispose();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int var2 = mouseEvent.getX() / this.zoomLevel;
        int var3 = mouseEvent.getY() / this.zoomLevel;
        this.translateX += var2 - this.xPosition;
        this.translateY += var3 - this.yPosition;
        this.xPosition = var2;
        this.yPosition = var3;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.zoomLevel = 3 - this.zoomLevel;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int var2 = mouseEvent.getX() / this.zoomLevel;
        int var3 = mouseEvent.getY() / this.zoomLevel;
        this.xPosition = var2;
        this.yPosition = var3;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 48) {
            this.setBrightness(11);
        }
        if (keyEvent.getKeyCode() == 49) {
            this.setBrightness(10);
        }
        if (keyEvent.getKeyCode() == 50) {
            this.setBrightness(9);
        }
        if (keyEvent.getKeyCode() == 51) {
            this.setBrightness(7);
        }
        if (keyEvent.getKeyCode() == 52) {
            this.setBrightness(6);
        }
        if (keyEvent.getKeyCode() == 53) {
            this.setBrightness(5);
        }
        if (keyEvent.getKeyCode() == 54) {
            this.setBrightness(3);
        }
        if (keyEvent.getKeyCode() == 55) {
            this.setBrightness(2);
        }
        if (keyEvent.getKeyCode() == 56) {
            this.setBrightness(1);
        }
        if (keyEvent.getKeyCode() == 57) {
            this.setBrightness(0);
        }
        if (keyEvent.getKeyCode() == 112) {
            this.loadLevel("World1");
        }
        if (keyEvent.getKeyCode() == 113) {
            this.loadLevel("World2");
        }
        if (keyEvent.getKeyCode() == 114) {
            this.loadLevel("World3");
        }
        if (keyEvent.getKeyCode() == 115) {
            this.loadLevel("World4");
        }
        if (keyEvent.getKeyCode() == 116) {
            this.loadLevel("World5");
        }
        if (keyEvent.getKeyCode() == 32) {
            this.translateY = 0;
            this.translateX = 0;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.displayHelpText = !this.displayHelpText;
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    static boolean isRunning(CanvasIsomPreview var0) {
        return var0.running;
    }

    static final class SyntheticClass_1 {
        static final int[] $SwitchMap$net$minecraft$src$EnumOSIsom = new int[EnumOSIsom.values().length];

        static {
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOSIsom[EnumOSIsom.linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOSIsom[EnumOSIsom.solaris.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOSIsom[EnumOSIsom.windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOSIsom[EnumOSIsom.macos.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        SyntheticClass_1() {
        }
    }
}

