/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.World;

public class BlockFurnace
extends BlockContainer {
    private final boolean isActive;

    protected BlockFurnace(int blockID, boolean isActive) {
        super(blockID, Material.rock);
        this.isActive = isActive;
        this.blockIndexInTexture = 45;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.stoneOvenIdle.blockID;
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        super.onBlockAdded(var1, var2, var3, var4);
        this.setDefaultDirection(var1, var2, var3, var4);
    }

    private void setDefaultDirection(World worldObj, int x, int y, int z) {
        int var5 = worldObj.getBlockId(x, y, z - 1);
        int var6 = worldObj.getBlockId(x, y, z + 1);
        int var7 = worldObj.getBlockId(x - 1, y, z);
        int var8 = worldObj.getBlockId(x + 1, y, z);
        int var9 = 3;
        if (Block.opaqueCubeLookup[var5] && !Block.opaqueCubeLookup[var6]) {
            var9 = 3;
        }
        if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var5]) {
            var9 = 2;
        }
        if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var8]) {
            var9 = 5;
        }
        if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var7]) {
            var9 = 4;
        }
        worldObj.setBlockMetadataWithNotify(x, y, z, var9);
    }

    @Override
    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (var5 == 1) {
            return Block.stone.blockIndexInTexture;
        }
        if (var5 == 0) {
            return Block.stone.blockIndexInTexture;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        return var5 != var6 ? this.blockIndexInTexture : (this.isActive ? this.blockIndexInTexture + 16 : this.blockIndexInTexture - 1);
    }

    @Override
    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5) {
        if (this.isActive) {
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            float var7 = (float)var2 + 0.5f;
            float var8 = (float)var3 + 0.0f + var5.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)var4 + 0.5f;
            float var10 = 0.52f;
            float var11 = var5.nextFloat() * 0.6f - 0.3f;
            if (var6 == 4) {
                var1.spawnParticle("smoke", var7 - var10, var8, var9 + var11, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 - var10, var8, var9 + var11, 0.0, 0.0, 0.0);
            } else if (var6 == 5) {
                var1.spawnParticle("smoke", var7 + var10, var8, var9 + var11, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var10, var8, var9 + var11, 0.0, 0.0, 0.0);
            } else if (var6 == 2) {
                var1.spawnParticle("smoke", var7 + var11, var8, var9 - var10, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var11, var8, var9 - var10, 0.0, 0.0, 0.0);
            } else if (var6 == 3) {
                var1.spawnParticle("smoke", var7 + var11, var8, var9 + var10, 0.0, 0.0, 0.0);
                var1.spawnParticle("flame", var7 + var11, var8, var9 + var10, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        return var1 == 1 ? Block.stone.blockID : (var1 == 0 ? Block.stone.blockID : (var1 == 3 ? this.blockIndexInTexture - 1 : this.blockIndexInTexture));
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        TileEntityFurnace var6 = (TileEntityFurnace)var1.getBlockTileEntity(var2, var3, var4);
        var5.displayGUIFurnace(var6);
        return true;
    }

    public static void updateFurnaceBlockState(boolean isActive, World worldObj, int x, int y, int z) {
        int var5 = worldObj.getBlockMetadata(x, y, z);
        TileEntity var6 = worldObj.getBlockTileEntity(x, y, z);
        if (isActive) {
            worldObj.setBlockWithNotify(x, y, z, Block.stoneOvenActive.blockID);
        } else {
            worldObj.setBlockWithNotify(x, y, z, Block.stoneOvenIdle.blockID);
        }
        worldObj.setBlockMetadataWithNotify(x, y, z, var5);
        worldObj.setBlockTileEntity(x, y, z, var6);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }
}

