/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.EnumOS;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.GameWindowListener;
import net.minecraft.src.GuiChat;
import net.minecraft.src.GuiConflictWarning;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiErrorScreen;
import net.minecraft.src.GuiGameOver;
import net.minecraft.src.GuiIngame;
import net.minecraft.src.GuiIngameMenu;
import net.minecraft.src.GuiInventory;
import net.minecraft.src.GuiMainMenu;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.InputHandler;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.LoadingScreenRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MinecraftError;
import net.minecraft.src.MinecraftException;
import net.minecraft.src.MinecraftImpl;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.MouseHelper;
import net.minecraft.src.MovementInputFromOptions;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.OpenGlCapsChecker;
import net.minecraft.src.PlayerController;
import net.minecraft.src.PlayerControllerCreative;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderManager;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Session;
import net.minecraft.src.SoundManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureCompassFX;
import net.minecraft.src.TextureFlamesFX;
import net.minecraft.src.TextureLavaFX;
import net.minecraft.src.TextureLavaFlowFX;
import net.minecraft.src.TextureWaterFX;
import net.minecraft.src.TextureWaterFlowFX;
import net.minecraft.src.ThreadDownloadResources;
import net.minecraft.src.ThreadSleepForever;
import net.minecraft.src.Timer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldRenderer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public PlayerController playerController;
    private boolean fullscreen = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker glCapabilities;
    private Timer timer = new Timer(20.0f);
    public World theWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String minecraftUri;
    public Canvas mcCanvas;
    public boolean appletMode = true;
    public volatile boolean isGamePaused = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRenderer;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadingScreen = new LoadingScreenRenderer(this);
    public EntityRenderer entityRenderer = new EntityRenderer(this);
    private ThreadDownloadResources downloadResourcesThread;
    private int ticksRan = 0;
    private int leftClickCounter = 0;
    private int tempDisplayWidth;
    private int tempDisplayHeight;
    public String loadMapUser = null;
    public int loadMapID = 0;
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld = false;
    public ModelBiped playerModelBiped = new ModelBiped(0.0f);
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings options;
    protected MinecraftApplet mcApplet;
    public SoundManager sndManager = new SoundManager();
    public MouseHelper mouseHelper;
    public File mcDataDir;
    public static long[] frameTimes = new long[512];
    public static int numRecordedFrameTimes = 0;
    private String serverName;
    private int serverPort;
    private TextureWaterFX textureWaterFX = new TextureWaterFX();
    private TextureLavaFX textureLavaFX = new TextureLavaFX();
    private static File minecraftDir = null;
    public volatile boolean running = true;
    public String debug = "";
    long prevFrameTime = -1L;
    public boolean inGameHasFocus = false;
    private int mouseTicksRan = 0;
    public boolean isRaining = false;
    long systemTime = System.currentTimeMillis();
    private int joinPlayerCounter = 0;

    public Minecraft(Component component, Canvas canvas, MinecraftApplet mcApplet, int width, int height, boolean fullscreen) {
        this.tempDisplayWidth = width;
        this.tempDisplayHeight = height;
        this.fullscreen = fullscreen;
        this.mcApplet = mcApplet;
        new ThreadSleepForever(this, "Timer hack thread");
        this.mcCanvas = canvas;
        this.displayWidth = width;
        this.displayHeight = height;
        this.fullscreen = fullscreen;
    }

    public abstract void displayUnexpectedThrowable(UnexpectedThrowable var1);

    public void setServer(String var1, int var2) {
        this.serverName = var1;
        this.serverPort = var2;
    }

    public void startGame() throws LWJGLException {
        if (this.mcCanvas != null) {
            Graphics var4 = this.mcCanvas.getGraphics();
            if (var4 != null) {
                var4.setColor(Color.BLACK);
                var4.fillRect(0, 0, this.displayWidth, this.displayHeight);
                var4.dispose();
            }
            Display.setParent(this.mcCanvas);
        } else if (this.fullscreen) {
            Display.setFullscreen(true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode(new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle("Minecraft Alpha v1.0.16.05 R4");
        try {
            Display.create();
        }
        catch (LWJGLException lWJGLException6) {
            lWJGLException6.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        RenderManager.instance.itemRenderer = new ItemRenderer(this);
        this.mcDataDir = Minecraft.getMinecraftDir();
        this.options = new GameSettings(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this.options);
        this.fontRenderer = new FontRenderer(this.options, "/default.png", this.renderEngine);
        this.loadScreen();
        Keyboard.create();
        Mouse.create();
        this.mouseHelper = new MouseHelper(this.mcCanvas);
        try {
            Controllers.create();
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
        this.checkGLError("Pre startup");
        GL11.glEnable(3553);
        GL11.glShadeModel(7425);
        GL11.glClearDepth(1.0);
        GL11.glEnable(2929);
        GL11.glDepthFunc(515);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.1f);
        GL11.glCullFace(1029);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        this.checkGLError("Startup");
        this.glCapabilities = new OpenGlCapsChecker();
        this.sndManager.loadSoundSettings(this.options);
        this.renderEngine.registerTextureFX(this.textureLavaFX);
        this.renderEngine.registerTextureFX(this.textureWaterFX);
        this.renderEngine.registerTextureFX(new TextureCompassFX(this));
        this.renderEngine.registerTextureFX(new TextureWaterFlowFX());
        this.renderEngine.registerTextureFX(new TextureLavaFlowFX());
        this.renderEngine.registerTextureFX(new TextureFlamesFX(0));
        this.renderEngine.registerTextureFX(new TextureFlamesFX(1));
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport(0, 0, this.displayWidth, this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.theWorld, this.renderEngine);
        try {
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkGLError("Post startup");
        this.ingameGUI = new GuiIngame(this);
        if (this.serverName != null) {
            this.displayGuiScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else {
            this.displayGuiScreen(new GuiMainMenu());
        }
    }

    private void loadScreen() throws LWJGLException {
        ScaledResolution var1 = new ScaledResolution(this.displayWidth, this.displayHeight);
        int var2 = var1.getScaledWidth();
        int var3 = var1.getScaledHeight();
        GL11.glClear(16640);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, var2, var3, 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
        GL11.glViewport(0, 0, this.displayWidth, this.displayHeight);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Tessellator var4 = Tessellator.instance;
        GL11.glDisable(2896);
        GL11.glEnable(3553);
        GL11.glDisable(2912);
        GL11.glBindTexture(3553, this.renderEngine.getTexture("/title/mojang.png"));
        var4.startDrawingQuads();
        var4.setColorOpaque_I(0xFFFFFF);
        var4.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
        var4.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
        var4.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
        var4.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        var4.draw();
        int var5 = 256;
        int var6 = 256;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        var4.setColorOpaque_I(0xFFFFFF);
        this.scaledTessellator((this.displayWidth / 2 - var5) / 2, (this.displayHeight / 2 - var6) / 2, 0, 0, var5, var6);
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.1f);
        Display.swapBuffers();
    }

    public void scaledTessellator(int var1, int var2, int var3, int var4, int var5, int var6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.instance;
        var9.startDrawingQuads();
        var9.addVertexWithUV(var1 + 0, var2 + var6, 0.0, (float)(var3 + 0) * var7, (float)(var4 + var6) * var8);
        var9.addVertexWithUV(var1 + var5, var2 + var6, 0.0, (float)(var3 + var5) * var7, (float)(var4 + var6) * var8);
        var9.addVertexWithUV(var1 + var5, var2 + 0, 0.0, (float)(var3 + var5) * var7, (float)(var4 + 0) * var8);
        var9.addVertexWithUV(var1 + 0, var2 + 0, 0.0, (float)(var3 + 0) * var7, (float)(var4 + 0) * var8);
        var9.draw();
    }

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("minecraft");
        }
        return minecraftDir;
    }

    public static File getAppDir(String var0) {
        File var2;
        String var1 = System.getProperty("user.home", ".");
        switch (SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOS[Minecraft.getOs().ordinal()]) {
            case 1: 
            case 2: {
                var2 = new File(var1, String.valueOf('.') + var0 + '/');
                break;
            }
            case 3: {
                String var3 = System.getenv("APPDATA");
                if (var3 != null) {
                    var2 = new File(var3, "." + var0 + '/');
                    break;
                }
                var2 = new File(var1, String.valueOf('.') + var0 + '/');
                break;
            }
            case 4: {
                var2 = new File(var1, "Library/Application Support/" + var0);
                break;
            }
            default: {
                var2 = new File(var1, String.valueOf(var0) + '/');
            }
        }
        if (!var2.exists() && !var2.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + var2);
        }
        return var2;
    }

    private static EnumOS getOs() {
        String var0 = System.getProperty("os.name").toLowerCase();
        return var0.contains("win") ? EnumOS.windows : (var0.contains("mac") ? EnumOS.macos : (var0.contains("solaris") ? EnumOS.solaris : (var0.contains("sunos") ? EnumOS.solaris : (var0.contains("linux") ? EnumOS.linux : (var0.contains("unix") ? EnumOS.linux : EnumOS.unknown)))));
    }

    public void displayGuiScreen(GuiScreen var1) {
        if (!(this.currentScreen instanceof GuiErrorScreen)) {
            if (this.currentScreen != null) {
                this.currentScreen.onGuiClosed();
            }
            if (var1 == null && this.theWorld == null) {
                var1 = new GuiMainMenu();
            } else if (var1 == null && this.thePlayer.health <= 0) {
                var1 = new GuiGameOver();
            }
            this.currentScreen = var1;
            if (var1 != null) {
                this.setIngameNotInFocus();
                ScaledResolution var2 = new ScaledResolution(this.displayWidth, this.displayHeight);
                int var3 = var2.getScaledWidth();
                int var4 = var2.getScaledHeight();
                var1.setWorldAndResolution(this, var3, var4);
                this.skipRenderWorld = false;
            } else {
                this.setIngameFocus();
            }
        }
    }

    private void checkGLError(String var1) {
        int var2 = GL11.glGetError();
        if (var2 != 0) {
            String var3 = GLU.gluErrorString(var2);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + var1);
            System.out.println(String.valueOf(var2) + ": " + var3);
            System.exit(0);
        }
    }

    public void shutdownMinecraftApplet() {
        if (this.mcApplet != null) {
            this.mcApplet.clearApplet();
        }
        try {
            if (this.downloadResourcesThread != null) {
                this.downloadResourcesThread.b();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Stopping!");
            this.changeWorld1(null);
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sndManager.closeMinecraft();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
        }
        System.gc();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Exception exception13) {
            exception13.printStackTrace();
            this.displayUnexpectedThrowable(new UnexpectedThrowable("Failed to start game", exception13));
            return;
        }
        try {
            try {
                var15 = System.currentTimeMillis();
                var3 = 0;
                if (true) ** GOTO lbl76
                do {
                    AxisAlignedBB.clearBoundingBoxPool();
                    Vec3D.initialize();
                    if (this.mcCanvas == null && Display.isCloseRequested()) {
                        this.shutdown();
                    }
                    if (this.isGamePaused && this.theWorld != null) {
                        var17 = this.timer.renderPartialTicks;
                        this.timer.updateTimer();
                        this.timer.renderPartialTicks = var17;
                    } else {
                        this.timer.updateTimer();
                    }
                    i17 = 0;
                    while (i17 < this.timer.elapsedTicks) {
                        ++this.ticksRan;
                        try {
                            this.runTick();
                        }
                        catch (MinecraftException minecraftException12) {
                            this.theWorld = null;
                            this.changeWorld1(null);
                            this.displayGuiScreen(new GuiConflictWarning());
                        }
                        ++i17;
                    }
                    this.checkGLError("Pre render");
                    this.sndManager.setListener(this.thePlayer, this.timer.renderPartialTicks);
                    GL11.glEnable(3553);
                    if (this.theWorld != null) {
                        while (this.theWorld.updatingLighting()) {
                        }
                    }
                    if (!this.skipRenderWorld) {
                        if (this.playerController != null) {
                            this.playerController.setPartialTime(this.timer.renderPartialTicks);
                        }
                        this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks);
                    }
                    if (!Display.isActive()) {
                        if (this.fullscreen) {
                            this.toggleFullscreen();
                        }
                        Thread.sleep(10L);
                    }
                    if (InputHandler.IsKeyDown(64)) {
                        this.displayDebugInfo();
                    } else {
                        this.prevFrameTime = System.nanoTime();
                    }
                    Thread.yield();
                    Display.update();
                    if (!(this.mcCanvas == null || this.fullscreen || this.mcCanvas.getWidth() == this.displayWidth && this.mcCanvas.getHeight() == this.displayHeight)) {
                        this.displayWidth = this.mcCanvas.getWidth();
                        this.displayHeight = this.mcCanvas.getHeight();
                        if (this.displayWidth <= 0) {
                            this.displayWidth = 1;
                        }
                        if (this.displayHeight <= 0) {
                            this.displayHeight = 1;
                        }
                        this.resize(this.displayWidth, this.displayHeight);
                    }
                    if (this.options.limitFramerate) {
                        Thread.sleep(5L);
                    }
                    this.checkGLError("Post render");
                    ++var3;
                    this.isGamePaused = this.isMultiplayerWorld() == false && this.currentScreen != null && this.currentScreen.doesGuiPauseGame() != false;
                    while (System.currentTimeMillis() >= var15 + 1000L) {
                        this.debug = String.valueOf(var3) + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                        WorldRenderer.chunksUpdated = 0;
                        var15 += 1000L;
                        var3 = 0;
                    }
lbl76:
                    // 2 sources

                    if (!this.running) return;
                } while (this.mcApplet == null || this.mcApplet.isActive());
                return;
            }
            catch (MinecraftError var15) {
                this.shutdownMinecraftApplet();
                return;
            }
            catch (Throwable throwable15) {
                this.theWorld = null;
                throwable15.printStackTrace();
                this.displayUnexpectedThrowable(new UnexpectedThrowable("Unexpected error", throwable15));
                this.shutdownMinecraftApplet();
                return;
            }
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    private void displayDebugInfo() {
        if (this.prevFrameTime == -1L) {
            this.prevFrameTime = System.nanoTime();
        }
        long var1 = System.nanoTime();
        Minecraft.frameTimes[Minecraft.numRecordedFrameTimes++ & Minecraft.frameTimes.length - 1] = var1 - this.prevFrameTime;
        this.prevFrameTime = var1;
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.displayWidth, this.displayHeight, 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
        GL11.glLineWidth(1.0f);
        GL11.glDisable(3553);
        Tessellator var3 = Tessellator.instance;
        var3.startDrawing(7);
        var3.setColorOpaque_I(0x20200000);
        var3.addVertex(0.0, this.displayHeight - 100, 0.0);
        var3.addVertex(0.0, this.displayHeight, 0.0);
        var3.addVertex(frameTimes.length, this.displayHeight, 0.0);
        var3.addVertex(frameTimes.length, this.displayHeight - 100, 0.0);
        var3.draw();
        long var4 = 0L;
        int var6 = 0;
        while (var6 < frameTimes.length) {
            var4 += frameTimes[var6];
            ++var6;
        }
        var6 = (int)(var4 / 200000L / (long)frameTimes.length);
        var3.startDrawing(7);
        var3.setColorOpaque_I(0x20400000);
        var3.addVertex(0.0, this.displayHeight - var6, 0.0);
        var3.addVertex(0.0, this.displayHeight, 0.0);
        var3.addVertex(frameTimes.length, this.displayHeight, 0.0);
        var3.addVertex(frameTimes.length, this.displayHeight - var6, 0.0);
        var3.draw();
        var3.startDrawing(1);
        int var7 = 0;
        while (var7 < frameTimes.length) {
            int var8 = (var7 - numRecordedFrameTimes & frameTimes.length - 1) * 255 / frameTimes.length;
            int var9 = var8 * var8 / 255;
            var9 = var9 * var9 / 255;
            int var10 = var9 * var9 / 255;
            var10 = var10 * var10 / 255;
            var3.setColorOpaque_I(-16777216 + var10 + var9 * 256 + var8 * 65536);
            long var11 = frameTimes[var7] / 200000L;
            var3.addVertex((float)var7 + 0.5f, (float)((long)this.displayHeight - var11) + 0.5f, 0.0);
            var3.addVertex((float)var7 + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            ++var7;
        }
        var3.draw();
        GL11.glEnable(3553);
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (Display.isActive() && !this.inGameHasFocus) {
            this.inGameHasFocus = true;
            this.mouseHelper.grabMouseCursor();
            this.displayGuiScreen(null);
            this.mouseTicksRan = this.ticksRan + 10000;
        }
    }

    public void setIngameNotInFocus() {
        if (this.inGameHasFocus) {
            if (this.thePlayer != null) {
                this.thePlayer.resetPlayerKeyState();
            }
            this.inGameHasFocus = false;
            this.mouseHelper.ungrabMouseCursor();
        }
    }

    public void displayInGameMenu() {
        if (this.currentScreen == null) {
            this.displayGuiScreen(new GuiIngameMenu());
        }
    }

    private void sendClickBlockToController(int button, boolean clicked) {
        if (!(this.playerController.isInTestMode || button == 0 && this.leftClickCounter > 0)) {
            if (clicked && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0 && button == 0) {
                int var3 = this.objectMouseOver.blockX;
                int var4 = this.objectMouseOver.blockY;
                int var5 = this.objectMouseOver.blockZ;
                this.playerController.sendBlockRemoving(var3, var4, var5, this.objectMouseOver.sideHit);
                this.effectRenderer.addBlockHitEffects(var3, var4, var5, this.objectMouseOver.sideHit);
            } else {
                this.playerController.resetBlockRemoving();
            }
        }
    }

    private void clickMouse(int button) {
        if (button != 0 || this.leftClickCounter <= 0) {
            ItemStack var91;
            int var3;
            if (button == 0) {
                this.thePlayer.swingItem();
            }
            if (this.objectMouseOver == null) {
                if (button == 0 && !(this.playerController instanceof PlayerControllerCreative)) {
                    this.leftClickCounter = 10;
                }
            } else if (this.objectMouseOver.typeOfHit == 1) {
                if (button == 0) {
                    this.thePlayer.attackEntity(this.objectMouseOver.entityHit);
                }
                if (button == 1) {
                    this.thePlayer.interactWithEntity(this.objectMouseOver.entityHit);
                }
            } else if (this.objectMouseOver.typeOfHit == 0) {
                int var9 = this.objectMouseOver.blockX;
                var3 = this.objectMouseOver.blockY;
                int var10 = this.objectMouseOver.blockZ;
                int var5 = this.objectMouseOver.sideHit;
                Block var6 = Block.blocksList[this.theWorld.getBlockId(var9, var3, var10)];
                if (button == 0) {
                    this.theWorld.extinguishFire(var9, var3, var10, this.objectMouseOver.sideHit);
                    if (var6 != Block.bedrock || this.thePlayer.unusedMiningCooldown >= 100) {
                        this.playerController.clickBlock(var9, var3, var10, this.objectMouseOver.sideHit);
                    }
                } else {
                    int var8;
                    ItemStack var7 = this.thePlayer.inventory.getCurrentItem();
                    int n = var8 = var7 != null ? var7.stackSize : 0;
                    if (this.playerController.onPlayerRightClick(this.thePlayer, this.theWorld, var7, var9, var3, var10, var5)) {
                        this.thePlayer.swingItem();
                    }
                    if (var7 == null) {
                        return;
                    }
                    if (var7.stackSize == 0) {
                        this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                    } else if (var7.stackSize != var8) {
                        this.entityRenderer.itemRenderer.resetEquippedProgress();
                    }
                }
            }
            if (button == 1 && (var91 = this.thePlayer.inventory.getCurrentItem()) != null) {
                var3 = var91.stackSize;
                ItemStack var101 = var91.useItemRightClick(this.theWorld, this.thePlayer);
                if (var101 != var91 || var101 != null && var101.stackSize != var3) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = var101;
                    this.entityRenderer.itemRenderer.resetEquippedProgress2();
                    if (var101.stackSize == 0) {
                        this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                    }
                }
            }
        }
    }

    public void toggleFullscreen() {
        try {
            this.fullscreen = !this.fullscreen;
            System.out.println("Toggle fullscreen!");
            if (this.fullscreen) {
                Display.setDisplayMode(Display.getDesktopDisplayMode());
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.mcCanvas != null) {
                    this.displayWidth = this.mcCanvas.getWidth();
                    this.displayHeight = this.mcCanvas.getHeight();
                } else {
                    this.displayWidth = this.tempDisplayWidth;
                    this.displayHeight = this.tempDisplayHeight;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
                Display.setDisplayMode(new DisplayMode(this.tempDisplayWidth, this.tempDisplayHeight));
            }
            this.setIngameNotInFocus();
            Display.setFullscreen(this.fullscreen);
            Display.update();
            Thread.sleep(1000L);
            if (this.fullscreen) {
                this.setIngameFocus();
            }
            if (this.currentScreen != null) {
                this.setIngameNotInFocus();
                this.resize(this.displayWidth, this.displayHeight);
            }
            System.out.println("Size: " + this.displayWidth + ", " + this.displayHeight);
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    private void resize(int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.displayWidth = width;
        this.displayHeight = height;
        if (this.currentScreen != null) {
            ScaledResolution var3 = new ScaledResolution(width, height);
            int var4 = var3.getScaledWidth();
            int var5 = var3.getScaledHeight();
            this.currentScreen.setWorldAndResolution(this, var4, var5);
        }
    }

    private void clickMiddleMouseButton() {
        if (this.objectMouseOver != null) {
            int var1 = this.theWorld.getBlockId(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
            if (var1 == Block.grass.blockID) {
                var1 = Block.dirt.blockID;
            }
            if (var1 == Block.stairDouble.blockID) {
                var1 = Block.stairSingle.blockID;
            }
            if (var1 == Block.bedrock.blockID) {
                var1 = Block.stone.blockID;
            }
            this.thePlayer.inventory.setCurrentItem(var1, this.playerController instanceof PlayerControllerCreative);
        }
    }

    public void runTick() {
        this.ingameGUI.updateTick();
        this.entityRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null) {
            this.thePlayer.onPlayerUpdate();
        }
        if (!this.isGamePaused && this.theWorld != null) {
            this.playerController.onUpdate();
        }
        GL11.glBindTexture(3553, this.renderEngine.getTexture("/terrain.png"));
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null && this.thePlayer.health <= 0) {
            this.displayGuiScreen(null);
        }
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.allowUserInput) {
            block0: while (true) {
                if (!InputHandler.NextEvent()) {
                    if (this.leftClickCounter > 0) {
                        --this.leftClickCounter;
                    }
                    while (true) {
                        if (!InputHandler.NextKBEvent()) {
                            if (this.currentScreen == null) {
                                if (InputHandler.InputMouseAction(0) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                                    this.clickMouse(0);
                                    this.mouseTicksRan = this.ticksRan;
                                }
                                if (InputHandler.InputMouseAction(1) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                                    this.clickMouse(1);
                                    this.mouseTicksRan = this.ticksRan;
                                }
                            }
                            this.sendClickBlockToController(0, this.currentScreen == null && InputHandler.InputMouseAction(0) && this.inGameHasFocus);
                            break block0;
                        }
                        this.thePlayer.handleKeyPress(InputHandler.GetKBEventKey(), InputHandler.GetKBEventKeyState());
                        if (!InputHandler.GetKBEventKeyState()) continue;
                        if (InputHandler.GetKBEventKey() == 87) {
                            this.toggleFullscreen();
                            continue;
                        }
                        if (this.currentScreen != null) {
                            this.currentScreen.handleKeyboardInput();
                        } else {
                            if (InputHandler.GetKBEventKey() == 1) {
                                this.displayInGameMenu();
                            }
                            if (InputHandler.GetKBEventKey() == 31 && InputHandler.IsKeyDown(61)) {
                                this.t();
                            }
                            if (InputHandler.GetKBEventKey() == 63) {
                                boolean bl = this.options.thirdPersonView = !this.options.thirdPersonView;
                            }
                            if (InputHandler.GetKBEventKey() == this.options.keyBindInventory.keyCode) {
                                this.displayGuiScreen(new GuiInventory(this.thePlayer.inventory, this.thePlayer.inventory.craftingInventory));
                            }
                            if (InputHandler.GetKBEventKey() == this.options.keyBindDrop.keyCode) {
                                this.thePlayer.dropPlayerItemWithRandomChoice(this.thePlayer.inventory.decrStackSize(this.thePlayer.inventory.currentItem, 1), false);
                            }
                            if (this.isMultiplayerWorld() && InputHandler.GetKBEventKey() == this.options.keyBindChat.keyCode) {
                                this.displayGuiScreen(new GuiChat());
                            }
                        }
                        int i4 = 0;
                        while (i4 < 9) {
                            if (InputHandler.GetKBEventKey() == 2 + i4) {
                                this.thePlayer.inventory.currentItem = i4;
                            }
                            ++i4;
                        }
                        if (InputHandler.GetKBEventKey() != this.options.keyBindToggleFog.keyCode) continue;
                        this.options.setOptionValue(4, !InputHandler.IsKeyDown(42) && !InputHandler.IsKeyDown(54) ? 1 : -1);
                    }
                }
                long var4 = System.currentTimeMillis() - this.systemTime;
                if (var4 > 200L) continue;
                int var3 = InputHandler.GetDWheel();
                if (var3 != 0) {
                    this.thePlayer.inventory.changeCurrentItem(var3);
                }
                if (this.currentScreen == null) {
                    if (!this.inGameHasFocus && InputHandler.GetEventButtonState()) {
                        this.setIngameFocus();
                        continue;
                    }
                    if (InputHandler.GetEventButton() == 0 && InputHandler.GetEventButtonState()) {
                        this.clickMouse(0);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (InputHandler.GetEventButton() == 1 && InputHandler.GetEventButtonState()) {
                        this.clickMouse(1);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (InputHandler.GetEventButton() != 2 || !InputHandler.GetEventButtonState()) continue;
                    this.clickMiddleMouseButton();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.handleMouseInput();
            }
        }
        if (this.theWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.theWorld.joinEntityInSurroundings(this.thePlayer);
                }
            }
            this.theWorld.difficultySetting = this.options.difficulty;
            if (!this.isGamePaused) {
                this.entityRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                this.theWorld.updateEntities();
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                this.theWorld.tick();
            }
            if (!this.isGamePaused && this.theWorld != null) {
                this.theWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        this.systemTime = System.currentTimeMillis();
    }

    private void t() {
        System.out.println("FORCING RELOAD!");
        this.sndManager = new SoundManager();
        this.sndManager.loadSoundSettings(this.options);
        this.downloadResourcesThread.closeMinecraft();
    }

    public boolean isMultiplayerWorld() {
        return this.theWorld != null && this.theWorld.multiplayerWorld;
    }

    public void startWorld(String worldName) {
        this.changeWorld1(null);
        System.gc();
        World var2 = new World(new File(Minecraft.getMinecraftDir(), "saves"), worldName);
        if (var2.isNewWorld) {
            this.changeWorld(var2, "Generating level");
        } else {
            this.changeWorld(var2, "Loading level");
        }
    }

    public void changeWorld1(World world) {
        this.changeWorld(world, "");
    }

    public void changeWorld(World world, String title) {
        this.sndManager.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.theWorld != null) {
            this.theWorld.saveWorldIndirectly(this.loadingScreen);
        }
        this.theWorld = world;
        if (world != null) {
            this.playerController.onWorldChange(world);
            world.fontRenderer = this.fontRenderer;
            if (!this.isMultiplayerWorld()) {
                this.thePlayer = (EntityPlayerSP)world.createDebugPlayer(EntityPlayerSP.class);
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (world != null) {
                    world.spawnEntityInWorld(this.thePlayer);
                }
            }
            if (!world.multiplayerWorld) {
                this.preloadWorld(title);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.movementInput = new MovementInputFromOptions(this.options);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.onRespawn(this.thePlayer);
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadingScreen);
            }
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
    }

    private void preloadWorld(String title) {
        this.loadingScreen.resetProgressAndMessage(title);
        this.loadingScreen.displayLoadingString("Building terrain");
        int var2 = 128;
        int var3 = 0;
        int var4 = var2 * 2 / 16 + 1;
        var4 *= var4;
        int var9 = -var2;
        while (var9 <= var2) {
            int var6 = this.theWorld.spawnX;
            int var7 = this.theWorld.spawnZ;
            if (this.thePlayer != null) {
                var6 = (int)this.thePlayer.posX;
                var7 = (int)this.thePlayer.posZ;
            }
            int var8 = -var2;
            while (var8 <= var2) {
                this.loadingScreen.setLoadingProgress(var3++ * 100 / var4);
                this.theWorld.getBlockId(var6 + var9, 64, var7 + var8);
                while (this.theWorld.updatingLighting()) {
                }
                var8 += 16;
            }
            var9 += 16;
        }
        this.loadingScreen.displayLoadingString("Simulating world for a bit");
        boolean z9 = true;
        this.theWorld.dropOldChunks();
    }

    public void installResource(String name, File file) {
        int var3 = name.indexOf("/");
        String var4 = name.substring(0, var3);
        name = name.substring(var3 + 1);
        if (var4.equalsIgnoreCase("sound")) {
            this.sndManager.addSound(name, file);
        } else if (var4.equalsIgnoreCase("newsound")) {
            this.sndManager.addSound(name, file);
        } else if (var4.equalsIgnoreCase("streaming")) {
            this.sndManager.addStreaming(name, file);
        } else if (var4.equalsIgnoreCase("music")) {
            this.sndManager.addMusic(name, file);
        } else if (var4.equalsIgnoreCase("newmusic")) {
            this.sndManager.addMusic(name, file);
        }
    }

    public OpenGlCapsChecker getOpenGlCapsChecker() {
        return this.glCapabilities;
    }

    public String debugInfoRenders() {
        return this.renderGlobal.getDebugInfoRenders();
    }

    public String getEntityDebug() {
        return this.renderGlobal.getDebugInfoEntities();
    }

    public String debugInfoEntities() {
        return "P: " + this.effectRenderer.getStatistics() + ". T: " + this.theWorld.getDebugLoadedEntities();
    }

    public void respawn() {
        this.theWorld.setSpawnLocation();
        if (this.thePlayer != null) {
            this.theWorld.setEntityDead(this.thePlayer);
        }
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.theWorld);
        this.thePlayer.preparePlayerToSpawn();
        this.playerController.flipPlayer(this.thePlayer);
        this.theWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.movementInput = new MovementInputFromOptions(this.options);
        this.playerController.onRespawn(this.thePlayer);
        this.preloadWorld("Respawning");
    }

    public static void startMainThread(String username, String sessionId) {
        Minecraft.startMainThread(username, sessionId, null);
    }

    public static void startMainThread(String username, String sessionId, String server) {
        boolean var3 = false;
        Frame var5 = new Frame("Minecraft");
        Canvas var6 = new Canvas();
        var5.setLayout(new BorderLayout());
        var5.add((Component)var6, "Center");
        var6.setPreferredSize(new Dimension(854, 480));
        var5.pack();
        var5.setLocationRelativeTo(null);
        MinecraftImpl var7 = new MinecraftImpl(var5, var6, null, 854, 480, var3, var5);
        Thread var8 = new Thread((Runnable)var7, "Minecraft main thread");
        var8.setPriority(10);
        var7.appletMode = false;
        var7.minecraftUri = "www.minecraft.net";
        var7.session = username != null && sessionId != null ? new Session(username, sessionId) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        if (server != null) {
            String[] var9 = server.split(":");
            var7.setServer(var9[0], Integer.parseInt(var9[1]));
        }
        var5.setVisible(true);
        var5.addWindowListener(new GameWindowListener(var7, var8));
        var8.start();
    }

    public static void main(String[] args) {
        String var1 = "Player" + System.currentTimeMillis() % 1000L;
        if (args.length > 0) {
            var1 = args[0];
        }
        String var2 = "-";
        if (args.length > 1) {
            var2 = args[1];
        }
        Minecraft.startMainThread(var1, var2);
    }

    static final class SyntheticClass_1 {
        public static final int[] $SwitchMap$net$minecraft$src$EnumOS = new int[EnumOS.values().length];

        static {
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOS[EnumOS.linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOS[EnumOS.solaris.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOS[EnumOS.windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$net$minecraft$src$EnumOS[EnumOS.macos.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        SyntheticClass_1() {
        }
    }
}

