/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NondirectBufferWrapper {
    private static final int INITIAL_BUFFER_SIZE = 1;
    private static final ThreadLocal thread_buffer = new ThreadLocal(){

        protected Object initialValue() {
            return new CachedBuffers(1);
        }
    };

    public static ByteBuffer wrapDirect(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(buffer);
        }
        return buffer;
    }

    private static ByteBuffer doWrap(ByteBuffer buffer) {
        ByteBuffer direct_buffer = NondirectBufferWrapper.lookupBuffer(buffer);
        direct_buffer.clear();
        int saved_position = buffer.position();
        direct_buffer.put(buffer);
        buffer.position(saved_position);
        direct_buffer.flip();
        return direct_buffer;
    }

    private static ByteBuffer lookupBuffer(ByteBuffer buffer) {
        return NondirectBufferWrapper.getCachedBuffers(buffer.remaining()).byte_buffer;
    }

    private static CachedBuffers getCachedBuffers(int minimum_byte_size) {
        CachedBuffers buffers = (CachedBuffers)thread_buffer.get();
        int current_byte_size = buffers.byte_buffer.capacity();
        if (minimum_byte_size > current_byte_size) {
            buffers = new CachedBuffers(minimum_byte_size);
            thread_buffer.set(buffers);
        }
        return buffers;
    }

    private static final class CachedBuffers {
        private final ByteBuffer byte_buffer;

        private CachedBuffers(int size) {
            this.byte_buffer = ByteBuffer.allocateDirect(size);
            this.byte_buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

