/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold", "obsidian"};

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
    }

    protected boolean shouldRenderPass(EntityPlayer var1, int var2) {
        Item var4;
        ItemStack var3 = var1.inventory.armorItemInSlot(3 - var2);
        if (var3 != null && (var4 = var3.getItem()) instanceof ItemArmor) {
            ItemArmor var5 = (ItemArmor)var4;
            this.loadTexture("/armor/" + armorFilenamePrefix[var5.renderIndex] + "_" + (var2 == 2 ? 2 : 1) + ".png");
            ModelBiped var6 = var2 == 2 ? this.modelArmor : this.modelArmorChestplate;
            var6.bipedHead.showModel = var2 == 0;
            var6.bipedHeadwear.showModel = var2 == 0;
            var6.bipedBody.showModel = var2 == 1 || var2 == 2;
            var6.bipedRightArm.showModel = var2 == 1;
            var6.bipedLeftArm.showModel = var2 == 1;
            var6.bipedRightLeg.showModel = var2 == 2 || var2 == 3;
            var6.bipedLeftLeg.showModel = var2 == 2 || var2 == 3;
            this.setRenderPassModel(var6);
            return true;
        }
        return false;
    }

    public void doRender(EntityPlayer var1, double var2, double var4, double var6, float var8, float var9) {
        ItemStack var10 = var1.inventory.getCurrentItem();
        ModelBiped var11 = (ModelBiped)this.mainModel;
        var11.heldItemRight = var10 != null;
        super.doRender(var1, var2, var4 - (double)var1.yOffset, var6, var8, var9);
        var11.heldItemRight = false;
        FontRenderer var12 = this.getFontRendererFromRenderManager();
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        if (!var1.username.startsWith("\u0107") && !var1.username.startsWith("\u015b")) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)var2 + 0.0f, (float)var4 + 2.3f, (float)var6);
            GL11.glNormal3f(0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-this.renderManager.playerViewY, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.renderManager.playerViewX, 1.0f, 0.0f, 0.0f);
            float var15 = var1.getDistanceToEntity(this.renderManager.player);
            var14 = (float)((double)var14 * (Math.sqrt(var15) / 2.0));
            GL11.glScalef(-var14, -var14, var14);
            String var16 = var1.username;
            GL11.glDisable(2896);
            GL11.glDepthMask(false);
            GL11.glDisable(2929);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            Tessellator var17 = Tessellator.instance;
            GL11.glDisable(3553);
            var17.startDrawingQuads();
            int var18 = var12.getStringWidth(var16) / 2;
            var17.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
            var17.addVertex(-var18 - 1, -1.0, 0.0);
            var17.addVertex(-var18 - 1, 8.0, 0.0);
            var17.addVertex(var18 + 1, 8.0, 0.0);
            var17.addVertex(var18 + 1, -1.0, 0.0);
            var17.draw();
            GL11.glEnable(3553);
            var12.drawString(var16, -var12.getStringWidth(var16) / 2, 0, 0x20FFFFFF);
            GL11.glEnable(2929);
            GL11.glDepthMask(true);
            var12.drawString(var16, -var12.getStringWidth(var16) / 2, 0, -1);
            GL11.glEnable(2896);
            GL11.glDisable(3042);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glPopMatrix();
        }
    }

    protected void renderEquippedItems(EntityPlayer var1, float var2) {
        ItemStack var3 = var1.inventory.getCurrentItem();
        if (var3 != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.renderWithRotation(0.0625f);
            GL11.glTranslatef(-0.0625f, 0.4375f, 0.0625f);
            if (var3.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var3.itemID].getRenderType())) {
                float var4 = 0.5f;
                GL11.glTranslatef(0.0f, 0.1875f, -0.3125f);
                GL11.glRotatef(20.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
                GL11.glScalef(var4 *= 0.75f, -var4, var4);
            } else if (Item.itemsList[var3.itemID].isFull3D()) {
                float var4 = 0.625f;
                GL11.glTranslatef(0.0f, 0.1875f, 0.0f);
                GL11.glScalef(var4, -var4, var4);
                GL11.glRotatef(-100.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
            } else {
                float var4 = 0.375f;
                GL11.glTranslatef(0.25f, 0.1875f, -0.1875f);
                GL11.glScalef(var4, var4, var4);
                GL11.glRotatef(60.0f, 0.0f, 0.0f, 1.0f);
                GL11.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(20.0f, 0.0f, 0.0f, 1.0f);
            }
            this.renderManager.itemRenderer.renderItem(var3);
            GL11.glPopMatrix();
        }
    }

    protected void preRenderCallback(EntityPlayer var1, float var2) {
        float var3 = 0.9375f;
        GL11.glScalef(var3, var3, var3);
    }

    public void drawFirstPersonHand() {
        this.modelBipedMain.swingProgress = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    @Override
    protected void preRenderCallback(EntityLiving entityLiving1, float f2) {
        this.preRenderCallback((EntityPlayer)entityLiving1, f2);
    }

    @Override
    protected boolean shouldRenderPass(EntityLiving entityLiving1, int i2) {
        return this.shouldRenderPass((EntityPlayer)entityLiving1, i2);
    }

    @Override
    protected void renderEquippedItems(EntityLiving entityLiving1, float f2) {
        this.renderEquippedItems((EntityPlayer)entityLiving1, f2);
    }

    @Override
    public void doRender(EntityLiving entityLiving1, double d2, double d4, double d6, float f8, float f9) {
        this.doRender((EntityPlayer)entityLiving1, d2, d4, d6, f8, f9);
    }

    @Override
    public void doRender(Entity entity1, double d2, double d4, double d6, float f8, float f9) {
        this.doRender((EntityPlayer)entity1, d2, d4, d6, f8, f9);
    }
}

