/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelMinecart;
import net.minecraft.src.Render;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.Vec3D;
import org.lwjgl.opengl.GL11;

public class RenderMinecart
extends Render {
    protected ModelBase modelMinecart;

    public RenderMinecart() {
        this.shadowSize = 0.5f;
        this.modelMinecart = new ModelMinecart();
    }

    public void doRender(EntityMinecart var1, double var2, double var4, double var6, float var8, float var9) {
        GL11.glPushMatrix();
        double var10 = var1.lastTickPosX + (var1.posX - var1.lastTickPosX) * (double)var9;
        double var12 = var1.lastTickPosY + (var1.posY - var1.lastTickPosY) * (double)var9;
        double var14 = var1.lastTickPosZ + (var1.posZ - var1.lastTickPosZ) * (double)var9;
        double var16 = 0.3f;
        Vec3D var18 = var1.getPos(var10, var12, var14);
        float var19 = var1.prevRotationPitch + (var1.rotationPitch - var1.prevRotationPitch) * var9;
        if (var18 != null) {
            Vec3D var23 = var1.getPosOffset(var10, var12, var14, var16);
            Vec3D var24 = var1.getPosOffset(var10, var12, var14, -var16);
            if (var23 == null) {
                var23 = var18;
            }
            if (var24 == null) {
                var24 = var18;
            }
            var2 += var18.xCoord - var10;
            var4 += (var23.yCoord + var24.yCoord) / 2.0 - var12;
            var6 += var18.zCoord - var14;
            Vec3D var25 = var24.addVector(-var23.xCoord, -var23.yCoord, -var23.zCoord);
            if (var25.lengthVector() != 0.0) {
                var25 = var25.normalize();
                var8 = (float)(Math.atan2(var25.zCoord, var25.xCoord) * 180.0 / Math.PI);
                var19 = (float)(Math.atan(var25.yCoord) * 73.0);
            }
        }
        GL11.glTranslatef((float)var2, (float)var4, (float)var6);
        GL11.glRotatef(180.0f - var8, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-var19, 0.0f, 0.0f, 1.0f);
        float var231 = (float)var1.timeSinceHit - var9;
        float var241 = (float)var1.damageTaken - var9;
        if (var241 < 0.0f) {
            var241 = 0.0f;
        }
        if (var231 > 0.0f) {
            GL11.glRotatef(MathHelper.sin(var231) * var231 * var241 / 10.0f * (float)var1.forwardDirection, 1.0f, 0.0f, 0.0f);
        }
        if (var1.minecartType != 0) {
            this.loadTexture("/terrain.png");
            float var251 = 0.75f;
            GL11.glScalef(var251, var251, var251);
            GL11.glTranslatef(0.0f, 0.3125f, 0.0f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            if (var1.minecartType == 1) {
                new RenderBlocks().renderBlockOnInventory(Block.chest);
            } else if (var1.minecartType == 2) {
                new RenderBlocks().renderBlockOnInventory(Block.stoneOvenIdle);
            }
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, -0.3125f, 0.0f);
            GL11.glScalef(1.0f / var251, 1.0f / var251, 1.0f / var251);
        }
        this.loadTexture("/item/cart.png");
        GL11.glScalef(-1.0f, -1.0f, 1.0f);
        this.modelMinecart.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Entity entity1, double d2, double d4, double d6, float f8, float f9) {
        this.doRender((EntityMinecart)entity1, d2, d4, d6, f8, f9);
    }
}

