/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityGiantZombie;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GameSettings;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.MobGiant;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.ModelChicken;
import net.minecraft.src.ModelCow;
import net.minecraft.src.ModelPig;
import net.minecraft.src.ModelSheep;
import net.minecraft.src.ModelSheepFur;
import net.minecraft.src.ModelSkeleton;
import net.minecraft.src.ModelSlime;
import net.minecraft.src.ModelZombie;
import net.minecraft.src.Render;
import net.minecraft.src.RenderArrow;
import net.minecraft.src.RenderBoat;
import net.minecraft.src.RenderChicken;
import net.minecraft.src.RenderCow;
import net.minecraft.src.RenderCreeper;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderEntity;
import net.minecraft.src.RenderFallingSand;
import net.minecraft.src.RenderGiant;
import net.minecraft.src.RenderGiantZombie;
import net.minecraft.src.RenderItem;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.RenderMinecart;
import net.minecraft.src.RenderPainting;
import net.minecraft.src.RenderPig;
import net.minecraft.src.RenderPlayer;
import net.minecraft.src.RenderSheep;
import net.minecraft.src.RenderSlime;
import net.minecraft.src.RenderSnowball;
import net.minecraft.src.RenderSpider;
import net.minecraft.src.RenderTNTPrimed;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class RenderManager {
    private Map entityRenderMap = new HashMap<Class<EntitySpider>, RenderSpider>();
    public static RenderManager instance = new RenderManager();
    private FontRenderer fontRenderer;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public RenderEngine renderEngine;
    public ItemRenderer itemRenderer;
    public World worldObj;
    public EntityPlayer player;
    public float playerViewY;
    public float playerViewX;
    public GameSettings options;
    public double viewerPosX;
    public double viewerPosY;
    public double viewerPosZ;

    private RenderManager() {
        this.entityRenderMap.put(EntitySpider.class, new RenderSpider());
        this.entityRenderMap.put(EntityPig.class, new RenderPig(new ModelPig(), new ModelPig(0.5f), 0.7f));
        this.entityRenderMap.put(EntitySheep.class, new RenderSheep(new ModelSheep(), new ModelSheepFur(), 0.7f));
        this.entityRenderMap.put(EntityCow.class, new RenderCow(new ModelCow(), 0.7f));
        this.entityRenderMap.put(EntityChicken.class, new RenderChicken(new ModelChicken(), 0.3f));
        this.entityRenderMap.put(EntityCreeper.class, new RenderCreeper());
        this.entityRenderMap.put(EntitySkeleton.class, new RenderLiving(new ModelSkeleton(), 0.5f));
        this.entityRenderMap.put(EntityZombie.class, new RenderLiving(new ModelZombie(), 0.5f));
        this.entityRenderMap.put(EntitySlime.class, new RenderSlime(new ModelSlime(16), new ModelSlime(0), 0.25f));
        this.entityRenderMap.put(EntityPlayer.class, new RenderPlayer());
        this.entityRenderMap.put(EntityGiantZombie.class, new RenderGiantZombie(new ModelZombie(), 0.5f, 6.0f));
        this.entityRenderMap.put(EntityLiving.class, new RenderLiving(new ModelBiped(), 0.5f));
        this.entityRenderMap.put(Entity.class, new RenderEntity());
        this.entityRenderMap.put(EntityPainting.class, new RenderPainting());
        this.entityRenderMap.put(EntityArrow.class, new RenderArrow());
        this.entityRenderMap.put(EntitySnowball.class, new RenderSnowball());
        this.entityRenderMap.put(EntityItem.class, new RenderItem());
        this.entityRenderMap.put(EntityTNTPrimed.class, new RenderTNTPrimed());
        this.entityRenderMap.put(EntityFallingSand.class, new RenderFallingSand());
        this.entityRenderMap.put(EntityMinecart.class, new RenderMinecart());
        this.entityRenderMap.put(EntityBoat.class, new RenderBoat());
        this.entityRenderMap.put(MobGiant.class, new RenderGiant(new ModelZombie(), 0.5f, 6.0f));
        Iterator var1 = this.entityRenderMap.values().iterator();
        while (var1.hasNext()) {
            ((Render)var1.next()).setRenderManager(this);
        }
    }

    public Render getEntityClassRenderObject(Class entityClass) {
        Render var2 = (Render)this.entityRenderMap.get(entityClass);
        if (var2 == null && entityClass != Entity.class) {
            var2 = this.getEntityClassRenderObject(entityClass.getSuperclass());
            this.entityRenderMap.put(entityClass, var2);
        }
        return var2;
    }

    public Render getEntityRenderObject(Entity entity) {
        return this.getEntityClassRenderObject(entity.getClass());
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderEngine, FontRenderer fontRenderer, EntityPlayer entityPlayer, GameSettings gameSettings, float renderPartialTick) {
        this.worldObj = world;
        this.renderEngine = renderEngine;
        this.options = gameSettings;
        this.player = entityPlayer;
        this.fontRenderer = fontRenderer;
        this.playerViewY = entityPlayer.prevRotationYaw + (entityPlayer.rotationYaw - entityPlayer.prevRotationYaw) * renderPartialTick;
        this.playerViewX = entityPlayer.prevRotationPitch + (entityPlayer.rotationPitch - entityPlayer.prevRotationPitch) * renderPartialTick;
        this.viewerPosX = entityPlayer.lastTickPosX + (entityPlayer.posX - entityPlayer.lastTickPosX) * (double)renderPartialTick;
        this.viewerPosY = entityPlayer.lastTickPosY + (entityPlayer.posY - entityPlayer.lastTickPosY) * (double)renderPartialTick;
        this.viewerPosZ = entityPlayer.lastTickPosZ + (entityPlayer.posZ - entityPlayer.lastTickPosZ) * (double)renderPartialTick;
    }

    public void renderEntity(Entity entity, float renderPartialTick) {
        double var3 = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)renderPartialTick;
        double var5 = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)renderPartialTick;
        double var7 = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)renderPartialTick;
        float var9 = entity.prevRotationYaw + (entity.rotationYaw - entity.prevRotationYaw) * renderPartialTick;
        float var10 = entity.getBrightness(renderPartialTick);
        GL11.glColor3f(var10, var10, var10);
        this.renderEntityWithPosYaw(entity, var3 - renderPosX, var5 - renderPosY, var7 - renderPosZ, var9, renderPartialTick);
    }

    public void renderEntityWithPosYaw(Entity entity, double x, double y, double z, float yaw, float pitch) {
        Render var10 = this.getEntityRenderObject(entity);
        if (var10 != null) {
            var10.doRender(entity, x, y, z, yaw, pitch);
            var10.doRenderShadowAndFire(entity, x, y, z, yaw, pitch);
        }
    }

    public void set(World world) {
        this.worldObj = world;
    }

    public double getDistanceToCamera(double x, double y, double z) {
        double var7 = x - this.viewerPosX;
        double var9 = y - this.viewerPosY;
        double var11 = z - this.viewerPosZ;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

