/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.Render;
import org.lwjgl.opengl.GL11;

public class RenderLiving
extends Render {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;

    public RenderLiving(ModelBase var1, float var2) {
        this.mainModel = var1;
        this.shadowSize = var2;
    }

    public void setRenderPassModel(ModelBase var1) {
        this.renderPassModel = var1;
    }

    public void doRender(EntityLiving var1, double var2, double var4, double var6, float var8, float var9) {
        GL11.glPushMatrix();
        GL11.glDisable(2884);
        this.mainModel.swingProgress = this.renderSwingProgress(var1, var9);
        boolean bl = this.mainModel.isRiding = var1.ridingEntity != null;
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        try {
            float var14;
            float var24 = var1.prevRenderYawOffset + (var1.renderYawOffset - var1.prevRenderYawOffset) * var9;
            float var11 = var1.prevRotationYaw + (var1.rotationYaw - var1.prevRotationYaw) * var9;
            float var12 = var1.prevRotationPitch + (var1.rotationPitch - var1.prevRotationPitch) * var9;
            GL11.glTranslatef((float)var2, (float)var4, (float)var6);
            float var13 = this.handleRotationFloat(var1, var9);
            GL11.glRotatef(180.0f - var24, 0.0f, 1.0f, 0.0f);
            if (var1.deathTime > 0) {
                var14 = ((float)var1.deathTime + var9 - 1.0f) / 20.0f * 1.6f;
                if ((var14 = MathHelper.sqrt_float(var14)) > 1.0f) {
                    var14 = 1.0f;
                }
                GL11.glRotatef(var14 * this.getDeathMaxRotation(var1), 0.0f, 0.0f, 1.0f);
            }
            var14 = 0.0625f;
            GL11.glEnable(32826);
            GL11.glScalef(-1.0f, -1.0f, 1.0f);
            this.preRenderCallback(var1, var9);
            GL11.glTranslatef(0.0f, -24.0f * var14 - 0.0078125f, 0.0f);
            float var15 = var1.prevLimbYaw + (var1.limbYaw - var1.prevLimbYaw) * var9;
            float var16 = var1.limbSwing - var1.limbYaw * (1.0f - var9);
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            this.loadDownloadableImageTexture(var1.skinUrl, var1.getTexture());
            GL11.glEnable(3008);
            this.mainModel.render(var16, var15, var13, var11 - var24, var12, var14);
            int var25 = 0;
            while (var25 < 4) {
                if (this.shouldRenderPass(var1, var25)) {
                    this.renderPassModel.render(var16, var15, var13, var11 - var24, var12, var14);
                    GL11.glDisable(3042);
                    GL11.glEnable(3008);
                }
                ++var25;
            }
            this.renderEquippedItems(var1, var9);
            float f25 = var1.getBrightness(var9);
            int var18 = this.getColorMultiplier(var1, f25, var9);
            if ((var18 >> 24 & 0xFF) > 0 || var1.hurtTime > 0 || var1.deathTime > 0) {
                GL11.glDisable(3553);
                GL11.glDisable(3008);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                GL11.glDepthFunc(514);
                if (var1.hurtTime > 0 || var1.deathTime > 0) {
                    GL11.glColor4f(f25, 0.0f, 0.0f, 0.4f);
                    this.mainModel.render(var16, var15, var13, var11 - var24, var12, var14);
                    int var26 = 0;
                    while (var26 < 4) {
                        if (this.shouldRenderPass(var1, var26)) {
                            GL11.glColor4f(f25, 0.0f, 0.0f, 0.4f);
                            this.renderPassModel.render(var16, var15, var13, var11 - var24, var12, var14);
                        }
                        ++var26;
                    }
                }
                if ((var18 >> 24 & 0xFF) > 0) {
                    float f26 = (float)(var18 >> 16 & 0xFF) / 255.0f;
                    float var20 = (float)(var18 >> 8 & 0xFF) / 255.0f;
                    float var21 = (float)(var18 & 0xFF) / 255.0f;
                    float var22 = (float)(var18 >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f(f26, var20, var21, var22);
                    this.mainModel.render(var16, var15, var13, var11 - var24, var12, var14);
                    int var23 = 0;
                    while (var23 < 4) {
                        if (this.shouldRenderPass(var1, var23)) {
                            GL11.glColor4f(f26, var20, var21, var22);
                            this.renderPassModel.render(var16, var15, var13, var11 - var24, var12, var14);
                        }
                        ++var23;
                    }
                }
                GL11.glDepthFunc(515);
                GL11.glDisable(3042);
                GL11.glEnable(3008);
                GL11.glEnable(3553);
            }
            GL11.glDisable(32826);
        }
        catch (Exception exception24) {
            exception24.printStackTrace();
        }
        GL11.glEnable(2884);
        GL11.glPopMatrix();
    }

    protected float renderSwingProgress(EntityLiving var1, float var2) {
        return var1.getSwingProgress(var2);
    }

    protected float handleRotationFloat(EntityLiving var1, float var2) {
        return (float)var1.ticksExisted + var2;
    }

    protected void renderEquippedItems(EntityLiving var1, float var2) {
    }

    protected boolean shouldRenderPass(EntityLiving var1, int var2) {
        return false;
    }

    protected float getDeathMaxRotation(EntityLiving var1) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLiving var1, float var2, float var3) {
        return 0;
    }

    protected void preRenderCallback(EntityLiving var1, float var2) {
    }

    @Override
    public void doRender(Entity entity1, double d2, double d4, double d6, float f8, float f9) {
        this.doRender((EntityLiving)entity1, d2, d4, d6, f8, f9);
    }
}

