/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet24MobSpawn
extends Packet {
    public int entityId;
    public byte type;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;

    public Packet24MobSpawn() {
    }

    public Packet24MobSpawn(EntityLiving entityLiving) {
        this.entityId = entityLiving.entityID;
        this.type = (byte)EntityList.getEntityID(entityLiving);
        this.xPosition = MathHelper.floor_double(entityLiving.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entityLiving.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entityLiving.posZ * 32.0);
        this.yaw = (byte)(entityLiving.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(entityLiving.rotationPitch * 256.0f / 360.0f);
    }

    @Override
    public void readPacketData(DataInputStream var1) throws IOException {
        this.entityId = var1.readInt();
        this.type = var1.readByte();
        this.xPosition = var1.readInt();
        this.yPosition = var1.readInt();
        this.zPosition = var1.readInt();
        this.yaw = var1.readByte();
        this.pitch = var1.readByte();
    }

    @Override
    public void writePacket(DataOutputStream var1) throws IOException {
        var1.writeInt(this.entityId);
        var1.writeByte(this.type);
        var1.writeInt(this.xPosition);
        var1.writeInt(this.yPosition);
        var1.writeInt(this.zPosition);
        var1.writeByte(this.yaw);
        var1.writeByte(this.pitch);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleMobSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 19;
    }
}

