/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.NoiseGenerator;
import net.minecraft.src.NoiseGeneratorPerlin;

public class NoiseGeneratorOctaves
extends NoiseGenerator {
    private NoiseGeneratorPerlin[] generatorCollection;
    private int octaves;

    public NoiseGeneratorOctaves(Random random, int octaves) {
        this.octaves = octaves;
        this.generatorCollection = new NoiseGeneratorPerlin[octaves];
        int var3 = 0;
        while (var3 < octaves) {
            this.generatorCollection[var3] = new NoiseGeneratorPerlin(random);
            ++var3;
        }
    }

    public double generateNoiseOctaves(double var1, double var3) {
        double var5 = 0.0;
        double var7 = 1.0;
        int var9 = 0;
        while (var9 < this.octaves) {
            var5 += this.generatorCollection[var9].generateNoise(var1 * var7, var3 * var7) / var7;
            var7 /= 2.0;
            ++var9;
        }
        return var5;
    }

    public double[] generateNoiseOctaves(double[] var1, double var2, double var4, double var6, int var8, int var9, int var10, double var11, double var13, double var15) {
        if (var1 == null) {
            var1 = new double[var8 * var9 * var10];
        } else {
            int var20 = 0;
            while (var20 < var1.length) {
                var1[var20] = 0.0;
                ++var20;
            }
        }
        double d20 = 1.0;
        int var19 = 0;
        while (var19 < this.octaves) {
            this.generatorCollection[var19].populateNoiseArray(var1, var2, var4, var6, var8, var9, var10, var11 * d20, var13 * d20, var15 * d20, d20);
            d20 /= 2.0;
            ++var19;
        }
        return var1;
    }
}

