/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GameSettings;
import net.minecraft.src.InputHandler;
import net.minecraft.src.MovementInput;

public class MovementInputFromOptions
extends MovementInput {
    private boolean[] movementKeyStates;
    private GameSettings gameSettings;

    public MovementInputFromOptions(GameSettings gameSettings) {
        InputHandler.CaptureGamepad();
        this.movementKeyStates = new boolean[10];
        this.gameSettings = gameSettings;
    }

    @Override
    public void checkKeyForMovementInput(int key, boolean state) {
        int var3 = -1;
        if (key == this.gameSettings.keyBindForward.keyCode) {
            var3 = 0;
        }
        if (key == this.gameSettings.keyBindBack.keyCode) {
            var3 = 1;
        }
        if (key == this.gameSettings.keyBindLeft.keyCode) {
            var3 = 2;
        }
        if (key == this.gameSettings.keyBindRight.keyCode) {
            var3 = 3;
        }
        if (key == this.gameSettings.keyBindJump.keyCode) {
            var3 = 4;
        }
        if (var3 >= 0) {
            this.movementKeyStates[var3] = state;
        }
    }

    @Override
    public void resetKeyState() {
        int var1 = 0;
        while (var1 < 10) {
            this.movementKeyStates[var1] = false;
            ++var1;
        }
    }

    @Override
    public void updatePlayerMoveState(EntityPlayer var1) {
        this.moveStrafe = 0.0f;
        this.moveForward = 0.0f;
        this.jump = this.movementKeyStates[4];
        if (InputHandler.gamepads != null) {
            int var2 = 0;
            while (var2 != InputHandler.gamepads.length) {
                if (InputHandler.gamepads[var2] != null && (InputHandler.gamepads[var2].getXAxisValue() != -1.0f || InputHandler.gamepads[var2].getYAxisValue() != -1.0f)) {
                    this.moveStrafe = -InputHandler.gamepads[var2].getXAxisValue();
                    if ((double)this.moveStrafe > -0.15 && (double)this.moveStrafe < 0.15) {
                        this.moveStrafe = 0.0f;
                    }
                    this.moveForward = -InputHandler.gamepads[var2].getYAxisValue();
                    if ((double)this.moveForward > -0.15 && (double)this.moveForward < 0.15) {
                        this.moveForward = 0.0f;
                    }
                    if (this.moveStrafe != 0.0f || this.moveForward != 0.0f) {
                        return;
                    }
                }
                ++var2;
            }
        }
        if (this.movementKeyStates[0]) {
            this.moveForward += 1.0f;
        }
        if (this.movementKeyStates[1]) {
            this.moveForward -= 1.0f;
        }
        if (this.movementKeyStates[2]) {
            this.moveStrafe += 1.0f;
        }
        if (this.movementKeyStates[3]) {
            this.moveStrafe -= 1.0f;
        }
    }
}

