/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySheep
extends EntityAnimal {
    public boolean sheared = false;

    public EntitySheep(World var1) {
        super(var1);
        this.texture = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (!this.sheared && var1 instanceof EntityLiving) {
            this.sheared = true;
            int var3 = 1 + this.rand.nextInt(3);
            int var4 = 0;
            while (var4 < var3) {
                EntityItem var5 = this.entityDropItem(Block.cloth.blockID, 1, 1.0f);
                var5.motionY += (double)(this.rand.nextFloat() * 0.05f);
                var5.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                var5.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                ++var4;
            }
        }
        return super.attackEntityFrom(var1, var2);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setBoolean("Sheared", this.sheared);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.sheared = var1.getBoolean("Sheared");
    }

    @Override
    protected String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }
}

