/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class EntityOtherPlayerMP
extends EntityPlayer {
    private int otherPlayerMPPosRotationIncrements;
    private double otherPlayerMPX;
    private double otherPlayerMPY;
    private double otherPlayerMPZ;
    private double otherPlayerMPYaw;
    private double otherPlayerMPPitch;
    float unusedFloat = 0.0f;

    public EntityOtherPlayerMP(World worldObj, String username) {
        super(worldObj);
        this.username = username;
        this.yOffset = 0.0f;
        this.stepHeight = 0.0f;
        if (username != null && username.length() > 0) {
            boolean var3 = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1;
            this.skinUrl = "file:///" + (var3 ? "." : "C:") + "/skincache/" + username + ".png";
            System.out.println("Loading texture " + this.skinUrl);
        }
        this.noClip = true;
        this.renderDistanceWeight = 10.0;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        return true;
    }

    @Override
    public void setPositionAndRotation(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.yOffset = 0.0f;
        this.otherPlayerMPX = var1;
        this.otherPlayerMPY = var3;
        this.otherPlayerMPZ = var5;
        this.otherPlayerMPYaw = var7;
        this.otherPlayerMPPitch = var8;
        this.otherPlayerMPPosRotationIncrements = var9;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.prevLimbYaw = this.limbYaw;
        double var1 = this.posX - this.prevPosX;
        double var3 = this.posZ - this.prevPosZ;
        float var5 = MathHelper.sqrt_double(var1 * var1 + var3 * var3) * 4.0f;
        if (var5 > 1.0f) {
            var5 = 1.0f;
        }
        this.limbYaw += (var5 - this.limbYaw) * 0.4f;
        this.limbSwing += this.limbYaw;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void onLivingUpdate() {
        super.updateEntityActionState();
        if (this.otherPlayerMPPosRotationIncrements > 0) {
            double var9 = this.posX + (this.otherPlayerMPX - this.posX) / (double)this.otherPlayerMPPosRotationIncrements;
            double var3 = this.posY + (this.otherPlayerMPY - this.posY) / (double)this.otherPlayerMPPosRotationIncrements;
            double var5 = this.posZ + (this.otherPlayerMPZ - this.posZ) / (double)this.otherPlayerMPPosRotationIncrements;
            double var7 = this.otherPlayerMPYaw - (double)this.rotationYaw;
            while (var7 < -180.0) {
                var7 += 360.0;
            }
            while (var7 >= 180.0) {
                var7 -= 360.0;
            }
            this.rotationYaw += (float)(var7 / (double)this.otherPlayerMPPosRotationIncrements);
            this.rotationPitch += (float)((this.otherPlayerMPPitch - (double)this.rotationPitch) / (double)this.otherPlayerMPPosRotationIncrements);
            --this.otherPlayerMPPosRotationIncrements;
            this.setPosition(var9, var3, var5);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        this.prevCameraYaw = this.cameraYaw;
        float var91 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float var2 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (var91 > 0.1f) {
            var91 = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            var91 = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            var2 = 0.0f;
        }
        this.cameraYaw += (var91 - this.cameraYaw) * 0.4f;
        this.cameraPitch += (var2 - this.cameraPitch) * 0.8f;
    }
}

