/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.StepSound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityLiving
extends Entity {
    public int heartsHalvesLife = 20;
    public float unusedRotationPitch2;
    public float unusedFloat;
    public float unusedRotationPitch;
    public float renderYawOffset = 0.0f;
    public float prevRenderYawOffset = 0.0f;
    protected float ridingRotUnused;
    protected float prevRidingRotUnused;
    protected float rotationUnused;
    protected float prevRotationUnused;
    protected boolean unusedBool1 = true;
    protected String texture = "/char.png";
    protected boolean unusedBool2 = true;
    protected float unusedRotation = 0.0f;
    protected String entityType = null;
    protected float unusedFloat1 = 1.0f;
    protected int scoreValue = 0;
    protected float unusedFloat2 = 0.0f;
    public boolean isAIEnabled = false;
    public float prevSwingProgress;
    public float swingProgress;
    public int health = 10;
    public int prevHealth;
    private int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float prevCameraPitch;
    public float cameraPitch;
    protected boolean dead = false;
    public int unusedInt = -1;
    public float unusedFloat4 = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float prevLimbYaw;
    public float limbYaw;
    public float limbSwing;
    private int newPosRotationIncrements;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    float unusedFloat3 = 0.0f;
    protected int entityAge = 0;
    protected float moveStrafing;
    protected float moveForward;
    protected float randomYawVelocity;
    protected boolean isJumping = false;
    protected float defaultPitch = 0.0f;
    protected float moveSpeed = 0.7f;
    private Entity currentTarget;
    private int numTicksToChaseTarget = 0;

    public EntityLiving(World var1) {
        super(var1);
        this.preventEntitySpawning = true;
        this.unusedRotationPitch = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.unusedRotationPitch2 = (float)Math.random() * 12398.0f;
        this.rotationYaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.unusedFloat = 1.0f;
        this.stepHeight = 0.5f;
    }

    protected boolean canEntityBeSeen(Entity entity) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ)) == null;
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public boolean canBePushed() {
        return !this.isDead;
    }

    @Override
    protected float getEyeHeight() {
        return this.height * 0.85f;
    }

    public int getTalkInterval() {
        return 80;
    }

    @Override
    public void onEntityUpdate() {
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        if (this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getTalkInterval();
            String var8 = this.getLivingSound();
            if (var8 != null) {
                this.worldObj.playSoundAtEntity(this, var8, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (this.isEntityAlive() && this.isEntityInsideOpaqueBlock()) {
            this.attackEntityFrom(null, 1);
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water)) {
            --this.air;
            if (this.air == -20) {
                this.air = 0;
                int i8 = 0;
                while (i8 < 8) {
                    float var9 = this.rand.nextFloat() - this.rand.nextFloat();
                    float var3 = this.rand.nextFloat() - this.rand.nextFloat();
                    float var10 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)var9, this.posY + (double)var3, this.posZ + (double)var10, this.motionX, this.motionY, this.motionZ);
                    ++i8;
                }
                this.attackEntityFrom(null, 2);
            }
            this.fire = 0;
        } else {
            this.air = this.maxAir;
        }
        this.prevCameraPitch = this.cameraPitch;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsLife > 0) {
            --this.heartsLife;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.onEntityDeath();
                this.setEntityDead();
                int i8 = 0;
                while (i8 < 20) {
                    double d9 = this.rand.nextGaussian() * 0.02;
                    double d10 = this.rand.nextGaussian() * 0.02;
                    double var6 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d9, d10, var6);
                    ++i8;
                }
            }
        }
        this.prevRotationUnused = this.rotationUnused;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void spawnExplosionParticle() {
        int var1 = 0;
        while (var1 < 20) {
            double var2 = this.rand.nextGaussian() * 0.02;
            double var4 = this.rand.nextGaussian() * 0.02;
            double var6 = this.rand.nextGaussian() * 0.02;
            double var8 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - var2 * var8, this.posY + (double)(this.rand.nextFloat() * this.height) - var4 * var8, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - var6 * var8, var2, var4, var6);
            ++var1;
        }
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        this.ridingRotUnused = this.prevRidingRotUnused;
        this.prevRidingRotUnused = 0.0f;
    }

    @Override
    public void setPositionAndRotation(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.yOffset = 0.0f;
        this.newPosX = var1;
        this.newPosY = var3;
        this.newPosZ = var5;
        this.newRotationYaw = var7;
        this.newRotationPitch = var8;
        this.newPosRotationIncrements = var9;
    }

    @Override
    public void onUpdate() {
        boolean var11;
        super.onUpdate();
        this.onLivingUpdate();
        double var1 = this.posX - this.prevPosX;
        double var3 = this.posZ - this.prevPosZ;
        float var5 = MathHelper.sqrt_double(var1 * var1 + var3 * var3);
        float var6 = this.renderYawOffset;
        float var7 = 0.0f;
        this.ridingRotUnused = this.prevRidingRotUnused;
        float var8 = 0.0f;
        if (var5 > 0.05f) {
            var8 = 1.0f;
            var7 = var5 * 3.0f;
            var6 = (float)Math.atan2(var3, var1) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            var6 = this.rotationYaw;
        }
        if (!this.onGround) {
            var8 = 0.0f;
        }
        this.prevRidingRotUnused += (var8 - this.prevRidingRotUnused) * 0.3f;
        float var9 = var6 - this.renderYawOffset;
        while (var9 < -180.0f) {
            var9 += 360.0f;
        }
        while (var9 >= 180.0f) {
            var9 -= 360.0f;
        }
        this.renderYawOffset += var9 * 0.3f;
        float var10 = this.rotationYaw - this.renderYawOffset;
        while (var10 < -180.0f) {
            var10 += 360.0f;
        }
        while (var10 >= 180.0f) {
            var10 -= 360.0f;
        }
        boolean bl = var11 = var10 < -90.0f || var10 >= 90.0f;
        if (var10 < -75.0f) {
            var10 = -75.0f;
        }
        if (var10 >= 75.0f) {
            var10 = 75.0f;
        }
        this.renderYawOffset = this.rotationYaw - var10;
        if (var10 * var10 > 2500.0f) {
            this.renderYawOffset += var10 * 0.2f;
        }
        if (var11) {
            var7 *= -1.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        this.rotationUnused += var7;
    }

    @Override
    protected void setSize(float var1, float var2) {
        super.setSize(var1, var2);
    }

    public void heal(int health) {
        if (this.health > 0) {
            this.health += health;
            if (this.health > 20) {
                this.health = 20;
            }
            this.heartsLife = this.heartsHalvesLife / 2;
        }
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (this.worldObj.multiplayerWorld) {
            var2 = 0;
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        this.limbYaw = 1.5f;
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            if (this.prevHealth - var2 >= this.health) {
                return false;
            }
            this.health = this.prevHealth - var2;
        } else {
            this.prevHealth = this.health;
            this.heartsLife = this.heartsHalvesLife;
            this.health -= var2;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        if (var1 != null) {
            double var3 = var1.posX - this.posX;
            double var5 = var1.posZ - this.posZ;
            while (var3 * var3 + var5 * var5 < 1.0E-4) {
                var3 = (Math.random() - Math.random()) * 0.01;
                var5 = (Math.random() - Math.random()) * 0.01;
            }
            this.attackedAtYaw = (float)(Math.atan2(var5, var3) * 180.0 / 3.1415927410125732) - this.rotationYaw;
            this.knockBack(var1, var2, var3, var5);
        } else {
            this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
        }
        if (this.health <= 0) {
            this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.onDeath(var1);
        } else {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void knockBack(Entity entity, int x, double y, double z) {
        float var7 = MathHelper.sqrt_double(y * y + z * z);
        float var8 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= y / (double)var7 * (double)var8;
        this.motionY += (double)0.4f;
        this.motionZ -= z / (double)var7 * (double)var8;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreValue > 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreValue);
        }
        this.dead = true;
        int var2 = this.getDropItemId();
        if (var2 > 0) {
            int var3 = this.rand.nextInt(3);
            int var4 = 0;
            while (var4 < var3) {
                this.dropItem(var2, 1);
                ++var4;
            }
        }
    }

    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void fall(float distance) {
        int var2 = (int)Math.ceil(distance - 3.0f);
        if (var2 > 0) {
            this.attackEntityFrom(null, var2);
            int var3 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (var3 > 0) {
                StepSound var4 = Block.blocksList[var3].stepSound;
                this.worldObj.playSoundAtEntity(this, var4.getStepSound(), var4.getVolume() * 0.5f, var4.getPitch() * 0.75f);
            }
        }
    }

    public void moveEntityWithHeading(float moveX, float moveZ) {
        double var3;
        if (this.handleWaterMovement()) {
            var3 = this.posY;
            this.moveFlying(moveX, moveZ, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + var3, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            var3 = this.posY;
            this.moveFlying(moveX, moveZ, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + var3, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float var10 = 0.91f;
            if (this.onGround) {
                var10 = 0.54600006f;
                int var9 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (var9 > 0) {
                    var10 = Block.blocksList[var9].slipperiness * 0.91f;
                }
            }
            float var91 = 0.16277136f / (var10 * var10 * var10);
            this.moveFlying(moveX, moveZ, this.onGround ? 0.1f * var91 : 0.02f);
            var10 = 0.91f;
            if (this.onGround) {
                var10 = 0.54600006f;
                int var7 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (var7 > 0) {
                    var10 = Block.blocksList[var7].slipperiness * 0.91f;
                }
            }
            if (this.isOnLadder()) {
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && this.isOnLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)var10;
            this.motionZ *= (double)var10;
        }
        this.prevLimbYaw = this.limbYaw;
        var3 = this.posX - this.prevPosX;
        double var101 = this.posZ - this.prevPosZ;
        float var71 = MathHelper.sqrt_double(var3 * var3 + var101 * var101) * 4.0f;
        if (var71 > 1.0f) {
            var71 = 1.0f;
        }
        this.limbYaw += (var71 - this.limbYaw) * 0.4f;
        this.limbSwing += this.limbYaw;
    }

    public boolean isOnLadder() {
        int var3;
        int var2;
        int var1 = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(var1, var2 = MathHelper.floor_double(this.boundingBox.minY), var3 = MathHelper.floor_double(this.posZ)) == Block.ladder.blockID || this.worldObj.getBlockId(var1, var2 + 1, var3) == Block.ladder.blockID;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("Health", (short)this.health);
        var1.setShort("HurtTime", (short)this.hurtTime);
        var1.setShort("DeathTime", (short)this.deathTime);
        var1.setShort("AttackTime", (short)this.attackTime);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.health = var1.getShort("Health");
        if (!var1.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTime = var1.getShort("HurtTime");
        this.deathTime = var1.getShort("DeathTime");
        this.attackTime = var1.getShort("AttackTime");
    }

    @Override
    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public void onLivingUpdate() {
        if (this.newPosRotationIncrements > 0) {
            double var9 = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double var10 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double var11 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            double var7 = this.newRotationYaw - (double)this.rotationYaw;
            while (var7 < -180.0) {
                var7 += 360.0;
            }
            while (var7 >= 180.0) {
                var7 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(var9, var10, var11);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        if (this.health <= 0) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (!this.isAIEnabled) {
            this.updateEntityActionState();
        }
        boolean z9 = this.handleWaterMovement();
        boolean var2 = this.handleLavaMovement();
        if (this.isJumping) {
            if (z9) {
                this.motionY += (double)0.04f;
            } else if (var2) {
                this.motionY += (double)0.04f;
            } else if (this.onGround) {
                this.jump();
            }
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        List list10 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list10 != null && list10.size() > 0) {
            int var4 = 0;
            while (var4 < list10.size()) {
                Entity entity11 = (Entity)list10.get(var4);
                if (entity11.canBePushed()) {
                    entity11.applyEntityCollision(this);
                }
                ++var4;
            }
        }
    }

    protected void jump() {
        this.motionY = 0.42f;
    }

    protected void updateEntityActionState() {
        ++this.entityAge;
        EntityPlayer var1 = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (var1 != null) {
            double var10 = var1.posX - this.posX;
            double var11 = var1.posY - this.posY;
            double var6 = var1.posZ - this.posZ;
            double var8 = var10 * var10 + var11 * var11 + var6 * var6;
            if (var8 > 16384.0) {
                this.setEntityDead();
            }
            if (this.entityAge > 600 && this.rand.nextInt(800) == 0) {
                if (var8 < 1024.0) {
                    this.entityAge = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f10 = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            var1 = this.worldObj.getClosestPlayerToEntity(this, f10);
            if (var1 != null) {
                this.currentTarget = var1;
                this.numTicksToChaseTarget = 10 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f);
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity(this) > (double)(f10 * f10)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
        }
        boolean var3 = this.handleWaterMovement();
        boolean z11 = this.handleLavaMovement();
        if (var3 || z11) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    public void faceEntity(Entity entity, float var2) {
        double var5;
        double var3 = entity.posX - this.posX;
        double var7 = entity.posZ - this.posZ;
        if (entity instanceof EntityLiving) {
            EntityLiving var13 = (EntityLiving)entity;
            var5 = var13.posY + (double)var13.getEyeHeight() - (this.posY + (double)this.getEyeHeight());
        } else {
            var5 = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double var131 = MathHelper.sqrt_double(var3 * var3 + var7 * var7);
        float var11 = (float)(Math.atan2(var7, var3) * 180.0 / 3.1415927410125732) - 90.0f;
        float var12 = (float)(Math.atan2(var5, var131) * 180.0 / 3.1415927410125732);
        this.rotationPitch = this.updateRotation(this.rotationPitch, var12, var2);
        this.rotationYaw = this.updateRotation(this.rotationYaw, var11, var2);
    }

    private float updateRotation(float var1, float var2, float var3) {
        float var4 = var2 - var1;
        while (var4 < -180.0f) {
            var4 += 360.0f;
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > var3) {
            var4 = var3;
        }
        if (var4 < -var3) {
            var4 = -var3;
        }
        return var1 + var4;
    }

    public void onEntityDeath() {
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.getIsAnyLiquid(this.boundingBox);
    }

    @Override
    protected void kill() {
        this.attackEntityFrom(null, 4);
    }

    public float getSwingProgress(float renderPartialTick) {
        float var2 = this.swingProgress - this.prevSwingProgress;
        if (var2 < 0.0f) {
            var2 += 1.0f;
        }
        return this.prevSwingProgress + var2 * renderPartialTick;
    }

    public Vec3D getPosition(float renderPartialTick) {
        if (renderPartialTick == 1.0f) {
            return Vec3D.createVector(this.posX, this.posY, this.posZ);
        }
        double var2 = this.prevPosX + (this.posX - this.prevPosX) * (double)renderPartialTick;
        double var4 = this.prevPosY + (this.posY - this.prevPosY) * (double)renderPartialTick;
        double var6 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)renderPartialTick;
        return Vec3D.createVector(var2, var4, var6);
    }

    public Vec3D getLook(float renderPartialTick) {
        if (renderPartialTick == 1.0f) {
            float var2 = MathHelper.cos(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI);
            float var3 = MathHelper.sin(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI);
            float var4 = -MathHelper.cos(-this.rotationPitch * ((float)Math.PI / 180));
            float var5 = MathHelper.sin(-this.rotationPitch * ((float)Math.PI / 180));
            return Vec3D.createVector(var3 * var4, var5, var2 * var4);
        }
        float var2 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * renderPartialTick;
        float var3 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * renderPartialTick;
        float var4 = MathHelper.cos(-var3 * ((float)Math.PI / 180) - (float)Math.PI);
        float var5 = MathHelper.sin(-var3 * ((float)Math.PI / 180) - (float)Math.PI);
        float var6 = -MathHelper.cos(-var2 * ((float)Math.PI / 180));
        float var7 = MathHelper.sin(-var2 * ((float)Math.PI / 180));
        return Vec3D.createVector(var5 * var6, var7, var4 * var6);
    }

    public MovingObjectPosition rayTrace(double var1, float renderPartialTick) {
        Vec3D var4 = this.getPosition(renderPartialTick);
        Vec3D var5 = this.getLook(renderPartialTick);
        Vec3D var6 = var4.addVector(var5.xCoord * var1, var5.yCoord * var1, var5.zCoord * var1);
        return this.worldObj.rayTraceBlocks(var4, var6);
    }
}

