/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityGiantZombie;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityList {
    private static Map stringToClassMapping = new HashMap();
    private static Map classToStringMapping = new HashMap();
    private static Map IDtoClassMapping = new HashMap();
    private static Map classToIDMapping = new HashMap();

    static {
        EntityList.addMapping(EntityArrow.class, "Arrow", 10);
        EntityList.addMapping(EntitySnowball.class, "Snowball", 11);
        EntityList.addMapping(EntityItem.class, "Item", 1);
        EntityList.addMapping(EntityPainting.class, "Painting", 9);
        EntityList.addMapping(EntityLiving.class, "Mob", 48);
        EntityList.addMapping(EntityMob.class, "Monster", 49);
        EntityList.addMapping(EntityCreeper.class, "Creeper", 50);
        EntityList.addMapping(EntitySkeleton.class, "Skeleton", 51);
        EntityList.addMapping(EntitySpider.class, "Spider", 52);
        EntityList.addMapping(EntityGiantZombie.class, "Giant", 53);
        EntityList.addMapping(EntityZombie.class, "Zombie", 54);
        EntityList.addMapping(EntitySlime.class, "Slime", 55);
        EntityList.addMapping(EntityPig.class, "Pig", 90);
        EntityList.addMapping(EntitySheep.class, "Sheep", 91);
        EntityList.addMapping(EntityCow.class, "Cow", 91);
        EntityList.addMapping(EntityChicken.class, "Chicken", 91);
        EntityList.addMapping(EntityTNTPrimed.class, "PrimedTnt", 20);
        EntityList.addMapping(EntityFallingSand.class, "FallingSand", 21);
        EntityList.addMapping(EntityMinecart.class, "Minecart", 40);
        EntityList.addMapping(EntityBoat.class, "Boat", 41);
    }

    private static void addMapping(Class entityClass, String entityName, int entityID) {
        stringToClassMapping.put(entityName, entityClass);
        classToStringMapping.put(entityClass, entityName);
        IDtoClassMapping.put(entityID, entityClass);
        classToIDMapping.put(entityClass, entityID);
    }

    public static Entity createEntityByName(String entityName, World worldObj) {
        Entity var2 = null;
        try {
            Class var4 = (Class)stringToClassMapping.get(entityName);
            if (var4 != null) {
                var2 = (Entity)var4.getConstructor(World.class).newInstance(worldObj);
            }
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
        return var2;
    }

    public static Entity createEntityFromNBT(NBTTagCompound nbtCompound, World worldObj) {
        Entity var2 = null;
        try {
            Class var4 = (Class)stringToClassMapping.get(nbtCompound.getString("id"));
            if (var4 != null) {
                var2 = (Entity)var4.getConstructor(World.class).newInstance(worldObj);
            }
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
        if (var2 != null) {
            var2.readFromNBT(nbtCompound);
        } else {
            System.out.println("Skipping Entity with id " + nbtCompound.getString("id"));
        }
        return var2;
    }

    public static Entity createEntityByID(int entityID, World worldObj) {
        Entity var2 = null;
        try {
            Class var4 = (Class)IDtoClassMapping.get(entityID);
            if (var4 != null) {
                var2 = (Entity)var4.getConstructor(World.class).newInstance(worldObj);
            }
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
        if (var2 == null) {
            System.out.println("Skipping Entity with id " + entityID);
        }
        return var2;
    }

    public static int getEntityID(Entity entity) {
        return (Integer)classToIDMapping.get(entity.getClass());
    }

    public static String getEntityString(Entity entity) {
        return (String)classToStringMapping.get(entity.getClass());
    }
}

