/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.Material;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.OnWaterGen;
import net.minecraft.src.PillarGen;
import net.minecraft.src.SkyGen;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenBigTree;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDungeons;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenTrees;
import net.minecraft.src.WorldGenerator;

public class ChunkProviderGenerate
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves noiseGen7;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private double[] noiseArray;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise6;
    double[] noise7;
    int[][] unused = new int[32][32];
    private int time_hr = 0;
    private long lastUpdate = 0L;

    public ChunkProviderGenerate(World worldObj, long seed) {
        this.worldObj = worldObj;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen7 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int chunkX, int chunkZ, byte[] blocks) {
        this.noiseArray = this.initializeNoiseField(this.noiseArray, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        int var9 = 0;
        while (var9 < 4) {
            int var10 = 0;
            while (var10 < 4) {
                int var11 = 0;
                while (var11 < 16) {
                    double var14 = this.noiseArray[((var9 + 0) * 5 + var10 + 0) * 17 + var11 + 0];
                    double var16 = this.noiseArray[((var9 + 0) * 5 + var10 + 1) * 17 + var11 + 0];
                    double var18 = this.noiseArray[((var9 + 1) * 5 + var10 + 0) * 17 + var11 + 0];
                    double var20 = this.noiseArray[((var9 + 1) * 5 + var10 + 1) * 17 + var11 + 0];
                    double var22 = (this.noiseArray[((var9 + 0) * 5 + var10 + 0) * 17 + var11 + 1] - var14) * 0.125;
                    double var24 = (this.noiseArray[((var9 + 0) * 5 + var10 + 1) * 17 + var11 + 1] - var16) * 0.125;
                    double var26 = (this.noiseArray[((var9 + 1) * 5 + var10 + 0) * 17 + var11 + 1] - var18) * 0.125;
                    double var28 = (this.noiseArray[((var9 + 1) * 5 + var10 + 1) * 17 + var11 + 1] - var20) * 0.125;
                    int var30 = 0;
                    while (var30 < 8) {
                        double var33 = var14;
                        double var35 = var16;
                        double var37 = (var18 - var14) * 0.25;
                        double var39 = (var20 - var16) * 0.25;
                        int var41 = 0;
                        while (var41 < 4) {
                            int var42 = var41 + var9 * 4 << 11 | 0 + var10 * 4 << 7 | var11 * 8 + var30;
                            double var46 = var33;
                            double var48 = (var35 - var33) * 0.25;
                            int var50 = 0;
                            while (var50 < 4) {
                                int var51 = 0;
                                if (var11 * 8 + var30 < 64) {
                                    var51 = this.worldObj.snowCovered && var11 * 8 + var30 >= 63 ? Block.ice.blockID : Block.waterStill.blockID;
                                }
                                if (var46 > 0.0) {
                                    var51 = Block.stone.blockID;
                                }
                                blocks[var42] = (byte)var51;
                                var42 += 128;
                                var46 += var48;
                                ++var50;
                            }
                            var33 += var37;
                            var35 += var39;
                            ++var41;
                        }
                        var14 += var22;
                        var16 += var24;
                        var18 += var26;
                        var20 += var28;
                        ++var30;
                    }
                    ++var11;
                }
                ++var10;
            }
            ++var9;
        }
    }

    public void replaceSurfaceBlocks(int chunkX, int chunkZ, byte[] blocks) {
        this.sandNoise = this.noiseGen4.generateNoiseOctaves(this.sandNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.noiseGen4.generateNoiseOctaves(this.gravelNoise, chunkZ * 16, 109.0134, chunkX * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.stoneNoise = this.noiseGen5.generateNoiseOctaves(this.stoneNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        int var7 = 0;
        while (var7 < 16) {
            int var8 = 0;
            while (var8 < 16) {
                boolean var9 = this.sandNoise[var7 + var8 * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean var10 = this.gravelNoise[var7 + var8 * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int var11 = (int)(this.stoneNoise[var7 + var8 * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var12 = -1;
                byte var13 = (byte)Block.grass.blockID;
                byte var14 = (byte)Block.dirt.blockID;
                int var15 = 127;
                while (var15 >= 0) {
                    int var16 = (var7 * 16 + var8) * 128 + var15;
                    if (var15 <= 0 + this.rand.nextInt(6) - 1) {
                        blocks[var16] = (byte)Block.bedrock.blockID;
                    } else {
                        byte var17 = blocks[var16];
                        if (var17 == 0) {
                            var12 = -1;
                        } else if (var17 == Block.stone.blockID) {
                            if (var12 == -1) {
                                if (var11 <= 0) {
                                    var13 = 0;
                                    var14 = (byte)Block.stone.blockID;
                                } else if (var15 >= 60 && var15 <= 65) {
                                    var13 = (byte)Block.grass.blockID;
                                    var14 = (byte)Block.dirt.blockID;
                                    if (var10) {
                                        var13 = 0;
                                    }
                                    if (var10) {
                                        var14 = (byte)Block.gravel.blockID;
                                    }
                                    if (var9) {
                                        var13 = (byte)Block.sand.blockID;
                                    }
                                    if (var9) {
                                        var14 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (var15 < 64 && var13 == 0) {
                                    var13 = (byte)Block.waterStill.blockID;
                                }
                                var12 = var11;
                                blocks[var16] = var15 >= 63 ? var13 : var14;
                            } else if (var12 > 0) {
                                --var12;
                                blocks[var16] = var14;
                            }
                        }
                    }
                    --var15;
                }
                ++var8;
            }
            ++var7;
        }
    }

    @Override
    public Chunk provideChunk(int var1, int var2) {
        if (Math.abs(System.currentTimeMillis() - this.lastUpdate) > 5000L) {
            SimpleDateFormat var8 = new SimpleDateFormat("HH");
            this.time_hr = Integer.parseInt(var8.format(Calendar.getInstance().getTime()));
            this.lastUpdate = System.currentTimeMillis();
        }
        boolean var81 = this.time_hr > 22 || this.time_hr < 5;
        this.rand.setSeed((long)var1 * 341873128712L + (long)var2 * 132897987541L);
        byte[] var4 = new byte[32768];
        Chunk var5 = new Chunk(this.worldObj, var4, var1, var2);
        int var6 = var1 + (var81 ? this.rand.nextInt(2000) - this.rand.nextInt(1000) : 0);
        int var7 = var2 + (var81 ? this.rand.nextInt(2000) - this.rand.nextInt(1000) : 0);
        this.generateTerrain(var6, var7, var4);
        this.replaceSurfaceBlocks(var6, var7, var4);
        this.caveGenerator.generate(this, this.worldObj, var6, var7, var4);
        var5.generateSkylightMap();
        return var5;
    }

    private double[] initializeNoiseField(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        if (var1 == null) {
            var1 = new double[var5 * var6 * var7];
        }
        this.noise6 = this.noiseGen6.generateNoiseOctaves(this.noise6, var2, var3, var4, var5, 1, var7, 1.0, 0.0, 1.0);
        this.noise7 = this.noiseGen7.generateNoiseOctaves(this.noise7, var2, var3, var4, var5, 1, var7, 100.0, 0.0, 100.0);
        this.noise3 = this.noiseGen3.generateNoiseOctaves(this.noise3, var2, var3, var4, var5, var6, var7, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.noise1 = this.noiseGen1.generateNoiseOctaves(this.noise1, var2, var3, var4, var5, var6, var7, 684.412, 684.412, 684.412);
        this.noise2 = this.noiseGen2.generateNoiseOctaves(this.noise2, var2, var3, var4, var5, var6, var7, 684.412, 684.412, 684.412);
        int var12 = 0;
        int var13 = 0;
        int var14 = 0;
        while (var14 < var5) {
            int var15 = 0;
            while (var15 < var7) {
                double var24;
                double var26;
                double var22;
                double var20;
                double var16 = (this.noise6[var13] + 256.0) / 512.0;
                if (var16 > 1.0) {
                    var16 = 1.0;
                }
                if ((var20 = this.noise7[var13] / 8000.0) < 0.0) {
                    var20 = -var20;
                }
                if ((var22 = var20 * 3.0 - 3.0) < 0.0) {
                    var26 = var22 / 2.0;
                    if (var26 < -1.0) {
                        var26 = -1.0;
                    }
                    var24 = var26 / 1.4 / 2.0;
                    var16 = 0.0;
                } else {
                    if (var22 > 1.0) {
                        var22 = 1.0;
                    }
                    var24 = var22 / 6.0;
                }
                var26 = var16 + 0.5;
                double var28 = (double)var6 / 2.0 + var24 * (double)var6 / 16.0 * 4.0;
                ++var13;
                int var30 = 0;
                while (var30 < var6) {
                    double var43;
                    double var31 = ((double)var30 - var28) * 12.0 / var26;
                    if (var31 < 0.0) {
                        var31 *= 4.0;
                    }
                    double var33 = this.noise1[var12] / 512.0;
                    double var35 = this.noise2[var12] / 512.0;
                    double var37 = (this.noise3[var12] / 10.0 + 1.0) / 2.0;
                    double var39 = var37 < 0.0 ? var33 : (var37 > 1.0 ? var35 : var33 + (var35 - var33) * var37);
                    double var41 = var39 - var31;
                    if (var30 > var6 - 4) {
                        var43 = (float)(var30 - (var6 - 4)) / 3.0f;
                        var41 = var41 * (1.0 - var43) + -10.0 * var43;
                    }
                    if ((double)var30 < 0.0) {
                        var43 = (0.0 - (double)var30) / 4.0;
                        if (var43 < 0.0) {
                            var43 = 0.0;
                        }
                        if (var43 > 1.0) {
                            var43 = 1.0;
                        }
                        var41 = var41 * (1.0 - var43) + -10.0 * var43;
                    }
                    var1[var12] = var41;
                    ++var12;
                    ++var30;
                }
                ++var15;
            }
            ++var14;
        }
        return var1;
    }

    @Override
    public boolean chunkExists(int var1, int var2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider var1, int var2, int var3) {
        int var12;
        int var11;
        BlockSand.fallInstantly = true;
        int var4 = var2 * 16;
        int var5 = var3 * 16;
        this.rand.setSeed(this.worldObj.randomSeed);
        this.rand.setSeed((long)var2 * (this.rand.nextLong() / 2L * 2L + 1L) + (long)var3 * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.worldObj.randomSeed);
        int var6 = 0;
        while (var6 < 8) {
            new WorldGenDungeons().generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var6;
        }
        var6 = 0;
        while (var6 < 10) {
            new WorldGenClay(32).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(128), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 20) {
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(128), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 10) {
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(128), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 20) {
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(128), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 20) {
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(64), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 2) {
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(32), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 8) {
            new WorldGenMinable(Block.oreRedstone.blockID, 7).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(16), var5 + this.rand.nextInt(16));
            ++var6;
        }
        var6 = 0;
        while (var6 < 1) {
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16), this.rand.nextInt(16), var5 + this.rand.nextInt(16));
            ++var6;
        }
        int var8 = (int)((this.mobSpawnerNoise.generateNoiseOctaves((double)var4 * 0.5, (double)var5 * 0.5) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        if (var8 < 0) {
            var8 = 0;
        }
        if (this.rand.nextInt(10) == 0) {
            ++var8;
        }
        WorldGenerator var9 = new WorldGenTrees();
        if (this.rand.nextInt(10) == 0) {
            var9 = new WorldGenBigTree();
        }
        int var10 = 0;
        while (var10 < var8) {
            var11 = var4 + this.rand.nextInt(16) + 8;
            var12 = var5 + this.rand.nextInt(16) + 8;
            ((WorldGenerator)var9).setScale(1.0, 1.0, 1.0);
            ((WorldGenerator)var9).generate(this.worldObj, this.rand, var11, this.worldObj.getHeightValue(var11, var12), var12);
            ++var10;
        }
        var10 = 0;
        while (var10 < 2) {
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        if (this.rand.nextInt(2) == 0) {
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
        }
        if (this.rand.nextInt(4) == 0) {
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
        }
        if (this.rand.nextInt(8) == 0) {
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
        }
        var10 = 0;
        while (var10 < 3) {
            new PillarGen(Block.saltBlock.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 3) {
            new OnWaterGen(Block.glowingFlower.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 2) {
            new SkyGen(Block.blueFireIdk.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 10) {
            new WorldGenReed().generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 1) {
            new WorldGenCactus().generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(128), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 50) {
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(this.rand.nextInt(120) + 8), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = 0;
        while (var10 < 20) {
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.rand, var4 + this.rand.nextInt(16) + 8, this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8), var5 + this.rand.nextInt(16) + 8);
            ++var10;
        }
        var10 = var4 + 8 + 0;
        while (var10 < var4 + 8 + 16) {
            var11 = var5 + 8 + 0;
            while (var11 < var5 + 8 + 16) {
                var12 = this.worldObj.getTopSolidOrLiquidBlock(var10, var11);
                if (this.worldObj.snowCovered && var12 > 0 && var12 < 128 && this.worldObj.getBlockId(var10, var12, var11) == 0 && this.worldObj.getBlockMaterial(var10, var12 - 1, var11).getIsSolid() && this.worldObj.getBlockMaterial(var10, var12 - 1, var11) != Material.ice) {
                    this.worldObj.setBlockWithNotify(var10, var12, var11, Block.snow.blockID);
                }
                ++var11;
            }
            ++var10;
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean var1, IProgressUpdate var2) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }
}

