/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EnumSkyBlock;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockSnow
extends Block {
    protected BlockSnow(int id, int tex) {
        super(id, tex, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockId(var2, var3 - 1, var4);
        return var5 != 0 && Block.blocksList[var5].isOpaqueCube() ? var1.getBlockMaterial(var2, var3 - 1, var4).getIsSolid() : false;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        this.canSnowStay(var1, var2, var3, var4);
    }

    private boolean canSnowStay(World worldObj, int x, int y, int z) {
        if (!this.canPlaceBlockAt(worldObj, x, y, z)) {
            this.dropBlockAsItem(worldObj, x, y, z, worldObj.getBlockMetadata(x, y, z));
            worldObj.setBlockWithNotify(x, y, z, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World var1, int var2, int var3, int var4, int var5) {
        int var6 = Item.snowball.shiftedIndex;
        float var7 = 0.7f;
        double var8 = (double)(var1.rand.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
        double var10 = (double)(var1.rand.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
        double var12 = (double)(var1.rand.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
        EntityItem var14 = new EntityItem(var1, (double)var2 + var8, (double)var3 + var10, (double)var4 + var12, new ItemStack(var6));
        var14.delayBeforeCanPickup = 10;
        var1.spawnEntityInWorld(var14);
        var1.setBlockWithNotify(var2, var3, var4, 0);
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Item.snowball.shiftedIndex;
    }

    @Override
    public int quantityDropped(Random var1) {
        return 0;
    }

    @Override
    public void updateTick(World worldObj, int x, int y, int z, Random rand) {
        if (worldObj.getSavedLightValue(EnumSkyBlock.Block, x, y, z) > 11) {
            this.dropBlockAsItem(worldObj, x, y, z, worldObj.getBlockMetadata(x, y, z));
            worldObj.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        Material var6 = var1.getBlockMaterial(var2, var3, var4);
        return var5 == 1 ? true : (var6 == this.material ? false : super.shouldSideBeRendered(var1, var2, var3, var4, var5));
    }
}

