/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.imagesetchooser;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.imagesetchooser.ImageSetChooserPanel;
import com.group_finity.mascot.imagesetchooser.ShimejiList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class ImageSetChooser
extends JDialog {
    private final String configFile = "./conf/settings.properties";
    private final String topDir = "./img";
    private ArrayList<String> imageSets = new ArrayList();
    private boolean closeProgram = true;
    private boolean selectAllSets = false;
    private JButton cancelButton;
    private JLabel clearAllLabel;
    private JLabel jLabel1;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel selectAllLabel;
    private JLabel slashLabel;
    private JButton useAllButton;
    private JButton useSelectedButton;

    public ImageSetChooser(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        ArrayList<String> activeImageSets = this.readConfigFile();
        ArrayList<ImageSetChooserPanel> data1 = new ArrayList<ImageSetChooserPanel>();
        ArrayList<ImageSetChooserPanel> data2 = new ArrayList<ImageSetChooserPanel>();
        ArrayList<Integer> si1 = new ArrayList<Integer>();
        ArrayList<Integer> si2 = new ArrayList<Integer>();
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.equals("unused") || name.equals(".svn")) {
                    return false;
                }
                return new File(dir + "/" + name).isDirectory();
            }
        };
        File dir = new File("./img");
        String[] children = dir.list(fileFilter);
        boolean onList1 = true;
        int row = 0;
        for (String imageSet : children) {
            String imageFile = "./img/" + imageSet + "/shime1.png";
            String actionsFile = "./conf/actions.xml";
            if (new File("./conf/" + imageSet + "/actions.xml").exists()) {
                actionsFile = "./conf/" + imageSet + "/actions.xml";
            } else if (new File("./img/" + imageSet + "/conf/actions.xml").exists()) {
                actionsFile = "./img/" + imageSet + "/conf/actions.xml";
            }
            String behaviorsFile = "./conf/behaviors.xml";
            if (new File("./conf/" + imageSet + "/behaviors.xml").exists()) {
                behaviorsFile = "./conf/" + imageSet + "/behaviors.xml";
            } else if (new File("./img/" + imageSet + "/conf/behaviors.xml").exists()) {
                behaviorsFile = "./img/" + imageSet + "/conf/behaviors.xml";
            }
            if (onList1) {
                onList1 = false;
                data1.add(new ImageSetChooserPanel(imageSet, actionsFile, behaviorsFile, imageFile));
                if (activeImageSets.contains(imageSet) || this.selectAllSets) {
                    si1.add(row);
                }
            } else {
                onList1 = true;
                data2.add(new ImageSetChooserPanel(imageSet, actionsFile, behaviorsFile, imageFile));
                if (activeImageSets.contains(imageSet) || this.selectAllSets) {
                    si2.add(row);
                }
                ++row;
            }
            this.imageSets.add(imageSet);
        }
        this.setUpList1();
        this.jList1.setListData(data1.toArray());
        this.jList1.setSelectedIndices(this.convertIntegers(si1));
        this.setUpList2();
        this.jList2.setListData(data2.toArray());
        this.jList2.setSelectedIndices(this.convertIntegers(si2));
    }

    public ArrayList<String> display() {
        this.setTitle(Main.getInstance().getLanguageBundle().getString("ShimejiImageSetChooser"));
        this.jLabel1.setText(Main.getInstance().getLanguageBundle().getString("SelectImageSetsToUse"));
        this.useSelectedButton.setText(Main.getInstance().getLanguageBundle().getString("UseSelected"));
        this.useAllButton.setText(Main.getInstance().getLanguageBundle().getString("UseAll"));
        this.cancelButton.setText(Main.getInstance().getLanguageBundle().getString("Cancel"));
        this.clearAllLabel.setText(Main.getInstance().getLanguageBundle().getString("ClearAll"));
        this.selectAllLabel.setText(Main.getInstance().getLanguageBundle().getString("SelectAll"));
        this.setVisible(true);
        if (this.closeProgram) {
            return null;
        }
        return this.imageSets;
    }

    private ArrayList<String> readConfigFile() {
        ArrayList<String> activeImageSets = new ArrayList<String>();
        activeImageSets.addAll(Arrays.asList(Main.getInstance().getProperties().getProperty("ActiveShimeji", "").split("/")));
        this.selectAllSets = ((String)activeImageSets.get(0)).trim().isEmpty();
        return activeImageSets;
    }

    private void updateConfigFile() {
        try {
            FileOutputStream output = new FileOutputStream("./conf/settings.properties");
            try {
                Main.getInstance().getProperties().setProperty("ActiveShimeji", this.imageSets.toString().replace("[", "").replace("]", "").replace(", ", "/"));
                Main.getInstance().getProperties().store(output, "Shimeji-ee Configuration Options");
            }
            finally {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jList1 = new ShimejiList();
        this.jList2 = new ShimejiList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.useSelectedButton = new JButton();
        this.useAllButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel4 = new JPanel();
        this.clearAllLabel = new JLabel();
        this.slashLabel = new JLabel();
        this.selectAllLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Shimeji-ee Image Set Chooser");
        this.setMinimumSize(new Dimension(670, 495));
        this.jScrollPane1.setPreferredSize(new Dimension(518, 100));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jList1, -1, 298, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jList2, -1, 300, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jList2, -1, 376, Short.MAX_VALUE).addComponent(this.jList1, -1, 376, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel2);
        this.jLabel1.setText("Select Image Sets to Use:");
        this.jPanel1.setLayout(new FlowLayout(1, 10, 5));
        this.useSelectedButton.setText("Use Selected");
        this.useSelectedButton.setMaximumSize(new Dimension(130, 26));
        this.useSelectedButton.setPreferredSize(new Dimension(130, 26));
        this.useSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageSetChooser.this.useSelectedButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.useSelectedButton);
        this.useAllButton.setText("Use All");
        this.useAllButton.setMaximumSize(new Dimension(95, 23));
        this.useAllButton.setMinimumSize(new Dimension(95, 23));
        this.useAllButton.setPreferredSize(new Dimension(130, 26));
        this.useAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageSetChooser.this.useAllButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.useAllButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(95, 23));
        this.cancelButton.setMinimumSize(new Dimension(95, 23));
        this.cancelButton.setPreferredSize(new Dimension(130, 26));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageSetChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.clearAllLabel.setForeground(new Color(0, 0, 204));
        this.clearAllLabel.setText("Clear All");
        this.clearAllLabel.setCursor(new Cursor(12));
        this.clearAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImageSetChooser.this.clearAllLabelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.clearAllLabel);
        this.slashLabel.setText(" / ");
        this.jPanel4.add(this.slashLabel);
        this.selectAllLabel.setForeground(new Color(0, 0, 204));
        this.selectAllLabel.setText("Select All");
        this.selectAllLabel.setCursor(new Cursor(12));
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImageSetChooser.this.selectAllLabelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.selectAllLabel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 600, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 384, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2)).addComponent(this.jPanel1, -1, 600, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jPanel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(11, 11, 11)));
        this.pack();
    }

    private void clearAllLabelMouseClicked(MouseEvent evt) {
        this.jList1.clearSelection();
        this.jList2.clearSelection();
    }

    private void selectAllLabelMouseClicked(MouseEvent evt) {
        this.jList1.setSelectionInterval(0, this.jList1.getModel().getSize() - 1);
        this.jList2.setSelectionInterval(0, this.jList2.getModel().getSize() - 1);
    }

    private void useSelectedButtonActionPerformed(ActionEvent evt) {
        this.imageSets.clear();
        for (Object obj : this.jList1.getSelectedValues()) {
            if (!(obj instanceof ImageSetChooserPanel)) continue;
            this.imageSets.add(((ImageSetChooserPanel)obj).getImageSetName());
        }
        for (Object obj : this.jList2.getSelectedValues()) {
            if (!(obj instanceof ImageSetChooserPanel)) continue;
            this.imageSets.add(((ImageSetChooserPanel)obj).getImageSetName());
        }
        this.updateConfigFile();
        this.closeProgram = false;
        this.dispose();
    }

    private void useAllButtonActionPerformed(ActionEvent evt) {
        this.closeProgram = false;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private void setUpList1() {
        this.jList1.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
    }

    private void setUpList2() {
        this.jList2.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImageSetChooser((Frame)new JFrame(), true).display();
                System.exit(0);
            }
        });
    }
}

