/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.action.Animate;
import com.group_finity.mascot.action.Move;
import com.group_finity.mascot.action.Select;
import com.group_finity.mascot.action.Sequence;
import com.group_finity.mascot.action.Stay;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.config.ActionRef;
import com.group_finity.mascot.config.AnimationBuilder;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.config.IActionBuilder;
import com.group_finity.mascot.exception.ActionInstantiationException;
import com.group_finity.mascot.exception.AnimationInstantiationException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.Variable;
import com.group_finity.mascot.script.VariableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionBuilder
implements IActionBuilder {
    private static final Logger log = Logger.getLogger(ActionBuilder.class.getName());
    private final String type;
    private final String name;
    private final String className;
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private final List<AnimationBuilder> animationBuilders = new ArrayList<AnimationBuilder>();
    private final List<IActionBuilder> actionRefs = new ArrayList<IActionBuilder>();

    public ActionBuilder(Configuration configuration, Entry actionNode, String imageSet) throws IOException {
        this.name = actionNode.getAttribute("Name");
        this.type = actionNode.getAttribute("Type");
        this.className = actionNode.getAttribute("Class");
        log.log(Level.INFO, "Read Start Operation({0})", this);
        this.getParams().putAll(actionNode.getAttributes());
        for (Entry node : actionNode.selectChildren("Animation")) {
            this.getAnimationBuilders().add(new AnimationBuilder(node, imageSet));
        }
        for (Entry node : actionNode.getChildren()) {
            if (node.getName().equals("ActionReference")) {
                this.getActionRefs().add(new ActionRef(configuration, node));
                continue;
            }
            if (!node.getName().equals("Action")) continue;
            this.getActionRefs().add(new ActionBuilder(configuration, node, imageSet));
        }
        log.log(Level.INFO, "Actions Finished Loading");
    }

    public String toString() {
        return "Action(" + this.getName() + "," + this.getType() + "," + this.getClassName() + ")";
    }

    @Override
    public Action buildAction(Map<String, String> params) throws ActionInstantiationException {
        try {
            VariableMap variables = this.createVariables(params);
            List<Animation> animations = this.createAnimations();
            List<Action> actions = this.createActions();
            if (this.type.equals("Embedded")) {
                try {
                    Class<?> cls = Class.forName(this.getClassName());
                    try {
                        return (Action)cls.getConstructor(List.class, VariableMap.class).newInstance(animations, variables);
                    }
                    catch (Exception exception) {
                        try {
                            return (Action)cls.getConstructor(VariableMap.class).newInstance(variables);
                        }
                        catch (Exception exception2) {
                            return (Action)cls.newInstance();
                        }
                    }
                }
                catch (InstantiationException e) {
                    throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("FailedClassActionInitialiseErrorMessage") + "(" + this + ")", e);
                }
                catch (IllegalAccessException e) {
                    throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("CannotAccessClassActionErrorMessage") + "(" + this + ")", e);
                }
                catch (ClassNotFoundException e) {
                    throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("ClassNotFoundErrorMessage") + "(" + this + ")", e);
                }
            }
            if (this.type.equals("Move")) {
                return new Move(animations, variables);
            }
            if (this.type.equals("Stay")) {
                return new Stay(animations, variables);
            }
            if (this.type.equals("Animate")) {
                return new Animate(animations, variables);
            }
            if (this.type.equals("Sequence")) {
                return new Sequence(variables, actions.toArray(new Action[0]));
            }
            if (this.type.equals("Select")) {
                return new Select(variables, actions.toArray(new Action[0]));
            }
            throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("UnknownActionTypeErrorMessage") + "(" + this + ")");
        }
        catch (AnimationInstantiationException e) {
            throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("FailedCreateAnimationErrorMessage") + "(" + this + ")", e);
        }
        catch (VariableException e) {
            throw new ActionInstantiationException(Main.getInstance().getLanguageBundle().getString("FailedParameterEvaluationErrorMessage") + "(" + this + ")", e);
        }
    }

    @Override
    public void validate() throws ConfigurationException {
        for (IActionBuilder ref : this.getActionRefs()) {
            ref.validate();
        }
    }

    private List<Action> createActions() throws ActionInstantiationException {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (IActionBuilder ref : this.getActionRefs()) {
            actions.add(ref.buildAction(new HashMap<String, String>()));
        }
        return actions;
    }

    private List<Animation> createAnimations() throws AnimationInstantiationException {
        ArrayList<Animation> animations = new ArrayList<Animation>();
        for (AnimationBuilder animationFactory : this.getAnimationBuilders()) {
            animations.add(animationFactory.buildAnimation());
        }
        return animations;
    }

    private VariableMap createVariables(Map<String, String> params) throws VariableException {
        VariableMap variables = new VariableMap();
        for (Map.Entry<String, String> param : this.getParams().entrySet()) {
            variables.put(param.getKey(), (Object)Variable.parse(param.getValue()));
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            variables.put(param.getKey(), (Object)Variable.parse(param.getValue()));
        }
        return variables;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    private String getClassName() {
        return this.className;
    }

    private Map<String, String> getParams() {
        return this.params;
    }

    private List<AnimationBuilder> getAnimationBuilders() {
        return this.animationBuilders;
    }

    private List<IActionBuilder> getActionRefs() {
        return this.actionRefs;
    }
}

