/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.behavior;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.action.ActionBase;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class UserBehavior
implements Behavior {
    private static final Logger log = Logger.getLogger(UserBehavior.class.getName());
    public static final String BEHAVIORNAME_FALL = "Fall";
    public static final String BEHAVIORNAME_DRAGGED = "Dragged";
    public static final String BEHAVIORNAME_THROWN = "Thrown";
    private final String name;
    private final Configuration configuration;
    private final Action action;
    private Mascot mascot;
    private boolean hidden;

    public UserBehavior(String name, Action action, Configuration configuration, boolean hidden) {
        this.name = name;
        this.configuration = configuration;
        this.action = action;
        this.hidden = hidden;
    }

    public String toString() {
        return "Behavior(" + this.getName() + ")";
    }

    @Override
    public synchronized void init(Mascot mascot) throws CantBeAliveException {
        block4: {
            this.setMascot(mascot);
            log.log(Level.INFO, "Default Behavior({0},{1})", new Object[]{this.getMascot(), this});
            try {
                this.getAction().init(mascot);
                if (this.getAction().hasNext()) break block4;
                try {
                    mascot.setBehavior(this.getConfiguration().buildBehavior(this.getName(), mascot));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingBehaviourErrorMessage"), e);
                }
            }
            catch (VariableException e) {
                throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("VariableEvaluationErrorMessage"), e);
            }
        }
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    private Action getAction() {
        return this.action;
    }

    private String getName() {
        return this.name;
    }

    @Override
    public synchronized void mousePressed(MouseEvent event) throws CantBeAliveException {
        if (SwingUtilities.isLeftMouseButton(event)) {
            boolean draggable = true;
            if (this.action != null && this.action instanceof ActionBase) {
                try {
                    draggable = ((ActionBase)this.action).isDraggable();
                }
                catch (VariableException ex) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDragActionInitialiseErrorMessage"), ex);
                }
            }
            if (draggable) {
                try {
                    this.getMascot().setBehavior(this.getConfiguration().buildBehavior(BEHAVIORNAME_DRAGGED));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDragActionInitialiseErrorMessage"), e);
                }
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent event) throws CantBeAliveException {
        if (SwingUtilities.isLeftMouseButton(event)) {
            boolean draggable = true;
            if (this.action != null && this.action instanceof ActionBase) {
                try {
                    draggable = ((ActionBase)this.action).isDraggable();
                }
                catch (VariableException ex) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDropActionInitialiseErrorMessage"), ex);
                }
            }
            if (draggable) {
                try {
                    this.getMascot().setBehavior(this.getConfiguration().buildBehavior(BEHAVIORNAME_THROWN));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedDropActionInitialiseErrorMessage"), e);
                }
            }
        }
    }

    @Override
    public synchronized void next() throws CantBeAliveException {
        block11: {
            try {
                if (this.getAction().hasNext()) {
                    this.getAction().next();
                }
                if (this.getAction().hasNext()) {
                    if (!(this.getMascot().getBounds().getX() + this.getMascot().getBounds().getWidth() <= (double)this.getEnvironment().getScreen().getLeft()) && !((double)this.getEnvironment().getScreen().getRight() <= this.getMascot().getBounds().getX()) && !((double)this.getEnvironment().getScreen().getBottom() <= this.getMascot().getBounds().getY())) break block11;
                    log.log(Level.INFO, "Out of the screen bounds({0},{1})", new Object[]{this.getMascot(), this});
                    this.getMascot().setAnchor(new Point((int)(Math.random() * (double)(this.getEnvironment().getScreen().getRight() - this.getEnvironment().getScreen().getLeft())) + this.getEnvironment().getScreen().getLeft(), this.getEnvironment().getScreen().getTop() - 256));
                    try {
                        this.getMascot().setBehavior(this.getConfiguration().buildBehavior(BEHAVIORNAME_FALL));
                        break block11;
                    }
                    catch (BehaviorInstantiationException e) {
                        throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedFallingActionInitialiseErrorMessage"), e);
                    }
                }
                log.log(Level.INFO, "Completed Behavior ({0},{1})", new Object[]{this.getMascot(), this});
                try {
                    this.getMascot().setBehavior(this.getConfiguration().buildBehavior(this.getName(), this.getMascot()));
                }
                catch (BehaviorInstantiationException e) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedInitialiseFollowingActionsErrorMessage"), e);
                }
            }
            catch (LostGroundException e) {
                log.log(Level.INFO, "Lost Ground ({0},{1})", new Object[]{this.getMascot(), this});
                try {
                    this.getMascot().setBehavior(this.getConfiguration().buildBehavior(BEHAVIORNAME_FALL));
                }
                catch (BehaviorInstantiationException ex) {
                    throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("FailedFallingActionInitialiseErrorMessage"), e);
                }
            }
            catch (VariableException e) {
                throw new CantBeAliveException(Main.getInstance().getLanguageBundle().getString("VariableEvaluationErrorMessage"), e);
            }
        }
    }

    private void setMascot(Mascot mascot) {
        this.mascot = mascot;
    }

    private Mascot getMascot() {
        return this.mascot;
    }

    protected MascotEnvironment getEnvironment() {
        return this.getMascot().getEnvironment();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

