local Dummy, super = Class(Encounter)

function Dummy:init()
    super.init(self)
    self.text = "ª the unoriginal  [color:r00ffff]S tartwalker[color:reset] can\n  see you always."
    self.music = "battle"
    self.background = true
    self:addEnemy("dummy")
    
    self.siner = 0

    -- load the startwalker
    self.example_model = Model("starwalker.dae", "tos.png")
    --attach it to the battle
    Game.battle:addChild(self.example_model)
    --move it to the center of the screen
    self.example_model:setPixelPosition(SCREEN_WIDTH/2, SCREEN_HEIGHT/2, 0)

end

function Dummy:update()
    self.siner = self.siner + DT
    --spin startwalker about the y and z axes, and make her process about the x axis
    self.example_model:rotateEuler(DT*math.sin(self.siner)*math.pi/13,  DT*math.pi/2, DT*math.pi/16)

    --move startwalker in a circle
    local dx, dy = 60 * math.cos(self.siner), 40 * math.sin(self.siner)
    self.example_model:setPixelPosition(dx + SCREEN_WIDTH/2, dy + SCREEN_HEIGHT/2 - 40, 0)

    --scale startwalker so it look like she's doing a somewhat fancy jig
    local scale_y = 0.2*( math.sin( 2*math.pi * (8/3) * self.siner ) + 1) + 0.8 --140bpm -> 8/3 hz -> 16pi/3 rad/sec
    self.example_model:setScale(1, scale_y , 1)
end

return Dummy